/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.utils.MarketUtil;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MarketOnlineVersion {
    private String title;
    private Shell shell;
    private Table table;
    private PedestalLayerInfo pedestalInfo;
    private SolutionLayerInfo solutionInfo;
    private SolutionPluginInfo pluginInfo;
    private static Logger log = Logger.getLogger(MarketOnlineVersion.class);
    private LayerType layerType;

    public MarketOnlineVersion(PedestalLayerInfo pedestalInfo) {
        this.pedestalInfo = pedestalInfo;
        this.title = pedestalInfo.getLayerName();
        this.layerType = LayerType.Obj;
    }

    public MarketOnlineVersion(SolutionLayerInfo solutionInfo, PedestalLayerInfo odj) {
        this.solutionInfo = solutionInfo;
        this.title = String.valueOf(solutionInfo.getSolutionName()) + "(" + solutionInfo.getSolutionId() + ")";
        this.layerType = LayerType.App;
        this.pedestalInfo = odj;
    }

    public MarketOnlineVersion(SolutionPluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
        this.title = StringUtils.isBlank((String)pluginInfo.getPluginName()) ? pluginInfo.getPluginId() : String.valueOf(pluginInfo.getPluginName()) + "(" + pluginInfo.getPluginId() + ")";
        this.layerType = LayerType.Plugin;
    }

    public void open() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText(this.title);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(700), SWTUtils.zoom(400));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.createContent();
        try {
            if (this.layerType.equals((Object)LayerType.Obj)) {
                this.buildPedestalTable();
            } else if (this.layerType.equals((Object)LayerType.App)) {
                this.buildAppTable();
            } else if (this.layerType.equals((Object)LayerType.Plugin)) {
                this.buildPluginTable();
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)e.getMessage());
        }
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContent() {
        TableColumn dependFramework;
        this.table = new Table((Composite)this.shell, 0x10010800);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-80));
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        this.table.setLayoutData((Object)formData);
        TableColumn versionColumn = new TableColumn(this.table, 0);
        versionColumn.setText("\u7248\u672c\u53f7");
        versionColumn.setWidth(SWTUtils.zoom(80));
        TableColumn dateColumn = new TableColumn(this.table, 0);
        dateColumn.setText("\u7248\u672c\u65e5\u671f");
        dateColumn.setWidth(SWTUtils.zoom(100));
        if (this.layerType == LayerType.App) {
            dependFramework = new TableColumn(this.table, 0);
            dependFramework.setText("\u6846\u67b6\u7248\u672c");
            dependFramework.setWidth(SWTUtils.zoom(80));
            TableColumn dependPedestal = new TableColumn(this.table, 0);
            dependPedestal.setText("\u5e95\u5ea7\u7248\u672c");
            dependPedestal.setWidth(SWTUtils.zoom(80));
        } else if (this.layerType == LayerType.Plugin) {
            dependFramework = new TableColumn(this.table, 0);
            dependFramework.setText("\u6846\u67b6\u7248\u672c");
            dependFramework.setWidth(SWTUtils.zoom(80));
            TableColumn dependApp = new TableColumn(this.table, 0);
            dependApp.setText("\u5e94\u7528\u7248\u672c");
            dependApp.setWidth(SWTUtils.zoom(80));
        }
        TableColumn summaryColumn = new TableColumn(this.table, 0);
        summaryColumn.setText("\u7248\u672c\u4ecb\u7ecd");
        if (this.layerType == LayerType.App || this.layerType == LayerType.Plugin) {
            summaryColumn.setWidth(SWTUtils.zoom(240));
        } else if (this.layerType == LayerType.Obj) {
            summaryColumn.setWidth(SWTUtils.zoom(400));
        }
        Button button_Confirm = new Button((Composite)this.shell, 8);
        button_Confirm.setText("\u786e\u8ba4");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(30));
        formData.top = new FormAttachment((Control)this.table, 0, 128);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-5));
        button_Confirm.setLayoutData((Object)formData);
        Listener listener = null;
        if (this.layerType.equals((Object)LayerType.Obj)) {
            listener = this.selectPedestalListener();
        } else if (this.layerType.equals((Object)LayerType.App)) {
            listener = this.selectSolutionListener();
        } else if (this.layerType.equals((Object)LayerType.Plugin)) {
            listener = this.selectPluginListener();
        }
        button_Confirm.addListener(3, listener);
        Button button_Cancel = new Button((Composite)this.shell, 8);
        button_Cancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(30));
        formData.top = new FormAttachment((Control)button_Confirm, SWTUtils.zoom(5), 1024);
        formData.right = new FormAttachment((Control)button_Confirm, 0, 131072);
        button_Cancel.setLayoutData((Object)formData);
        button_Cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarketOnlineVersion.this.shell.close();
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                Point point = new Point(event.x, event.y);
                TableItem tableItem = MarketOnlineVersion.this.table.getItem(point);
                if (tableItem != null) {
                    String tooltipText = tableItem.getText(MarketOnlineVersion.this.table.getColumnCount() - 1);
                    MarketOnlineVersion.this.table.setToolTipText(tooltipText);
                }
            }
        });
    }

    private Listener selectPedestalListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = MarketOnlineVersion.this.table.getSelection();
                if (selection.length <= 0) {
                    return;
                }
                TableItem item = selection[0];
                String downloadUrl = (String)item.getData();
                if (StringUtils.isBlank((String)downloadUrl)) {
                    return;
                }
                MarketOnlineVersion.this.pedestalInfo.setDownloadUrl(downloadUrl);
                MarketOnlineVersion.this.pedestalInfo.setTargetVersion(item.getText(0));
                MarketOnlineVersion.this.pedestalInfo.setOnline(true);
                MarketOnlineVersion.this.pedestalInfo.updateBindItem();
                MarketOnlineVersion.this.shell.close();
            }
        };
    }

    private Listener selectSolutionListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = MarketOnlineVersion.this.table.getSelection();
                if (selection.length <= 0) {
                    return;
                }
                TableItem item = selection[0];
                String appUserId = (String)item.getData("appUserId");
                if (StringUtils.isBlank((String)appUserId)) {
                    return;
                }
                MarketOnlineVersion.this.solutionInfo.setAppUserId(appUserId);
                MarketOnlineVersion.this.solutionInfo.setTargetVersion(item.getText(0));
                MarketOnlineVersion.this.solutionInfo.setOnline(true);
                MarketOnlineVersion.this.solutionInfo.updateBindItem();
                MarketOnlineVersion.this.shell.close();
            }
        };
    }

    private Listener selectPluginListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = MarketOnlineVersion.this.table.getSelection();
                if (selection.length <= 0) {
                    return;
                }
                TableItem item = selection[0];
                String downloadPluginId = (String)item.getData();
                if (StringUtils.isBlank((String)downloadPluginId)) {
                    return;
                }
                MarketOnlineVersion.this.pluginInfo.setTargetVersion(item.getText(0));
                MarketOnlineVersion.this.pluginInfo.setDownloadPluginId(downloadPluginId);
                MarketOnlineVersion.this.pluginInfo.setOnline(true);
                MarketOnlineVersion.this.pluginInfo.updateBindItem();
                MarketOnlineVersion.this.shell.close();
            }
        };
    }

    private void buildPedestalTable() {
        JSONArray content = MarketOnlineVersion.getPedestalVersionList(this.pedestalInfo);
        if (content == null) {
            return;
        }
        int i = 0;
        while (i < content.size()) {
            JSONObject versionInfo = JSON.parseObject((String)content.getString(i));
            String version = versionInfo.getString("version");
            String uploadDate = versionInfo.getString("upshelfDate");
            if (uploadDate.length() > 10) {
                uploadDate = uploadDate.substring(0, 10);
            }
            String descriptions = versionInfo.getString("descriptions");
            String url = versionInfo.getString("layerurl");
            TableItem subItem = new TableItem(this.table, 0);
            subItem.setText(new String[]{version, uploadDate, descriptions});
            subItem.setData((Object)url);
            if (version.equals(this.pedestalInfo.getCurrentVersion())) {
                FontData fontData = subItem.getFont().getFontData()[0];
                fontData.setStyle(1);
                subItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            ++i;
        }
        this.table.addListener(8, this.selectPedestalListener());
    }

    private void buildAppTable() {
        JSONObject content = MarketOnlineVersion.getSolutionVersionList(this.solutionInfo);
        if (content == null) {
            return;
        }
        String appUserId = content.getString("appUserId");
        JSONArray versionArray = content.getJSONArray("versionArray");
        if (versionArray == null || versionArray.isEmpty()) {
            return;
        }
        String upgradeObjeVersion = this.pedestalInfo.isOnline() != null ? this.pedestalInfo.getTargetVersion() : this.pedestalInfo.getCurrentVersion();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        int i = 0;
        while (i < versionArray.size()) {
            JSONObject versionInfo = versionArray.getJSONObject(i);
            String version = versionInfo.getString("version");
            Timestamp uploadDate = versionInfo.getTimestamp("uploadDate");
            Date date = new Date(uploadDate.getTime());
            JSONArray lines = versionInfo.getJSONArray("lines");
            String versionSummary = String.join((CharSequence)"\n", lines.toJavaList(String.class));
            String frameworkVersion = versionInfo.getString("frameworkVersion");
            String objVersion = versionInfo.getString("objVersion");
            TableItem subItem = new TableItem(this.table, 0);
            subItem.setText(new String[]{version, format.format(date), frameworkVersion, objVersion, versionSummary});
            subItem.setData("appUserId", (Object)appUserId);
            if (version.equals(this.solutionInfo.getCurrentVersion())) {
                FontData fontData = subItem.getFont().getFontData()[0];
                fontData.setStyle(1);
                subItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            if (upgradeObjeVersion.equals(objVersion)) {
                subItem.setForeground(3, Display.getDefault().getSystemColor(6));
            }
            if (ProjectConstants.Framwork_Version.equals(frameworkVersion)) {
                subItem.setForeground(2, Display.getDefault().getSystemColor(6));
            }
            subItem.setData("sysVersion", (Object)versionInfo.getString("sysVersion"));
            subItem.setData("objVersion", (Object)versionInfo.getString("objVersion"));
            subItem.setData("inyVersion", (Object)versionInfo.getString("inyVersion"));
            subItem.setData("entVersion", (Object)versionInfo.getString("entVersion"));
            ++i;
        }
        this.table.addListener(8, this.selectSolutionListener());
    }

    private void buildPluginTable() {
        JSONObject content = MarketOnlineVersion.getPlugionVersionList(this.pluginInfo);
        if (content == null) {
            return;
        }
        JSONArray pluginArray = content.getJSONArray("content");
        String appPluginId = content.getString("appPluginId");
        if (pluginArray == null || pluginArray.isEmpty() || StringUtils.isBlank((String)appPluginId)) {
            return;
        }
        SolutionLayerInfo solutionLayer = this.pluginInfo.getSolutionLayerInfo();
        String upgradeAppVersion = solutionLayer.isOnline() != null ? solutionLayer.getTargetVersion() : solutionLayer.getCurrentVersion();
        int i = 0;
        while (i < pluginArray.size()) {
            JSONObject versionInfo = pluginArray.getJSONObject(i);
            String version = versionInfo.getString("versionId");
            String versionStateName = versionInfo.getString("versionStateName");
            if ("\u5df2\u4e0a\u67b6".equals(versionStateName)) {
                String uploadDate = versionInfo.getString("date");
                if (uploadDate.length() > 10) {
                    uploadDate = uploadDate.substring(0, 10);
                }
                JSONArray lines = versionInfo.getJSONArray("versionLines");
                String versionSummary = lines.stream().map(l -> ((JSONObject)l).getString("content")).collect(Collectors.joining(System.lineSeparator()));
                TableItem subItem = new TableItem(this.table, 0);
                String frameworkVersion = versionInfo.getString("frameworkVersion");
                String appVersion = versionInfo.getString("appVersion");
                subItem.setText(new String[]{version, uploadDate, frameworkVersion, appVersion, versionSummary});
                subItem.setData((Object)appPluginId);
                if (version.equals(this.pluginInfo.getCurrentVersion())) {
                    FontData fontData = subItem.getFont().getFontData()[0];
                    fontData.setStyle(1);
                    subItem.setFont(new Font((Device)Display.getCurrent(), fontData));
                }
                if (upgradeAppVersion.equals(appVersion)) {
                    subItem.setForeground(3, Display.getDefault().getSystemColor(6));
                }
                if (ProjectConstants.Framwork_Version.equals(frameworkVersion)) {
                    subItem.setForeground(2, Display.getDefault().getSystemColor(6));
                }
                subItem.setData("sysVersion", (Object)versionInfo.getString("sysVersion"));
                subItem.setData("objVersion", (Object)versionInfo.getString("objVersion"));
                subItem.setData("inyVersion", (Object)versionInfo.getString("inyVersion"));
                subItem.setData("entVersion", (Object)versionInfo.getString("entVersion"));
                subItem.setData("appVersion", (Object)versionInfo.getString("appVersion"));
                subItem.setData("frameworkVersion", (Object)versionInfo.getString("frameworkVersion"));
            }
            ++i;
        }
        this.table.addListener(8, this.selectPluginListener());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONArray getPedestalVersionList(PedestalLayerInfo pedestalInfo) {
        String dataKey = null;
        if ("obj".equals(pedestalInfo.getLayerId())) {
            dataKey = "obj";
        } else {
            if (!"iny".equals(pedestalInfo.getLayerId())) return null;
            dataKey = "iny";
        }
        String layerLabel = pedestalInfo.getLabel();
        String doMainId = "";
        String cookieText = MarketUtil.getCookie();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                CloseableHttpResponse response;
                Throwable throwable2;
                String baseUrl;
                CloseableHttpClient httpClient;
                block28: {
                    httpClient = HttpClients.createDefault();
                    baseUrl = MarketUtil.baseUrl;
                    HttpGet httpGet = new HttpGet(String.format("%s/doMain/my/doMain", baseUrl));
                    httpGet.addHeader("Cookie", MarketUtil.getCookie());
                    Throwable throwable3 = null;
                    throwable2 = null;
                    try (CloseableHttpResponse response2 = httpClient.execute((HttpUriRequest)httpGet);){
                        HttpEntity entity;
                        JSONObject responseResult;
                        if (response2.getStatusLine().getStatusCode() != 200 || (responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(entity = response2.getEntity()), (String)"utf-8"))).getIntValue("errcode") != 0) break block28;
                        JSONArray layerList = responseResult.getJSONArray("content");
                        int i = 0;
                        while (i < layerList.size()) {
                            JSONObject layer = layerList.getJSONObject(i);
                            String doMain = layer.getString("doMain");
                            if (!doMain.equals(layerLabel)) {
                                ++i;
                                continue;
                            }
                            doMainId = layer.getString("id");
                            break;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                            throw throwable3;
                        }
                        if (throwable3 == throwable4) throw throwable3;
                        throwable3.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
                HttpPost httpPost = new HttpPost(String.format("%s/doMain/operatorDoMainlayersNew?doMain=%s&doMainId=%s&isTrial=false&operator=%s&TrailCode=%s", baseUrl, layerLabel, doMainId, "\u5de5\u4f01\u6d4b\u8bd5", MarketUtil.getExperienceCode()));
                httpPost.addHeader("Cookie", cookieText);
                throwable2 = null;
                Object var12_18 = null;
                try {
                    block30: {
                        JSONArray jSONArray;
                        block31: {
                            HttpEntity entity;
                            JSONObject responseResult;
                            response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() != 200 || (responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(entity = response.getEntity()), (String)"utf-8"))).getIntValue("errcode") != 0) break block29;
                            JSONArray content = responseResult.getJSONArray(dataKey);
                            String id = doMainId;
                            Optional<Object> optional = content.stream().filter(d -> id.equals(((JSONObject)d).getString("domainId"))).findFirst();
                            if (!optional.isPresent()) break block30;
                            jSONArray = ((JSONObject)optional.get()).getJSONArray("content");
                            if (response == null) break block31;
                            response.close();
                        }
                        if (httpClient == null) return jSONArray;
                        httpClient.close();
                        return jSONArray;
                    }
                    if (response != null) {
                        response.close();
                    }
                    if (httpClient == null) return null;
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                        throw throwable2;
                    }
                    if (throwable2 == throwable5) throw throwable2;
                    throwable2.addSuppressed(throwable5);
                    throw throwable2;
                }
                {
                    block29: {
                        httpClient.close();
                        return null;
                    }
                    if (response == null) return null;
                    response.close();
                    return null;
                    catch (Throwable throwable6) {
                        if (response == null) throw throwable6;
                        response.close();
                        throw throwable6;
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u7248\u672c\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject getSolutionVersionList(SolutionLayerInfo solutionInfo) {
        String cookieText = MarketUtil.getCookie();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                CloseableHttpResponse response;
                block16: {
                    String baseUrl = MarketUtil.baseUrl;
                    HttpGet httpGet = new HttpGet(String.format("%s/developer/appInfo?appId=%s&trailCode=%s", baseUrl, solutionInfo.getSolutionId(), MarketUtil.getExperienceCode()));
                    httpGet.addHeader("Cookie", cookieText);
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try {
                        JSONObject jSONObject;
                        response = httpClient.execute((HttpUriRequest)httpGet);
                        try {
                            HttpEntity entity;
                            JSONObject responseResult;
                            if (response.getStatusLine().getStatusCode() != 200 || (responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(entity = response.getEntity()), (String)"utf-8"))).getIntValue("errcode") != 0) break block16;
                            jSONObject = responseResult.getJSONObject("content");
                            if (response == null) return jSONObject;
                        }
                        catch (Throwable throwable3) {
                            if (response == null) throw throwable3;
                            response.close();
                            throw throwable3;
                        }
                        response.close();
                        return jSONObject;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                if (response == null) return null;
                response.close();
                return null;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u7248\u672c\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject getPlugionVersionList(SolutionPluginInfo pluginInfo) {
        JSONArray content;
        JSONObject responseResult;
        HttpEntity entity;
        CloseableHttpResponse response;
        Object var10_18;
        Throwable throwable;
        HttpGet httpGet;
        CloseableHttpClient httpClient;
        Object var6_10;
        String appPluginId;
        String baseUrl;
        String cookieText;
        block35: {
            cookieText = MarketUtil.getCookie();
            baseUrl = MarketUtil.baseUrl;
            String appId = pluginInfo.getSolutionLayerInfo().getSolutionId();
            appPluginId = "";
            try {
                Throwable throwable2 = null;
                var6_10 = null;
                try {
                    httpClient = HttpClients.createDefault();
                    try {
                        httpGet = new HttpGet(String.format("%s/appuser/PluginlistNew?isActive=false&aboutMe=false&info=%s&", baseUrl, appId));
                        httpGet.addHeader("Cookie", MarketUtil.getCookie());
                        throwable = null;
                        var10_18 = null;
                        try {
                            response = httpClient.execute((HttpUriRequest)httpGet);
                            try {
                                if (response.getStatusLine().getStatusCode() != 200) throw new RuntimeException("\u5e94\u7528\u5e02\u573a\u7f51\u7edc\u8bf7\u6c42\u9519\u8bef, http code=" + response.getStatusLine().getStatusCode());
                                entity = response.getEntity();
                                responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                                if (responseResult.getIntValue("errcode") != 0) break block35;
                                content = responseResult.getJSONArray("content");
                                int i = 0;
                                while (i < content.size()) {
                                    String pluginNameSpace;
                                    JSONObject app = content.getJSONObject(i);
                                    String solutionId = app.getString("AppId");
                                    if (solutionId.equals(appId) && (pluginNameSpace = app.getString("PluginNameSpace")).equals(pluginInfo.getPluginId())) {
                                        appPluginId = app.getString("AppPluginId");
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            finally {
                                if (response != null) {
                                    response.close();
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    finally {
                        if (httpClient != null) {
                            httpClient.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
                throw new RuntimeException("\u67e5\u8be2\u63d2\u4ef6\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
            }
        }
        if (StringUtils.isBlank((String)appPluginId)) {
            return null;
        }
        try {
            Throwable e = null;
            var6_10 = null;
            try {
                httpClient = HttpClients.createDefault();
                try {
                    block36: {
                        httpGet = new HttpGet(String.format("%s/developer/version/pluginHistory?pluginId=%s&isTrial=false&trialCode=%s", baseUrl, appPluginId, MarketUtil.getExperienceCode()));
                        httpGet.addHeader("Cookie", cookieText);
                        throwable = null;
                        var10_18 = null;
                        try {
                            JSONObject jSONObject;
                            response = httpClient.execute((HttpUriRequest)httpGet);
                            try {
                                if (response.getStatusLine().getStatusCode() != 200 || (responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(entity = response.getEntity()), (String)"utf-8"))).getIntValue("errcode") != 0) break block36;
                                content = responseResult.getJSONArray("content");
                                JSONObject result = new JSONObject();
                                result.put("content", (Object)content);
                                result.put("appPluginId", (Object)appPluginId);
                                jSONObject = result;
                                if (response == null) return jSONObject;
                            }
                            catch (Throwable throwable5) {
                                if (response == null) throw throwable5;
                                response.close();
                                throw throwable5;
                            }
                            response.close();
                            return jSONObject;
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                                throw throwable;
                            }
                            if (throwable == throwable6) throw throwable;
                            throwable.addSuppressed(throwable6);
                            throw throwable;
                        }
                    }
                    if (response == null) return null;
                    response.close();
                    return null;
                }
                finally {
                    if (httpClient != null) {
                        httpClient.close();
                    }
                }
            }
            catch (Throwable throwable7) {
                if (e == null) {
                    e = throwable7;
                    throw e;
                }
                if (e == throwable7) throw e;
                e.addSuppressed(throwable7);
                throw e;
            }
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u7248\u672c\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public static boolean setLastSolutionVersion(SolutionLayerInfo solutionInfo, String objVersion) {
        JSONObject content = MarketOnlineVersion.getSolutionVersionList(solutionInfo);
        if (content == null) {
            return false;
        }
        String appUserId = content.getString("appUserId");
        JSONArray versionArray = content.getJSONArray("versionArray");
        if (versionArray == null || versionArray.isEmpty() || StringUtils.isBlank((String)appUserId)) {
            return false;
        }
        Optional<Object> findFirst = versionArray.stream().filter(p -> objVersion.equals(((JSONObject)p).getString("objVersion"))).findFirst();
        if (findFirst.isPresent()) {
            JSONObject versionInfo = (JSONObject)findFirst.get();
            solutionInfo.setAppUserId(appUserId.toString());
            solutionInfo.setTargetVersion(versionInfo.getString("version"));
            solutionInfo.setOnline(true);
            solutionInfo.updateBindItem();
            return true;
        }
        return false;
    }

    public static boolean setLastPluginVersion(SolutionPluginInfo pluginInfo) {
        JSONObject content = MarketOnlineVersion.getPlugionVersionList(pluginInfo);
        if (content == null) {
            return false;
        }
        JSONArray pluginArray = content.getJSONArray("content");
        String appPluginId = content.getString("appPluginId");
        String targetVersion = pluginInfo.getSolutionLayerInfo().getTargetVersion();
        if (StringUtils.isBlank((String)targetVersion) || pluginArray == null || pluginArray.isEmpty() || StringUtils.isBlank((String)appPluginId)) {
            return false;
        }
        Optional<Object> findFirst = pluginArray.stream().filter(p -> targetVersion.equals(((JSONObject)p).getString("appVersion"))).findFirst();
        if (findFirst.isPresent()) {
            JSONObject versionInfo = (JSONObject)findFirst.get();
            pluginInfo.setTargetVersion(versionInfo.getString("versionId"));
            pluginInfo.setDownloadPluginId(appPluginId);
            pluginInfo.setOnline(true);
            pluginInfo.updateBindItem();
            return true;
        }
        return false;
    }

    public static JSONObject getSolutionVersionInfo(SolutionLayerInfo solutionInfo, String version) {
        JSONObject content = MarketOnlineVersion.getSolutionVersionList(solutionInfo);
        if (content == null) {
            return null;
        }
        String appUserId = content.getString("appUserId");
        JSONArray versionArray = content.getJSONArray("versionArray");
        if (versionArray == null || versionArray.isEmpty() || StringUtils.isBlank((String)appUserId)) {
            return null;
        }
        Optional<Object> findFirst = versionArray.stream().filter(p -> version.equals(((JSONObject)p).getString("version"))).findFirst();
        if (findFirst.isPresent()) {
            JSONObject versionInfo = (JSONObject)findFirst.get();
            return versionInfo;
        }
        return null;
    }

    public static JSONObject getPluginVersionInfo(SolutionPluginInfo pluginInfo, String version) {
        JSONObject content = MarketOnlineVersion.getPlugionVersionList(pluginInfo);
        if (content == null) {
            return null;
        }
        JSONArray pluginArray = content.getJSONArray("content");
        Optional<Object> findFirst = pluginArray.stream().filter(p -> version.equals(((JSONObject)p).getString("versionId"))).findFirst();
        if (findFirst.isPresent()) {
            JSONObject versionInfo = (JSONObject)findFirst.get();
            return versionInfo;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject getSolutionAndPlgVersionBatch(Map<String, SolutionLayerInfo> solutionInfos) {
        if (solutionInfos.isEmpty()) {
            return null;
        }
        String cookieText = MarketUtil.getCookie();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                String baseUrl = MarketUtil.baseUrl;
                HttpPost httpPost = new HttpPost(String.format("%s/developer/appandplugindetail", baseUrl));
                httpPost.addHeader("Cookie", cookieText);
                JSONObject requestBody = new JSONObject();
                JSONArray apps = new JSONArray();
                JSONArray plugins = new JSONArray();
                for (SolutionLayerInfo solutionLayerInfo : solutionInfos.values()) {
                    if (solutionLayerInfo.getDeploymentMode() == SolutionDeploymentMode.Package) {
                        apps.add((Object)solutionLayerInfo.getSolutionId());
                    }
                    List<SolutionPluginInfo> pluginInfos = solutionLayerInfo.getPluginInfos();
                    for (SolutionPluginInfo pluginInfo : pluginInfos) {
                        if (pluginInfo.getDeploymentMode() != SolutionPluginDeploymentMode.Package) continue;
                        plugins.add((Object)pluginInfo.getPluginId());
                    }
                }
                requestBody.put("apps", (Object)apps);
                requestBody.put("plugins", (Object)plugins);
                requestBody.put("operator", (Object)"\u5de5\u4f01\u6d4b\u8bd5");
                String experienceCode = MarketUtil.getExperienceCode();
                if (StringUtils.isNotBlank((String)experienceCode)) {
                    requestBody.put("trailCode", (Object)experienceCode);
                }
                httpPost.setEntity((HttpEntity)new StringEntity(requestBody.toJSONString(), StandardCharsets.UTF_8));
                Object object = null;
                Object var12_16 = null;
                try {
                    CloseableHttpResponse response;
                    block24: {
                        response = httpClient.execute((HttpUriRequest)httpPost);
                        if (response.getStatusLine().getStatusCode() != 200) break block24;
                        HttpEntity entity = response.getEntity();
                        JSONObject responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                        if (responseResult.getIntValue("errcode") != 0) return null;
                        JSONObject jSONObject = responseResult.getJSONObject("content");
                        if (response == null) return jSONObject;
                        response.close();
                        return jSONObject;
                    }
                    try {
                        System.out.println(response.getStatusLine().getStatusCode());
                        return null;
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (object == null) {
                        object = throwable3;
                        throw object;
                    }
                    if (object == throwable3) throw object;
                    ((Throwable)object).addSuppressed(throwable3);
                    throw object;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u7248\u672c\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public static void checVersionNew(Map<String, SolutionLayerInfo> solutionInfos) {
        new Thread(() -> {
            JSONArray plugins;
            JSONObject content = MarketOnlineVersion.getSolutionAndPlgVersionBatch(solutionInfos);
            if (content == null) {
                return;
            }
            JSONArray apps = content.getJSONArray("apps");
            if (apps != null) {
                int i = 0;
                while (i < apps.size()) {
                    JSONObject app = apps.getJSONObject(i);
                    String appId = app.getString("appId");
                    JSONArray versionobj = app.getJSONArray("versionobj");
                    List versions = versionobj.stream().filter(a -> {
                        JSONObject obj = (JSONObject)a;
                        String isTrial = obj.getString("isTrial");
                        String versionStateName = obj.getString("versionStateName");
                        if ("\u5f85\u4e0a\u67b6".equals(versionStateName)) {
                            return "true".equals(isTrial);
                        }
                        return true;
                    }).map(a -> ((JSONObject)a).getString("version")).collect(Collectors.toList());
                    if (solutionInfos.containsKey(appId) && versions != null && !versions.isEmpty()) {
                        SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(appId);
                        String currentVersion = solutionLayerInfo.getCurrentVersion();
                        solutionLayerInfo.setHasNewVersion(MarketOnlineVersion.compareVersion((String)versions.get(0), currentVersion));
                        Display.getDefault().asyncExec(() -> solutionLayerInfo.updateBindItem());
                    }
                    ++i;
                }
            }
            if ((plugins = content.getJSONArray("plugins")) != null) {
                Map<String, JSONObject> plgs = plugins.stream().map(JSONObject.class::cast).collect(Collectors.toMap(obj -> obj.getString("pluginId"), obj -> obj));
                Map<String, SolutionPluginInfo> pluginInfos = solutionInfos.values().stream().flatMap(s -> s.getPluginInfos().stream()).collect(Collectors.toMap(p -> p.getPluginId(), p -> p));
                for (SolutionPluginInfo pluginInfo : pluginInfos.values()) {
                    JSONObject plugin;
                    JSONArray versions;
                    if (!plgs.containsKey(pluginInfo.getPluginId()) || (versions = (plugin = plgs.get(pluginInfo.getPluginId())).getJSONArray("versions")) == null || versions.isEmpty()) continue;
                    String currentVersion = pluginInfo.getCurrentVersion();
                    pluginInfo.setHasNewVersion(MarketOnlineVersion.compareVersion(versions.getString(0), currentVersion));
                    Display.getDefault().asyncExec(() -> pluginInfo.updateBindItem());
                }
            }
        }).start();
    }

    private static boolean compareVersion(String marketVersion, String localVersion) {
        String localPrefix;
        if (marketVersion.equals(localVersion)) {
            return false;
        }
        String[] marketVersions = marketVersion.split("\\.");
        String[] localVersions = localVersion.split("\\.");
        if (marketVersions.length != 3 && localVersions.length != 3) {
            return true;
        }
        String marketPrefix = String.valueOf(marketVersions[0]) + marketVersions[1];
        if (marketPrefix.equals(localPrefix = String.valueOf(localVersions[0]) + localVersions[1])) {
            return marketVersions[2].compareTo(localVersions[2]) > 0;
        }
        return marketPrefix.compareTo(localVersion) > 0;
    }

    public static void versionMatch(final String objVersion, final Map<String, SolutionLayerInfo> solutionInfos) {
        final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Display.getDefault().syncExec(() -> progressMonitorDialog.getShell().setText("\u7248\u672c\u5339\u914d"));
                    monitor.beginTask("\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u7248\u672c\u4fe1\u606f", 10);
                    monitor.worked(3);
                    JSONObject content = MarketOnlineVersion.getSolutionAndPlgVersionBatch(solutionInfos);
                    monitor.worked(3);
                    if (content == null) {
                        return;
                    }
                    JSONArray apps = content.getJSONArray("apps");
                    if (apps == null) {
                        return;
                    }
                    monitor.setTaskName("\u6b63\u5728\u5339\u914d\u5e94\u7528...");
                    int i = 0;
                    while (i < apps.size()) {
                        JSONObject app = apps.getJSONObject(i);
                        String appId = app.getString("appId");
                        JSONArray versionobj = app.getJSONArray("versionobj");
                        if (solutionInfos.containsKey(appId)) {
                            SolutionLayerInfo solutionInfo = (SolutionLayerInfo)solutionInfos.get(appId);
                            monitor.subTask(String.format("\u6b63\u5728\u5339\u914d\u3010%s\u3011", solutionInfo.getSolutionId()));
                            Optional<Object> findFirst = versionobj.stream().filter(p -> objVersion.equals(((JSONObject)p).getString("objVersion"))).findFirst();
                            if (findFirst.isPresent()) {
                                JSONObject versionInfo = (JSONObject)findFirst.get();
                                solutionInfo.setAppUserId(app.getString("appUserId"));
                                solutionInfo.setTargetVersion(versionInfo.getString("version"));
                                solutionInfo.setOnline(true);
                                Display.getDefault().asyncExec(() -> solutionInfo.updateBindItem());
                            }
                        }
                        ++i;
                    }
                    monitor.worked(2);
                    JSONArray plugins = content.getJSONArray("plugins");
                    if (plugins == null) {
                        monitor.done();
                        return;
                    }
                    Map<String, JSONObject> plgs = plugins.stream().map(JSONObject.class::cast).collect(Collectors.toMap(obj -> obj.getString("pluginId"), obj -> obj));
                    Map<String, SolutionPluginInfo> pluginInfos = solutionInfos.values().stream().flatMap(s -> s.getPluginInfos().stream()).collect(Collectors.toMap(p -> p.getPluginId(), p -> p));
                    monitor.setTaskName("\u6b63\u5728\u5339\u914d\u63d2\u4ef6...");
                    for (SolutionPluginInfo pluginInfo : pluginInfos.values()) {
                        Optional<Object> findFirst;
                        monitor.subTask(String.format("\u6b63\u5728\u5339\u914d\u3010%s\u3011", pluginInfo.getPluginId()));
                        if (!plgs.containsKey(pluginInfo.getPluginId())) continue;
                        JSONObject plg = plgs.get(pluginInfo.getPluginId());
                        JSONArray versionobj = plg.getJSONArray("versionobj");
                        String appTargetVersion = pluginInfo.getSolutionLayerInfo().getTargetVersion();
                        if (StringUtils.isBlank((String)appTargetVersion) || !(findFirst = versionobj.stream().filter(p -> appTargetVersion.equals(((JSONObject)p).getString("appVersion"))).findFirst()).isPresent()) continue;
                        JSONObject versionInfo = (JSONObject)findFirst.get();
                        pluginInfo.setTargetVersion(versionInfo.getString("versionId"));
                        pluginInfo.setDownloadPluginId(plg.getString("appPluginId"));
                        pluginInfo.setOnline(true);
                        Display.getDefault().asyncExec(() -> pluginInfo.updateBindItem());
                    }
                    monitor.worked(2);
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.error((Object)"\u7248\u672c\u5339\u914d\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
            if (e instanceof InvocationTargetException) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u63d0\u793a", (String)e.getCause().getMessage());
            }
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"\u63d0\u793a", (String)e.getMessage());
        }
    }

    private static enum LayerType {
        Obj,
        App,
        Plugin;

    }
}

