/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.erp.framework.core.FrameworkEnvironment;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.LayerDefiner;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.extension.SolutionExtensionLocator;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginResolver;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionLocator;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.tools.ZipUtil;
import gongqi.erp.framework.tools.io.FileIOXML;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.ProgressMonitor;
import gongqi.gdt.designer.service.analysis.ClassAnalysis;
import gongqi.gdt.designer.service.analysis.DataTypeAnalysis;
import gongqi.gdt.designer.service.analysis.EnumAnalysis;
import gongqi.gdt.designer.service.analysis.FormAnalysis;
import gongqi.gdt.designer.service.analysis.MenuAnalysis;
import gongqi.gdt.designer.service.analysis.MenuItemAnalysis;
import gongqi.gdt.designer.service.analysis.TableAnalysis;
import gongqi.gdt.designer.service.modify.ClassModify;
import gongqi.gdt.designer.service.modify.DataTypeModify;
import gongqi.gdt.designer.service.modify.EnumModify;
import gongqi.gdt.designer.service.modify.FormModify;
import gongqi.gdt.designer.service.modify.MenuItemModify;
import gongqi.gdt.designer.service.modify.MenuModify;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.TableModify;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.ui.AnalysisResultPage;
import gongqi.gdt.designer.ui.NodeRelationErrorDialog;
import gongqi.gdt.designer.utils.LayerJavaCode;
import gongqi.gdt.designer.utils.LayerUpgradeHelper;
import gongqi.gdt.designer.utils.MergeDatabaseUtil;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.SolutionExtInfo;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import info.gongqi.got.datadictionary.Datadictionary;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class LayerUpgradeService {
    private static Logger log = Logger.getLogger(LayerUpgradeService.class);
    private GOTModel sourceGOT;
    private GOTModel targetGOT;
    private GOTModel originalGOT;
    private Collection<File> layerFiles;
    private Collection<File> solutionFiles;
    private Collection<File> solutionPluginFiles;
    private Collection<File> solutionExtensionFiles;

    public void setLayerFiles(Collection<File> layerFiles) {
        this.layerFiles = layerFiles;
    }

    public void setSolutionFiles(Collection<File> solutionFiles) {
        this.solutionFiles = solutionFiles;
    }

    public void setSolutionPluginFiles(Collection<File> solutionPluginFiles) {
        this.solutionPluginFiles = solutionPluginFiles;
    }

    public void setSolutionExtensionFiles(Collection<File> solutionExtensionFiles) {
        this.solutionExtensionFiles = solutionExtensionFiles;
    }

    public void initGOTModel(IProgressMonitor monitor) {
        try {
            monitor.subTask("\u52a0\u8f7d\u5f53\u524d\u5c42\u6a21\u578b");
            log.debug((Object)"\u52a0\u8f7d\u5f53\u524d\u5c42\u6a21\u578b");
            this.initSourceGOTModel();
            this.sourceGOT.catchRefInnerId();
            monitor.worked(1);
            monitor.subTask("\u52a0\u8f7d\u5347\u7ea7\u5c42\u6a21\u578b");
            log.debug((Object)"\u52a0\u8f7d\u5347\u7ea7\u5c42\u6a21\u578b");
            if (this.targetGOT == null) {
                this.initTargetGOTModel(this.layerFiles, this.solutionFiles, this.solutionPluginFiles, this.solutionExtensionFiles);
            }
            monitor.worked(1);
            monitor.subTask("\u52a0\u8f7d\u8fc7\u6e21\u5c42\u6a21\u578b");
            log.debug((Object)"\u52a0\u8f7d\u8fc7\u6e21\u5c42\u6a21\u578b");
            this.initOriginalTargetGOTModel();
            monitor.worked(1);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790\u5c42\u6a21\u578b\u9519\u8bef", e);
        }
    }

    public void analysis(ProgressMonitor monitor) throws VTDException, IOException {
        HashSet<String> entityIds = new HashSet<String>();
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Enum).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.DataType).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Table).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Form).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.MenuItem).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Menu).keySet());
        entityIds.addAll(this.sourceGOT.getEntitys(EntityType.Class).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Enum).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.DataType).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Table).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Form).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.MenuItem).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Menu).keySet());
        entityIds.addAll(this.targetGOT.getEntitys(EntityType.Class).keySet());
        monitor.beginTask(entityIds.size() * 2 + 1);
        monitor.setTaskName("\u30104/4\u3011\u6b63\u5728\u8fdb\u884c\u5c42\u94fe\u5bf9\u6bd4...");
        Throwable throwable = null;
        try {
            CompletableFuture.allOf(CompletableFuture.runAsync(() -> {
                new EnumAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
                new DataTypeAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
                new TableAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            }), CompletableFuture.runAsync(() -> new FormAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor)), CompletableFuture.runAsync(() -> {
                new MenuItemAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
                new MenuAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
                new ClassAnalysis(this.sourceGOT, this.targetGOT, this.originalGOT).analysis(monitor);
            })).get();
        }
        catch (Throwable e) {
            throwable = e;
        }
        monitor.done(throwable);
        this.sourceGOT.clearCatchRefInnerId();
    }

    public void modifys(File backupLayerFile, Map<String, PedestalLayerInfo> pedestalInfos, Map<String, SolutionLayerInfo> solutionInfos, Element modifyElements, ProgressMonitor monitor) throws Exception {
        if (this.sourceGOT.getTopLayerDefination().getDeploymentMode() != LayerDeploymentMode.Source) {
            throw new ERPException("\u5f53\u524d\u5c42\u6e90\u7801\u5c42\uff0c\u65e0\u6cd5\u5347\u7ea7");
        }
        List cannotModifyItems = modifyElements.selectNodes(String.format("//ModifyItem[@modifyLevel='%s']", ModifyLevel.Cannot.name()));
        if (cannotModifyItems.size() > 0) {
            throw new ERPException("\u5b58\u5728\u4e0d\u80fd\u5347\u7ea7\u7684\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7");
        }
        monitor.beginTask(0);
        Throwable throwable = null;
        try {
            Element enumModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/Enums");
            new EnumModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(enumModifys, monitor);
            Element dataTypeModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/DataTypes");
            new DataTypeModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(dataTypeModifys, monitor);
            Element tableModifys = (Element)modifyElements.selectSingleNode("./DataDictionary/Tables");
            new TableModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(tableModifys, monitor);
            Element formModifys = (Element)modifyElements.selectSingleNode("./Forms");
            new FormModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(formModifys, monitor);
            Element menuItemModifys = (Element)modifyElements.selectSingleNode("./MenuItems");
            new MenuItemModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(menuItemModifys, monitor);
            Element menuModifys = (Element)modifyElements.selectSingleNode("./Menus");
            new MenuModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(menuModifys, monitor);
            Element classModifys = (Element)modifyElements.selectSingleNode("./Classes");
            new ClassModify(this.sourceGOT, this.targetGOT, this.originalGOT).modify(classModifys, monitor);
        }
        catch (Throwable e) {
            throwable = e;
        }
        if (throwable == null) {
            Set<String> solutionIds = solutionInfos.values().stream().filter(s -> StringUtils.isNotBlank((String)s.getTargetVersion())).map(s -> s.getSolutionId()).collect(Collectors.toSet());
            final ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
            results.addAll(this.checkRelation(this.sourceGOT.getEntitys(EntityType.Enum), solutionIds));
            results.addAll(this.checkRelation(this.sourceGOT.getEntitys(EntityType.DataType), solutionIds));
            results.addAll(this.checkRelation(this.sourceGOT.getEntitys(EntityType.Table), solutionIds));
            results.addAll(this.checkRelation(this.sourceGOT.getEntitys(EntityType.Form), solutionIds));
            results.addAll(this.checkRelation(this.sourceGOT.getEntitys(EntityType.MenuItem), solutionIds));
            results.addAll(this.checkRelation(this.sourceGOT.getEntitys(EntityType.Menu), solutionIds));
            if (results.size() > 0) {
                new Thread(() -> Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NodeRelationErrorDialog dialog = new NodeRelationErrorDialog("\u5347\u7ea7\u540e\u8282\u70b9\u5f15\u7528\u5f02\u5e38", results);
                        dialog.open();
                    }
                })).start();
                monitor.done(new RuntimeException("\u5347\u7ea7\u540e\u5c42\u6a21\u578b\u5f15\u7528\u5f02\u5e38"));
                return;
            }
            this.saveGOTEntitys();
            this.deployFiles();
            monitor.setTaskName("\u6b63\u5728\u8fdb\u884c\u7ed3\u6784\u62df\u5408...");
            this.mergeDatabase(backupLayerFile, pedestalInfos, solutionInfos, monitor);
        }
        monitor.done(throwable);
    }

    private EntityType getEntityTypeById(String entityId) {
        if (StringUtils.isBlank((String)entityId)) {
            return null;
        }
        if (entityId.contains(".")) {
            entityId = entityId.substring(entityId.lastIndexOf(".") + 1);
        }
        if (entityId.startsWith("10")) {
            return EntityType.Enum;
        }
        if (entityId.startsWith("20")) {
            return EntityType.DataType;
        }
        if (entityId.startsWith("30")) {
            return EntityType.Table;
        }
        if (entityId.startsWith("40")) {
            return EntityType.Form;
        }
        if (entityId.startsWith("50")) {
            return EntityType.MenuItem;
        }
        if (entityId.startsWith("60")) {
            return EntityType.Menu;
        }
        if (entityId.startsWith("73")) {
            return EntityType.Report;
        }
        if (entityId.startsWith("80")) {
            return EntityType.Class;
        }
        return null;
    }

    private List<Map<String, String>> checkRelation(Map<String, GOTEntity> entitys, Set<String> solutionIds) {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (GOTEntity entity : entitys.values()) {
            LayerDefination layerDefination = this.sourceGOT.getLayerDefination(entity.getModifiedLayer());
            if (layerDefination.getLayerName().equals("app")) {
                SolutionDefinition solutionDefinition;
                String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                if (!solutionIds.contains(solutionName) || (solutionDefinition = LayerUpgradeHelper.getInstance().getSolutionDefinition(solutionName)) == null || solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Source) {
                    continue;
                }
            } else if (layerDefination.getLayerName().equals("plg")) {
                String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionPluginDefinition pluginDefinition = LayerUpgradeHelper.getInstance().getSolutionPluginDefinition(solutionPluginName);
                if (pluginDefinition == null || pluginDefinition.getDeploymentMode() != SolutionPluginDeploymentMode.Source || !solutionIds.contains(pluginDefinition.getSolutionName())) {
                    continue;
                }
            } else if (layerDefination.getLayerName().equals("ext")) {
                String namespace = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = null;
                if (entity.getCreatedLayer().equals("plg")) {
                    SolutionPluginDefinition solutionPluginDefinition = LayerUpgradeHelper.getInstance().getSolutionPluginDefinition(namespace);
                    solutionExtensionDefinition = LayerUpgradeHelper.getInstance().getSolutionExtensionDefinition(solutionPluginDefinition.getSolutionName());
                } else {
                    solutionExtensionDefinition = LayerUpgradeHelper.getInstance().getSolutionExtensionDefinition(namespace);
                }
                if (solutionExtensionDefinition == null || solutionExtensionDefinition.getDeploymentMode() != SolutionExtensionDeploymentMode.Source || !solutionIds.contains(solutionExtensionDefinition.getSolutionName())) {
                    continue;
                }
            } else if (layerDefination.getDeploymentMode() != LayerDeploymentMode.Source) continue;
            List<GOTProperty> propertys = entity.selectPropertys("//Property[@refentityid]");
            for (GOTProperty property : propertys) {
                GOTNode gotNode = property.getGOTNode();
                if (gotNode.getCreatedLayer().equals("app") && gotNode.getModifiedLayer().equals("plg")) continue;
                try {
                    GOTNode refNode;
                    GOTEntity refEntity;
                    String refEntityId = property.getRefEntityId();
                    String refInnerId = property.getRefInnerId();
                    EntityType refEntityTye = this.getEntityTypeById(refEntityId);
                    if (refEntityTye == null) {
                        map = new HashMap();
                        map.put("entity", String.format("%s\u3010%s\u3011", entity.getNodeType(), entity.getName()));
                        map.put("inner", String.format("%s\u3010%s\u3011", gotNode.getNodeType(), gotNode.getName()));
                        map.put("property", property.getName());
                        map.put("description", "RefEntityId\u7684\u975e\u6cd5");
                        results.add(map);
                    }
                    if ((refEntity = this.getEntityInFinal(refEntityTye, refEntityId, gotNode.getCreatedLayer(), gotNode.getId(), entity.getId())) == null) {
                        map = new HashMap();
                        map.put("entity", String.format("%s\u3010%s\u3011", entity.getNodeType(), entity.getName()));
                        map.put("inner", String.format("%s\u3010%s\u3011", gotNode.getNodeType(), gotNode.getName()));
                        map.put("property", property.getName());
                        map.put("description", String.format("\u5f15\u7528\u7684\u5b9e\u4f53\u8282\u70b9\u3010%s\u3011\u4e0d\u5b58\u5728", refEntityId));
                        results.add(map);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((String)refInnerId) || (refNode = refEntity.selectSingleNode(String.format("//*[@id='%s']", refInnerId))) != null) continue;
                    map = new HashMap();
                    map.put("entity", String.format("%s\u3010%s\u3011", entity.getNodeType(), entity.getName()));
                    map.put("inner", String.format("%s\u3010%s\u3011", gotNode.getNodeType(), gotNode.getName()));
                    map.put("property", property.getName());
                    map.put("description", String.format("\u5f15\u7528\u7684\u5b9e\u4f53\u3010%s\u3011\u7684\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u4e0d\u5b58\u5728", refEntityId, refInnerId));
                    results.add(map);
                }
                catch (NavException e) {
                    log.error((Object)"VTD\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return results;
    }

    private GOTEntity getEntityInFinal(EntityType refEntityTye, String refEntityId, String createLayer, String nodeId, String entityId) {
        if (this.sourceGOT.isSourceDeployment(createLayer, entityId, nodeId)) {
            return this.sourceGOT.getEntityById(refEntityTye, refEntityId);
        }
        return this.targetGOT.getEntityById(refEntityTye, refEntityId);
    }

    private void saveGOTEntitys() throws VTDException, IOException, DocumentException {
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Enum));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.DataType));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Table));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Form));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.MenuItem));
        this.writeEntityFile(this.sourceGOT.getEntitys(EntityType.Menu));
        for (GOTEntity entity : this.sourceGOT.getRemoveEntitys()) {
            File layerJavaPath;
            File layerGOTPath;
            String solutionName;
            LayerDefination layerDefination = this.sourceGOT.getLayerDefination(entity.getModifiedLayer());
            if (layerDefination.getLayerName().equals("app")) {
                solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionDefinition solutionDefinition = LayerUpgradeHelper.getInstance().getSolutionDefinition(solutionName);
                if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Source) continue;
                layerGOTPath = new File(solutionDefinition.getSolutionModelDir(), "got");
                layerJavaPath = ((SolutionLocator)ObjectContainer.getInstance(SolutionLocator.class)).getSolutionSourceDir(solutionName);
            } else if (layerDefination.getLayerName().equals("ext")) {
                solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = LayerUpgradeHelper.getInstance().getSolutionExtensionDefinition(solutionName);
                if (solutionExtensionDefinition.getDeploymentMode() != SolutionExtensionDeploymentMode.Source) continue;
                layerGOTPath = new File(solutionExtensionDefinition.getExtensionModelDir(), "got");
                layerJavaPath = ((SolutionExtensionLocator)ObjectContainer.getInstance(SolutionExtensionLocator.class)).getSolutionExtensionSourceDir(solutionName);
            } else {
                if (layerDefination.getDeploymentMode() != LayerDeploymentMode.Source) continue;
                layerGOTPath = new File(layerDefination.getLayerModelDir(), "got");
                layerJavaPath = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayerSourceDir(layerDefination.getLayerName());
            }
            switch (entity.getEntityType()) {
                case Enum: {
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerJavaPath, "enums/" + entity.getName() + ".java"));
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/enums/" + entity.getName() + ".xml"));
                    break;
                }
                case DataType: {
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerJavaPath, "datatypes/DataType_" + entity.getName() + ".java"));
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/datatypes/" + entity.getName() + ".xml"));
                    break;
                }
                case Table: {
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerJavaPath, "tables/base/Base" + entity.getName() + ".java"));
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerJavaPath, "tables/" + entity.getName() + ".java"));
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerGOTPath, "datadictionary/tables/" + entity.getName() + ".xml"));
                    break;
                }
                case Form: {
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerJavaPath, "forms/" + entity.getName()));
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerGOTPath, "forms/" + entity.getName() + ".xml"));
                    break;
                }
                case MenuItem: {
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerJavaPath, "menuitems/MenuItem_" + entity.getName()));
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerGOTPath, "menuitems/" + entity.getName() + ".xml"));
                    break;
                }
                case Menu: {
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerGOTPath, "menus/" + entity.getName() + ".xml"));
                    break;
                }
                case Class: {
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerJavaPath, "classes/base/Base" + entity.getName() + ".java"));
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerJavaPath, "classes/" + entity.getName()));
                    gongqi.erp.framework.util.FileUtils.deleteQuietly((File)new File(layerGOTPath, "classes/" + entity.getName() + ".xml"));
                    break;
                }
                default: {
                    throw new ERPException("\u5b9e\u4f53\u8282\u70b9\u79fb\u9664\u672a\u5904\u7406");
                }
            }
        }
    }

    private void deployFiles() throws IOException {
        List<LayerDefination> layerDefinations = this.targetGOT.getLayerDefinations();
        File provided_lib = new File(this.sourceGOT.getLayersRootDir().getParentFile().getParentFile().getParentFile(), "/LayerProject/provided_lib");
        if (!provided_lib.exists()) {
            provided_lib.mkdirs();
        }
        for (LayerDefination layerDefination : layerDefinations) {
            File targetLayerDir;
            File destFile;
            File srcFile;
            LayerDefination sourceLayerDefination = this.sourceGOT.getLayerDefination(layerDefination.getLayerName());
            if ("ent".equals(layerDefination.getLayerName())) continue;
            if ("app".equals(layerDefination.getLayerName())) {
                List<SolutionDefinition> solutionDefinitions = this.targetGOT.getSolutionDefinitions();
                for (SolutionDefinition solutionDefinition : solutionDefinitions) {
                    if (solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source) continue;
                    srcFile = new File(this.targetGOT.getLayersRootDir(), String.format("/%s/%s%s", "app", solutionDefinition.getSolutionName(), ".app"));
                    destFile = new File(this.sourceGOT.getLayersRootDir(), String.format("/%s/%s%s", "app", solutionDefinition.getSolutionName(), ".app"));
                    if (!destFile.exists()) continue;
                    destFile.delete();
                    gongqi.erp.framework.util.FileUtils.copyFile((File)srcFile, (File)destFile);
                    targetLayerDir = new File(provided_lib.getAbsolutePath(), String.format("/%s/%s", layerDefination.getLayerName(), solutionDefinition.getSolutionName()));
                    this.unzipProvidedLib(targetLayerDir, destFile, true);
                }
                continue;
            }
            if ("plg".equals(layerDefination.getLayerName())) {
                List<SolutionPluginDefinition> solutionPluginDefinitions = this.targetGOT.getSolutionPluginDefinitions();
                for (SolutionPluginDefinition solutionPluginDefinition : solutionPluginDefinitions) {
                    if (solutionPluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source) continue;
                    srcFile = new File(this.targetGOT.getLayersRootDir(), String.format("/%s/%s/%s%s", "plg", solutionPluginDefinition.getSolutionName(), solutionPluginDefinition.getName(), ".plugin"));
                    destFile = new File(this.sourceGOT.getLayersRootDir(), String.format("/%s/%s/%s%s", "plg", solutionPluginDefinition.getSolutionName(), solutionPluginDefinition.getName(), ".plugin"));
                    if (!destFile.exists()) continue;
                    destFile.delete();
                    gongqi.erp.framework.util.FileUtils.copyFile((File)srcFile, (File)destFile);
                    targetLayerDir = new File(provided_lib.getAbsolutePath(), String.format("/%s/%s/%s", layerDefination.getLayerName(), solutionPluginDefinition.getSolutionName(), solutionPluginDefinition.getName()));
                    this.unzipProvidedLib(targetLayerDir, destFile, true);
                }
                continue;
            }
            if ("ext".equals(layerDefination.getLayerName())) {
                List<SolutionExtensionDefinition> solutionExtensionDefinitions = this.targetGOT.getSolutionExtensionDefinitions();
                for (SolutionExtensionDefinition solutionExtensionDefinition : solutionExtensionDefinitions) {
                    if (solutionExtensionDefinition.getDeploymentMode() == SolutionExtensionDeploymentMode.Source) continue;
                    srcFile = new File(this.targetGOT.getLayersRootDir(), String.format("/%s/%s%s", "ext", solutionExtensionDefinition.getSolutionName(), ".app.ext"));
                    destFile = new File(this.sourceGOT.getLayersRootDir(), String.format("/%s/%s%s", "ext", solutionExtensionDefinition.getSolutionName(), ".app.ext"));
                    if (!destFile.exists()) continue;
                    destFile.delete();
                    gongqi.erp.framework.util.FileUtils.copyFile((File)srcFile, (File)destFile);
                    targetLayerDir = new File(provided_lib.getAbsolutePath(), String.format("/%s/%s", layerDefination.getLayerName(), solutionExtensionDefinition.getSolutionName()));
                    this.unzipProvidedLib(targetLayerDir, destFile, true);
                }
                continue;
            }
            if (sourceLayerDefination.getDeploymentMode() == LayerDeploymentMode.Source) continue;
            File targetlyrFile = new File(this.targetGOT.getLayersRootDir(), String.format("layer_%s.lyr", layerDefination.getLayerName()));
            FileUtils.copyFileToDirectory((File)targetlyrFile, (File)((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot());
            File targetLayerDir2 = new File(provided_lib.getAbsolutePath(), "/" + layerDefination.getLayerName());
            this.unzipProvidedLib(targetLayerDir2, new File(layerDefination.getLayerDir()), false);
        }
    }

    private void unzipProvidedLib(File deskLayerDir, File source, boolean ifSolution) {
        File temp = null;
        try {
            try {
                if (deskLayerDir.exists()) {
                    try {
                        gongqi.erp.framework.util.FileUtils.deleteDirectory((File)deskLayerDir);
                    }
                    catch (Exception exception) {}
                }
                if (!deskLayerDir.exists()) {
                    deskLayerDir.mkdirs();
                }
                if (!ifSolution) {
                    File binary = new File(source, "/binary");
                    gongqi.erp.framework.util.FileUtils.copyDirectory((File)binary, (File)deskLayerDir);
                } else {
                    temp = new File(gongqi.erp.framework.util.FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                    ZipUtil.unZipFiles((String)source.getAbsolutePath(), (String)temp.getAbsolutePath());
                    File binary = new File(temp, "/binary");
                    gongqi.erp.framework.util.FileUtils.copyDirectory((File)binary, (File)deskLayerDir);
                }
            }
            catch (Exception e) {
                log.error((Object)"\u89e3\u538bprovided_lib\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                throw new ERPException("\u89e3\u538bprovided_lib\u6587\u4ef6\u5931\u8d25");
            }
        }
        catch (Throwable throwable) {
            if (temp != null && temp.exists()) {
                try {
                    gongqi.erp.framework.util.FileUtils.deleteDirectory((File)temp);
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (temp != null && temp.exists()) {
            try {
                gongqi.erp.framework.util.FileUtils.deleteDirectory((File)temp);
            }
            catch (IOException iOException) {}
        }
    }

    private void writeEntityFile(Map<String, GOTEntity> entitys) throws NavException, IOException, DocumentException {
        for (GOTEntity entity : entitys.values()) {
            Path entityPath;
            Path gotPath;
            log.info((Object)String.format("write entity %s", entity.getId()));
            LayerDefination layerDefination = this.sourceGOT.getLayerDefination(entity.getModifiedLayer());
            if (layerDefination.getLayerName().equals("app")) {
                String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionDefinition solutionDefinition = LayerUpgradeHelper.getInstance().getSolutionDefinition(solutionName);
                if (solutionDefinition.getDeploymentMode() != SolutionDeploymentMode.Source) continue;
                gotPath = Paths.get(solutionDefinition.getSolutionModelDir(), "got");
            } else if (layerDefination.getLayerName().equals("plg")) {
                String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionPluginDefinition solutionPluginDefinition = LayerUpgradeHelper.getInstance().getSolutionPluginDefinition(solutionPluginName);
                if (solutionPluginDefinition == null || solutionPluginDefinition.getDeploymentMode() != SolutionPluginDeploymentMode.Source) continue;
                gotPath = Paths.get(solutionPluginDefinition.getPluginModelDir(), "got");
            } else if (layerDefination.getLayerName().equals("ext")) {
                String namespace = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = null;
                if (entity.getCreatedLayer().equals("plg")) {
                    SolutionPluginDefinition solutionPluginDefinition = LayerUpgradeHelper.getInstance().getSolutionPluginDefinition(namespace);
                    solutionExtensionDefinition = LayerUpgradeHelper.getInstance().getSolutionExtensionDefinition(solutionPluginDefinition.getSolutionName());
                } else {
                    solutionExtensionDefinition = LayerUpgradeHelper.getInstance().getSolutionExtensionDefinition(namespace);
                }
                if (solutionExtensionDefinition.getDeploymentMode() != SolutionExtensionDeploymentMode.Source) continue;
                gotPath = Paths.get(solutionExtensionDefinition.getExtensionModelDir(), "got");
            } else {
                if (layerDefination.getDeploymentMode() != LayerDeploymentMode.Source) continue;
                gotPath = Paths.get(layerDefination.getLayerModelDir(), "got");
            }
            if (entity.getEntityType() == EntityType.Enum) {
                entityPath = gotPath.resolve("datadictionary/enums/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.DataType) {
                entityPath = gotPath.resolve("datadictionary/datatypes/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Table) {
                entityPath = gotPath.resolve("datadictionary/tables/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Menu) {
                entityPath = gotPath.resolve("menus/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.MenuItem) {
                entityPath = gotPath.resolve("menuitems/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Form) {
                entityPath = gotPath.resolve("forms/" + entity.getName() + ".xml");
            } else if (entity.getEntityType() == EntityType.Class) {
                entityPath = gotPath.resolve("classes/" + entity.getName() + ".xml");
            } else {
                throw new ERPException(String.format("\u6682\u4e0d\u652f\u6301\u4fdd\u5b58\u3010%s\u3011\u7c7b\u578b\u8282\u70b9", entity.getEntityType().name()));
            }
            FileIOXML.saveDocument((String)entityPath.toString(), (Document)DocumentHelper.parseText((String)entity.asXML()));
            if (!entity.isRename() || !Files.exists(entityPath = entityPath.getParent().resolve(String.valueOf(entity.getOrigName()) + ".xml"), new LinkOption[0])) continue;
            Files.delete(entityPath);
        }
    }

    private void initSourceGOTModel() throws IOException {
        File layersRootDir = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
        this.sourceGOT = new GOTModel(layersRootDir);
    }

    private void initTargetGOTModel(Collection<File> layersFiles, Collection<File> solutionFiles, Collection<File> solutionPluginFiles, Collection<File> solutionExtensionFiles) throws IOException {
        File solutionPluginsRootDir;
        File targetLayersRootDir = new File(gongqi.erp.framework.util.FileUtils.getTempDirectory(), UUID.randomUUID().toString());
        targetLayersRootDir.mkdirs();
        for (File lyrFile : layersFiles) {
            if (!lyrFile.isFile()) {
                if (lyrFile.list().length == 0) {
                    String lyrName = lyrFile.getName();
                    LayerDefination layer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getLayer(lyrName);
                    if (layer == null) {
                        throw new RuntimeException("\u5347\u7ea7\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u5305\u542b\u65e0\u6548\u7684\u5c42\u6253\u5305\u6587\u4ef6");
                    }
                    File layerDir = new File(targetLayersRootDir, lyrName);
                    this.makeLayerDir(lyrName, layer.getLowerLayer(), layerDir.toPath());
                    continue;
                }
                gongqi.erp.framework.util.FileUtils.copyDirectoryToDirectory((File)lyrFile, (File)targetLayersRootDir);
                continue;
            }
            if (!lyrFile.getName().endsWith(".lyr")) {
                throw new RuntimeException("\u5347\u7ea7\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u5305\u542b\u65e0\u6548\u7684\u5c42\u6253\u5305\u6587\u4ef6");
            }
            gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)lyrFile, (File)targetLayersRootDir);
        }
        if (solutionFiles != null && !solutionFiles.isEmpty()) {
            File solutionsRootDir = new File(targetLayersRootDir, "app");
            solutionsRootDir.mkdirs();
            for (File solutionFile : solutionFiles) {
                gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionFile, (File)solutionsRootDir);
            }
        }
        if (solutionPluginFiles != null && !solutionPluginFiles.isEmpty()) {
            solutionPluginsRootDir = new File(targetLayersRootDir, "plg");
            solutionPluginsRootDir.mkdirs();
            for (File solutionPluginFile : solutionPluginFiles) {
                SolutionPluginDefinition solutionPlugin = ((SolutionPluginResolver)ObjectContainer.getInstance(SolutionPluginResolver.class)).resolveSolutionPlugin(solutionPluginFile);
                File solutionPluginRootDir = new File(solutionPluginsRootDir, solutionPlugin.getSolutionName());
                if (!solutionPluginRootDir.exists()) {
                    solutionPluginRootDir.mkdirs();
                }
                gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionPluginFile, (File)solutionPluginRootDir);
            }
        }
        if (solutionExtensionFiles != null && !solutionExtensionFiles.isEmpty()) {
            if (solutionPluginFiles == null || solutionPluginFiles.isEmpty()) {
                solutionPluginsRootDir = new File(targetLayersRootDir, "plg");
                solutionPluginsRootDir.mkdirs();
            }
            File solutionExtensionsRootDir = new File(targetLayersRootDir, "ext");
            solutionExtensionsRootDir.mkdir();
            for (File solutionExtensionFile : solutionExtensionFiles) {
                gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionExtensionFile, (File)solutionExtensionsRootDir);
            }
        }
        this.targetGOT = new GOTModel(targetLayersRootDir);
    }

    private void extractLayer(File lyrFile, File descDir) {
        String layerName;
        File layerTempDir = new File(descDir, UUID.randomUUID().toString());
        try {
            ZipUtil.unZipFiles((String)lyrFile.getAbsolutePath(), (String)layerTempDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0c\u89e3\u6790\u9519\u8bef\uff1a" + lyrFile.getAbsolutePath(), e);
        }
        File gotPackageFile = new File(layerTempDir, "model").listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".got");
            }
        })[0];
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (ZipFile gotZipFile = new ZipFile(gotPackageFile);){
                ZipEntry entry = gotZipFile.getEntry("Layer.xml");
                if (entry == null) {
                    throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0cgot\u538b\u7f29\u5305\u7f3a\u5c11\u5c42\u5b9a\u4e49\u6587\u4ef6");
                }
                SAXReader reader = new SAXReader();
                Document document = reader.read(gotZipFile.getInputStream(entry));
                layerName = document.getRootElement().elementText("name");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | DocumentException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6\uff0cgot\u538b\u7f29\u5305\u89e3\u6790\u9519\u8bef", e);
        }
        File descLayerDir = new File(descDir, layerName);
        if (descLayerDir.exists()) {
            throw new RuntimeException(String.format("\u5347\u7ea7\u6587\u4ef6\u9519\u8bef\uff0c\u5b58\u5728\u91cd\u590d\u7684%s\u5c42", layerName));
        }
        if (!layerTempDir.renameTo(descLayerDir)) {
            throw new RuntimeException(String.format("%s\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25", layerName));
        }
    }

    private void initOriginalTargetGOTModel() throws IOException {
        File layersRootDir = new File(gongqi.erp.framework.util.FileUtils.getTempDirectory(), UUID.randomUUID().toString());
        layersRootDir.mkdirs();
        List<LayerDefination> layerDefinations = this.targetGOT.getLayerDefinations();
        for (LayerDefination layerDefination : layerDefinations) {
            File srcFile;
            File destLayerDir = new File(layersRootDir, layerDefination.getLayerName());
            if (!destLayerDir.exists()) {
                destLayerDir.mkdirs();
            }
            if ("app".equals(layerDefination.getLayerName())) {
                List<SolutionDefinition> solutionDefinitions = this.targetGOT.getSolutionDefinitions();
                for (SolutionDefinition solutionDefinition : solutionDefinitions) {
                    srcFile = new File(new File(this.sourceGOT.getLayersRootDir(), "app"), String.valueOf(solutionDefinition.getSolutionName()) + ".app");
                    gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)srcFile, (File)destLayerDir);
                }
                continue;
            }
            if ("plg".equals(layerDefination.getLayerName())) {
                List<SolutionPluginDefinition> solutionPluginDefinitions = this.targetGOT.getSolutionPluginDefinitions();
                for (SolutionPluginDefinition solutionPluginDefinition : solutionPluginDefinitions) {
                    srcFile = new File(new File(this.sourceGOT.getLayersRootDir(), "plg"), String.format("/%s/%s%s", solutionPluginDefinition.getSolutionName(), solutionPluginDefinition.getName(), ".plugin"));
                    File solutionPluginsRootDir = new File(destLayerDir, solutionPluginDefinition.getSolutionName());
                    gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)srcFile, (File)solutionPluginsRootDir);
                }
                continue;
            }
            if ("ext".equals(layerDefination.getLayerName())) {
                List<SolutionExtensionDefinition> solutionExtensionDefinitions = this.targetGOT.getSolutionExtensionDefinitions();
                for (SolutionExtensionDefinition solutionExtensionDefinition : solutionExtensionDefinitions) {
                    srcFile = new File(new File(this.sourceGOT.getLayersRootDir(), "ext"), String.valueOf(solutionExtensionDefinition.getSolutionName()) + ".app.ext");
                    gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)srcFile, (File)destLayerDir);
                }
                continue;
            }
            if ("ent".equals(layerDefination.getLayerName())) {
                this.makeLayerDir("ent", "iny", destLayerDir.toPath());
                continue;
            }
            LayerDefination sourceLayerDefination = this.sourceGOT.getLayerDefination(layerDefination.getLayerName());
            if (sourceLayerDefination.getDeploymentMode() == LayerDeploymentMode.Package) {
                File sourceLyrFile = new File(((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot(), String.format("layer_%s.lyr", sourceLayerDefination.getLayerName()));
                FileUtils.copyFileToDirectory((File)sourceLyrFile, (File)layersRootDir);
                continue;
            }
            gongqi.erp.framework.util.FileUtils.copyDirectory((File)new File(this.sourceGOT.getLayerDefination(layerDefination.getLayerName()).getLayerDir()), (File)destLayerDir);
        }
        this.originalGOT = new GOTModel(layersRootDir);
    }

    private void makeLayerDir(String layerName, String lowerLayer, Path targetDir) throws IOException {
        try {
            if (Files.exists(targetDir, new LinkOption[0])) {
                if (Files.isDirectory(targetDir, new LinkOption[0])) {
                    gongqi.erp.framework.util.FileUtils.deleteDirectory((File)targetDir.toFile());
                } else {
                    Files.delete(targetDir);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("\u6e05\u7a7a\u76ee\u5f55\u9519\u8bef\uff1a%s", targetDir.toString()), (Throwable)e);
        }
        Files.createDirectories(targetDir, new FileAttribute[0]);
        Path binaryDir = targetDir.resolve("binary");
        Files.createDirectories(binaryDir, new FileAttribute[0]);
        new File(binaryDir.toFile(), "classes").mkdirs();
        new File(binaryDir.toFile(), "lib").mkdirs();
        Path modelDir = targetDir.resolve("model");
        Files.createDirectories(modelDir, new FileAttribute[0]);
        Path gotDir = modelDir.resolve("got");
        Files.createDirectories(gotDir, new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("datadictionary/datatypes"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("datadictionary/enums"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("datadictionary/tables"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("forms"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("menuitems"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("menus"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("classes"), new FileAttribute[0]);
        Files.createDirectories(gotDir.resolve("reports"), new FileAttribute[0]);
        Files.createDirectories(modelDir.resolve("resource"), new FileAttribute[0]);
        ((LayerDefiner)ObjectContainer.getInstance(LayerDefiner.class)).defineLayer(targetDir.toFile().getAbsolutePath(), "", layerName, "", "1.0", lowerLayer, "1.0", true);
    }

    public Map<String, GOTEntity> getSourceEntitys(EntityType entityType) {
        if (this.sourceGOT == null) {
            return new HashMap<String, GOTEntity>();
        }
        return this.sourceGOT.getEntitys(entityType);
    }

    public GOTEntity getSourceEntity(EntityType entityType, String entityId) {
        return this.sourceGOT.getEntityById(entityType, entityId);
    }

    public Map<String, GOTEntity> getTargetEntitys(EntityType entityType) {
        return this.targetGOT.getEntitys(entityType);
    }

    public GOTEntity getTargetEntity(EntityType entityType, String entityId) {
        return this.targetGOT.getEntityById(entityType, entityId);
    }

    public List<LayerJavaCode> getEntityJavaContent(GOTEntity gotEntity, boolean source) {
        ArrayList<LayerJavaCode> javaCodes = new ArrayList<LayerJavaCode>();
        String createdLayer = gotEntity.getCreatedLayer();
        String modifiedLayer = gotEntity.getModifiedLayer();
        LayerDefinationManager layerDefinationManager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
        LayerDefination layerDefination = layerDefinationManager.getLayer(createdLayer);
        String entityName = gotEntity.getName();
        if (entityName.contains(".")) {
            entityName = entityName.substring(entityName.lastIndexOf(".") + 1, entityName.length());
        }
        while (layerDefination != null) {
            String upperLayer;
            LayerDeploymentMode deployMode;
            String layerName = layerDefination.getLayerName();
            LayerDeploymentMode layerDeploymentMode = deployMode = source ? this.getEntityLayerDeployMode(layerName, gotEntity, this.sourceGOT) : this.getEntityLayerDeployMode(layerName, gotEntity, this.targetGOT);
            if (EntityType.Table.equals((Object)gotEntity.getEntityType())) {
                javaCodes.add(this.createJavaCode(layerName, deployMode, String.format("tables/%s.java", entityName), entityName, LayerJavaCode.JavaType.Table, gotEntity, source));
            } else if (EntityType.Form.equals((Object)gotEntity.getEntityType())) {
                javaCodes.add(this.createJavaCode(layerName, deployMode, String.format("forms/%s/Form_%s.java", entityName, entityName), entityName, LayerJavaCode.JavaType.Form, gotEntity, source));
                List<GOTNode> formDataSources = gotEntity.selectNodes("FormDataSources/FormDataSource");
                for (GOTNode formDataSource : formDataSources) {
                    javaCodes.add(this.createJavaCode(layerName, deployMode, String.format("forms/%s/datasource/Form_%s_DataSource_%s.java", entityName, entityName, formDataSource.getName()), formDataSource.getName(), LayerJavaCode.JavaType.DataSource, gotEntity, source));
                }
            } else if (EntityType.Class.equals((Object)gotEntity.getEntityType())) {
                javaCodes.add(this.createJavaCode(layerName, deployMode, String.format("classes/%s.java", entityName), entityName, LayerJavaCode.JavaType.Class, gotEntity, source));
            } else {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u683c\u5f0f" + gotEntity.getEntityType());
            }
            if (layerDefination.getLayerName().equals(modifiedLayer) || "Gongqi_ERP_No_More_Layer".equals(upperLayer = layerDefination.getUpperLayer()) || upperLayer == null) break;
            layerDefination = layerDefinationManager.getLayer(upperLayer);
        }
        return javaCodes.stream().filter(c -> c != null).collect(Collectors.toList());
    }

    private LayerJavaCode createJavaCode(String layerName, LayerDeploymentMode deployMode, String entityPath, String simpleName, LayerJavaCode.JavaType javaType, GOTEntity gotEntity, boolean source) {
        String javaContent;
        String string = javaContent = source ? this.getJavaContent(layerName, gotEntity, this.sourceGOT, entityPath) : this.getJavaContent(layerName, gotEntity, this.targetGOT, entityPath);
        if (StringUtils.isBlank((String)javaContent)) {
            return null;
        }
        LayerJavaCode javaCode = new LayerJavaCode();
        javaCode.setLayerName(layerName);
        javaCode.setDeploymentMode(deployMode);
        javaCode.setSimpleName(simpleName);
        javaCode.setJavaType(javaType);
        javaCode.setContent(javaContent);
        return javaCode;
    }

    private LayerDeploymentMode getEntityLayerDeployMode(String layerName, GOTEntity gotEntity, GOTModel gotModel) {
        if ("app".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionName = id.substring(0, id.lastIndexOf("."));
            SolutionDefinition solutionDefinition = gotModel.getSolutionDefinition(solutionName);
            if (solutionDefinition == null) {
                return null;
            }
            if (solutionDefinition.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)) {
                return LayerDeploymentMode.Package;
            }
        } else if ("plg".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionPluginName = id.substring(0, id.lastIndexOf("."));
            SolutionPluginDefinition pluginDefinition = gotModel.getSolutionPluginDefinition(solutionPluginName);
            if (pluginDefinition == null) {
                return null;
            }
            if (pluginDefinition.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)) {
                return LayerDeploymentMode.Package;
            }
        } else if ("ext".equals(layerName)) {
            String id = gotEntity.getId();
            if ("plg".equals(gotEntity.getCreatedLayer())) {
                String pluginName = id.substring(0, id.lastIndexOf("."));
                SolutionPluginDefinition pluginDefinition = gotModel.getSolutionPluginDefinition(pluginName);
                SolutionExtensionDefinition extensionDefinition = gotModel.getSolutionExtensionDefinition(pluginDefinition.getSolutionName());
                if (extensionDefinition.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Package)) {
                    return LayerDeploymentMode.Package;
                }
            } else {
                String solutionName = id.substring(0, id.lastIndexOf("."));
                SolutionExtensionDefinition extensionDefinition = gotModel.getSolutionExtensionDefinition(solutionName);
                if (extensionDefinition == null) {
                    return null;
                }
                if (extensionDefinition.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Package)) {
                    return LayerDeploymentMode.Package;
                }
            }
        } else {
            LayerDefination layerDefination = gotModel.getLayerDefination(layerName);
            if (layerDefination == null) {
                return null;
            }
            if (layerDefination.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                return LayerDeploymentMode.Package;
            }
        }
        return LayerDeploymentMode.Source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getJavaContent(String layerName, GOTEntity gotEntity, GOTModel gotModel, String entityPath) {
        File projectDir = new File(FrameworkEnvironment.getGongqiDir(), "Project/Server/LayerProject");
        if ("app".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionName = id.substring(0, id.lastIndexOf("."));
            SolutionDefinition solutionDefinition = gotModel.getSolutionDefinition(solutionName);
            if (solutionDefinition == null) {
                return null;
            }
            if (solutionDefinition.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)) {
                String binaryDir = solutionDefinition.getSolutionBinaryDir();
                File sourceJar = new File(binaryDir, String.format("%s-source.jar", solutionName));
                if (!sourceJar.exists()) return null;
                return this.getJavaContentInJar(sourceJar, String.format("%s/layers/app/%s", solutionName.replace(".", "/"), entityPath));
            }
            File javaFile = new File(projectDir, String.format("app_%s/%s/layers/app/%s", solutionName, solutionName.replace(".", "/"), entityPath));
            try {
                return gongqi.erp.framework.util.FileUtils.readFileToString((File)javaFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + javaFile.getAbsolutePath()));
                return null;
            }
        } else if ("plg".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionPluginName = id.substring(0, id.lastIndexOf("."));
            SolutionPluginDefinition pluginDefinition = gotModel.getSolutionPluginDefinition(solutionPluginName);
            if (pluginDefinition == null) {
                return null;
            }
            if (pluginDefinition.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)) {
                String binaryDir = pluginDefinition.getPluginBinaryDir();
                File sourceJar = new File(binaryDir, String.format("%s-source.jar", solutionPluginName));
                if (!sourceJar.exists()) return null;
                return this.getJavaContentInJar(sourceJar, String.format("%s/layers/plg/%s", solutionPluginName.replace(".", "/"), entityPath));
            }
            File javaFile = new File(projectDir, String.format("plg_%s/%s/layers/plg/%s", solutionPluginName, solutionPluginName.replace(".", "/"), entityPath));
            try {
                return gongqi.erp.framework.util.FileUtils.readFileToString((File)javaFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + javaFile.getAbsolutePath()));
                return null;
            }
        } else if ("ext".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionName = null;
            SolutionExtensionDefinition extensionDefinition = null;
            if ("plg".equals(gotEntity.getCreatedLayer())) {
                String pluginName = id.substring(0, id.lastIndexOf("."));
                SolutionPluginDefinition pluginDefinition = gotModel.getSolutionPluginDefinition(pluginName);
                solutionName = pluginDefinition.getSolutionName();
                extensionDefinition = gotModel.getSolutionExtensionDefinition(pluginDefinition.getSolutionName());
            } else {
                solutionName = id.substring(0, id.lastIndexOf("."));
                extensionDefinition = gotModel.getSolutionExtensionDefinition(solutionName);
            }
            if (extensionDefinition == null) {
                return null;
            }
            if (extensionDefinition.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Package)) {
                String binaryDir = extensionDefinition.getExtensionBinaryDir();
                File sourceJar = new File(binaryDir, String.format("%s-source.jar", solutionName));
                String entityName = gotEntity.getName();
                entityName = entityName.substring(entityName.lastIndexOf(".") + 1, entityName.length());
                if (!sourceJar.exists()) return null;
                return this.getJavaContentInJar(sourceJar, String.format("%s/layers/ext/%s", solutionName.replace(".", "/"), entityPath));
            }
            File javaFile = new File(projectDir, String.format("ext_%s/%s/layers/ext/%s", solutionName, solutionName.replace(".", "/"), entityPath));
            try {
                return gongqi.erp.framework.util.FileUtils.readFileToString((File)javaFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + javaFile.getAbsolutePath()));
                return null;
            }
        } else {
            LayerDefination layerDefination = gotModel.getLayerDefination(layerName);
            if (layerDefination == null) {
                return null;
            }
            if (layerDefination.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                String binaryDir = layerDefination.getLayerBinaryDir();
                File sourceJar = new File(binaryDir, String.format("layer_%s-source.jar", layerName));
                if (!sourceJar.exists()) return null;
                return this.getJavaContentInJar(sourceJar, String.format("gongqi/erp/layers/%s/%s", layerName, entityPath));
            }
            File javaFile = new File(projectDir, String.format("layer_%s/gongqi/erp/layers/%s/%s", layerName, layerName, entityPath));
            try {
                return gongqi.erp.framework.util.FileUtils.readFileToString((File)javaFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + javaFile.getAbsolutePath()));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJavaContentInJar(File jarFile, String javaPath) {
        StringBuilder content = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile zipFile = new ZipFile(jarFile.getAbsoluteFile());){
                ZipEntry entry = zipFile.getEntry(javaPath);
                if (entry == null) {
                    return null;
                }
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry), StandardCharsets.UTF_8));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            return content.toString();
                        }
                        content.append(line).append(System.lineSeparator());
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("\u83b7\u53d6Jar\u3010%s\u3011\u7684\u7c7b\u3010%s\u3011\u65f6\u51fa\u73b0\u5f02\u5e38", jarFile.getAbsolutePath(), javaPath), (Throwable)e);
        }
        return content.toString();
    }

    public GOTModel castTargetModel(Map<String, PedestalLayerInfo> pedestalInfos, Map<String, SolutionLayerInfo> solutionInfos) throws IOException {
        File layersRootDir = new File(gongqi.erp.framework.util.FileUtils.getTempDirectory(), "TargetGOTModel/" + UUID.randomUUID().toString());
        layersRootDir.mkdirs();
        for (PedestalLayerInfo pedestalInfo : pedestalInfos.values()) {
            File lyrFile = null;
            lyrFile = pedestalInfo.isOnline() != null && pedestalInfo.getDeploymentMode() == LayerDeploymentMode.Package ? pedestalInfo.getUpdateFile(pedestalInfo.getTargetVersion()) : pedestalInfo.getBaseFile();
            if (!lyrFile.isFile()) {
                File target = new File(layersRootDir, lyrFile.getName());
                AnalysisResultPage.copyDirectory(lyrFile, target);
                continue;
            }
            gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)lyrFile, (File)layersRootDir);
        }
        File solutionsRootDir = new File(layersRootDir, "app");
        solutionsRootDir.mkdirs();
        File solutionPluginsRootDir = new File(layersRootDir, "plg");
        solutionPluginsRootDir.mkdirs();
        for (SolutionLayerInfo solutionInfo : solutionInfos.values()) {
            SolutionExtInfo extInfo;
            if (solutionInfo.isOnline() == null) continue;
            File solutionFile = solutionInfo.getUpdateFile(solutionInfo.getTargetVersion());
            if (!solutionFile.isFile()) {
                File target = new File(layersRootDir, solutionFile.getName());
                AnalysisResultPage.copyDirectory(solutionFile, target);
            } else {
                gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionFile, (File)solutionsRootDir);
            }
            List<SolutionPluginInfo> pluginInfos = solutionInfo.getPluginInfos();
            if (!pluginInfos.isEmpty()) {
                File solutionPluginRootDir = new File(solutionPluginsRootDir, solutionInfo.getSolutionId());
                solutionPluginRootDir.mkdirs();
                for (SolutionPluginInfo solutionPlugin : pluginInfos) {
                    File solutionPluginFile = null;
                    solutionPluginFile = solutionPlugin.isOnline() == null ? solutionPlugin.getBaseFile() : solutionPlugin.getUpdateFile(solutionPlugin.getTargetVersion());
                    if (solutionPluginFile.isFile()) {
                        gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionPluginFile, (File)solutionPluginRootDir);
                        continue;
                    }
                    File target = new File(layersRootDir, solutionPluginFile.getName());
                    AnalysisResultPage.copyDirectory(solutionPluginFile, target);
                }
            }
            if ((extInfo = solutionInfo.getExtInfo()) == null) continue;
            File solutionExtensionsRootDir = new File(layersRootDir, "ext");
            solutionExtensionsRootDir.mkdir();
            File solutionExtFile = extInfo.getBaseFile();
            if (solutionExtFile.isFile()) {
                gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionExtFile, (File)solutionExtensionsRootDir);
                continue;
            }
            File target = new File(layersRootDir, "/ext/" + solutionExtFile.getName());
            AnalysisResultPage.copyDirectory(solutionExtFile, target);
        }
        return new GOTModel(layersRootDir);
    }

    public GOTModel castGOTModel(File layerRoot, Map<String, PedestalLayerInfo> pedestalInfos, Map<String, SolutionLayerInfo> solutionInfos) throws IOException {
        File layersRootDir = new File(gongqi.erp.framework.util.FileUtils.getTempDirectory(), "SelectGOTModel/" + UUID.randomUUID().toString());
        layersRootDir.mkdirs();
        for (PedestalLayerInfo pedestalInfo : pedestalInfos.values()) {
            File lyrFile = pedestalInfo.getBaseFile(layerRoot);
            if (!lyrFile.isFile()) {
                File target = new File(layersRootDir, lyrFile.getName());
                AnalysisResultPage.copyDirectory(lyrFile, target);
                continue;
            }
            gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)lyrFile, (File)layersRootDir);
        }
        File solutionsRootDir = new File(layersRootDir, "app");
        solutionsRootDir.mkdirs();
        File solutionPluginsRootDir = new File(layersRootDir, "plg");
        solutionPluginsRootDir.mkdirs();
        for (SolutionLayerInfo solutionInfo : solutionInfos.values()) {
            SolutionExtInfo extInfo;
            if (solutionInfo.isOnline() == null) continue;
            File solutionFile = solutionInfo.getBaseFile(layerRoot);
            if (!solutionFile.isFile()) {
                File target = new File(layersRootDir, solutionFile.getName());
                AnalysisResultPage.copyDirectory(solutionFile, target);
            } else {
                gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionFile, (File)solutionsRootDir);
            }
            List<SolutionPluginInfo> pluginInfos = solutionInfo.getPluginInfos();
            if (!pluginInfos.isEmpty()) {
                File solutionPluginRootDir = new File(solutionPluginsRootDir, solutionInfo.getSolutionId());
                solutionPluginRootDir.mkdirs();
                for (SolutionPluginInfo solutionPlugin : pluginInfos) {
                    File solutionPluginFile = solutionPlugin.getBaseFile(layerRoot);
                    if (solutionPluginFile.isFile()) {
                        gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionPluginFile, (File)solutionPluginRootDir);
                        continue;
                    }
                    File target = new File(solutionPluginRootDir, solutionPlugin.getPluginId());
                    target.mkdirs();
                    AnalysisResultPage.copyDirectory(solutionPluginFile, target);
                }
            }
            if ((extInfo = solutionInfo.getExtInfo()) == null) continue;
            File solutionExtensionsRootDir = new File(layersRootDir, "ext");
            File solutionExtFile = extInfo.getBaseFile(layerRoot);
            if (solutionExtFile.isFile()) {
                gongqi.erp.framework.util.FileUtils.copyFileToDirectory((File)solutionExtFile, (File)solutionExtensionsRootDir);
                continue;
            }
            File target = new File(solutionExtensionsRootDir, solutionExtFile.getName());
            target.mkdirs();
            AnalysisResultPage.copyDirectory(solutionExtFile, target);
        }
        return new GOTModel(layersRootDir);
    }

    public List<String> mergeDatabase(File beforeLayerRoot, Map<String, PedestalLayerInfo> pedestalInfos, Map<String, SolutionLayerInfo> solutionInfos, ProgressMonitor monitor) {
        GOTModel currentGOTModel = null;
        GOTModel beforeGOTModel = null;
        try {
            monitor.worked(1, "\u6b63\u5728\u52a0\u8f7d\u5347\u7ea7\u540eGOT\u6a21\u578b...");
            File layerRoot = new File(ProjectConstants.getBasePath(), "Project/Server/GongqiERP/WEB-INF/layers");
            currentGOTModel = this.castGOTModel(layerRoot, pedestalInfos, solutionInfos);
            monitor.worked(1, "\u6b63\u5728\u52a0\u8f7d\u5f53\u524dGOT\u6a21\u578b...");
            beforeGOTModel = this.castGOTModel(beforeLayerRoot, pedestalInfos, solutionInfos);
        }
        catch (IOException e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u62df\u5408\u65f6, \u51fa\u73b0\u5f02\u5e38", e);
        }
        Datadictionary currentDatadictionary = MergeDatabaseUtil.castGotModelToDictionary(currentGOTModel);
        Datadictionary beforeDatadictionary = MergeDatabaseUtil.castGotModelToDictionary(beforeGOTModel);
        monitor.worked(1, "\u6b63\u5728\u8fdb\u884c\u7ed3\u6784\u5bf9\u6bd4...");
        Set<String> tableIds = MergeDatabaseUtil.compareGotDatabase(beforeDatadictionary, currentDatadictionary);
        monitor.worked(1, "\u5f00\u59cb\u62df\u5408...");
        List<String> modifyDatabase = MergeDatabaseUtil.modifyDatabase(tableIds, beforeDatadictionary, currentDatadictionary);
        return modifyDatabase;
    }

    public List<Map<String, String>> checkTargetRelation() {
        if (this.targetGOT == null) {
            try {
                this.initTargetGOTModel(this.layerFiles, this.solutionFiles, this.solutionPluginFiles, this.solutionExtensionFiles);
            }
            catch (Exception e) {
                throw new RuntimeException("\u89e3\u6790\u5347\u7ea7\u5c42\u6a21\u578b\u9519\u8bef", e);
            }
        }
        return this.targetGOT.checkRelation();
    }
}

