/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.resolvergot;

import gongqi.gdt.designer.core.resolvergot.ResolverNodeFactory;
import gongqi.gdt.designer.core.resolvergot.ResolverUi;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ResolverNode {
    private Element resolver = ResolverUi.getResolver();
    private Element node;
    private ResolverNode extendsNode;
    private Element info;
    private Element contextMenuData;
    private Element atts;
    private Element ps;

    public ResolverNode(String resolverName, String type) {
        if (this.resolver != null) {
            Attribute attribute = this.resolver.attribute("name");
            if (resolverName.equals(attribute.getValue())) {
                this.node = this.resolver;
            } else {
                ArrayList<Element> elements = new ArrayList<Element>();
                List list = this.resolver.selectNodes(".//node[@name='" + resolverName + "']");
                for (Element element : list) {
                    if (element.element("Info") == null || "ref".equals(element.element("Info").elementText("NodeType"))) continue;
                    String el_type = element.element("Info").elementText("Type");
                    if ((!StringUtils.isBlank((String)type) || !StringUtils.isBlank((String)el_type)) && !el_type.equals(type)) continue;
                    elements.add(element);
                }
                if (elements.size() > 1) {
                    GOTMessageDialog.alert(">0");
                } else if (elements.size() == 1) {
                    this.node = (Element)elements.get(0);
                }
            }
        }
        if (this.node != null) {
            this.info = this.node.element("Info");
            this.contextMenuData = this.node.element("ContextMenu");
            this.atts = this.node.element("Attributes");
            this.ps = this.node.element("Properties");
            String str = this.info.elementText("Extends");
            this.extendsNode = str.equals("") ? null : ResolverNodeFactory.getResolverNode(str, "");
        }
    }

    public static ResolverNode getNode(Element item) {
        String name = item.getName();
        String type = item.attributeValue("type") != null ? item.attributeValue("type") : "";
        return ResolverNodeFactory.getResolverNode(name, type);
    }

    public String getName() {
        return this.node.attributeValue("name");
    }

    public Element getNode() {
        return this.node;
    }

    public String getInfoValue(String name) {
        String str;
        if (this.info == null) {
            return "";
        }
        String string = str = this.info.element(name) == null ? "" : this.info.element(name).getText();
        if (!name.equals("Type") && !name.equals("NodeType") && str.equals("") && this.extendsNode != null) {
            str = this.extendsNode.getInfoValue(name);
        }
        return str;
    }

    public boolean hasContextMenu(String menuName) {
        if (this.contextMenuData == null) {
            return false;
        }
        String value = this.contextMenuData.elementText(menuName);
        if (StringUtils.isBlank((String)value) && this.extendsNode != null) {
            return this.extendsNode.hasContextMenu(menuName);
        }
        return "Y".equals(value);
    }

    public String getAttributeValue(String name, String field) {
        return this.getAttributeOrPropertyValue(name, field, "Attribute");
    }

    public String getPropertyValue(String name, String field) {
        return this.getAttributeOrPropertyValue(name, field, "Property");
    }

    private String getAttributeOrPropertyValue(String name, String field, String type) {
        Element _node = this.getAttributeOrProperty(name, type);
        if (_node != null) {
            List list = _node.elements(field);
            if (list.size() == 1) {
                return ((Element)list.get(0)).getText();
            }
            return null;
        }
        return null;
    }

    private List<Object> getExtendsProOrAttrNode(String name, String type) {
        String xpath;
        List list = new ArrayList();
        ArrayList<Object> array = new ArrayList<Object>();
        Boolean isThis = false;
        if (type.equals("Attribute")) {
            xpath = "Attribute/Name";
            list = this.atts.selectNodes(xpath);
        } else if (type.equals("Property")) {
            if (this.ps.element("Property") != null) {
                xpath = "Property/Name";
                list = this.ps.selectNodes(xpath);
            }
        } else {
            return null;
        }
        for (Element e : list) {
            if (!e.getText().equals(name)) continue;
            Element _node = e.getParent();
            array.add(0, _node.createCopy());
            array.add(1, this);
            isThis = true;
            break;
        }
        if (isThis.booleanValue()) {
            return array;
        }
        if (this.extendsNode != null) {
            return this.extendsNode.getExtendsProOrAttrNode(name, type);
        }
        return null;
    }

    private Element getAttributeOrProperty(String name, String type) {
        List<Object> array = this.getExtendsProOrAttrNode(name, type);
        if (array == null || array.size() == 0) {
            return null;
        }
        Element _node = (Element)array.get(0);
        ResolverNode rNode = (ResolverNode)array.get(1);
        if (rNode.extendsNode != null) {
            List childList = _node.elements();
            for (Element e : childList) {
                if (!e.getText().equals("")) continue;
                _node.element(e.getName()).setText(rNode.extendsNode.getExtendsNodeValue(name, e.getName(), type));
            }
        }
        return _node;
    }

    private String getExtendsNodeValue(String name, String childName, String type) {
        String xpath;
        Element _node = null;
        List list = new ArrayList();
        if (type.equals("Attribute")) {
            if (this.atts.element("Attribute") != null) {
                xpath = "Attribute/Name";
                list = this.atts.selectNodes(xpath);
            }
        } else if (type.equals("Property")) {
            if (this.ps.element("Property") != null) {
                xpath = "Property/Name";
                list = this.ps.selectNodes(xpath);
            }
        } else {
            return null;
        }
        for (Element e : list) {
            if (!e.getText().equals(name)) continue;
            _node = e.getParent();
            break;
        }
        if (_node == null) {
            if (this.extendsNode != null) {
                return this.extendsNode.getExtendsNodeValue(name, childName, type);
            }
            return "";
        }
        List childList = _node.elements();
        for (Element e : childList) {
            if (!e.getName().equals(childName)) continue;
            if (!e.getText().equals("")) {
                return e.getText();
            }
            if (this.extendsNode != null) {
                return this.extendsNode.getExtendsNodeValue(name, e.getName(), type);
            }
            return "";
        }
        return "";
    }

    public List<Element> getAttributes() {
        ArrayList<Element> array = new ArrayList<Element>();
        return this.getAttributesOrProperties(array, "Attribute");
    }

    public List<Element> getProperties() {
        ArrayList<Element> array = new ArrayList<Element>();
        return this.getAttributesOrProperties(array, "Property");
    }

    private List<Element> getAttributesOrProperties(List<Element> array, String type) {
        if (this.extendsNode != null) {
            array = this.extendsNode.getAttributesOrProperties(array, type);
        }
        List list = null;
        if (type.equals("Attribute")) {
            list = this.atts.elements(type);
        } else if (type.equals("Property")) {
            list = this.ps.elements(type);
        } else {
            GOTMessageDialog.alert("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        for (Element child : list) {
            array.add(child.createCopy());
            array = this.itemFilterSame(array);
        }
        return array;
    }

    private List<Element> itemFilterSame(List<Element> array) {
        if (array.size() <= 1) {
            return array;
        }
        Element newItem = array.get(array.size() - 1);
        int i = 0;
        i = 0;
        while (i < array.size() - 1) {
            Element arrayItem = array.get(i);
            if (arrayItem.elementText("Name").equals(newItem.elementText("Name"))) {
                List newItems = newItem.elements();
                for (Element child : newItems) {
                    if (child.getText().equals("")) continue;
                    if (arrayItem.element(child.getName()) != null) {
                        arrayItem.element(child.getName()).setText(child.getText());
                        continue;
                    }
                    arrayItem.addElement(child.getName(), child.getText());
                }
                array.remove(array.size() - 1);
                break;
            }
            ++i;
        }
        return array;
    }

    public List<ResolverNode> getChildNodes() {
        ArrayList<ResolverNode> childNodes = new ArrayList<ResolverNode>();
        List childNodeElements = this.node.elements("node");
        for (Element childNodeElement : childNodeElements) {
            ResolverNode resolverNode = ResolverNodeFactory.getResolverNode(childNodeElement.attributeValue("name"), childNodeElement.attributeValue("type") != null ? childNodeElement.attributeValue("type") : "");
            childNodes.add(resolverNode);
        }
        return childNodes;
    }
}

