/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.validate;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.gdt.designer.core.got.validate.ResolverValidator;
import gongqi.gdt.designer.core.resolvergot.ResolverNode;
import gongqi.gdt.designer.core.resolvergot.ResolverNodeFactory;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class ResolverValidatorPrompt
extends ResolverValidator {
    public ResolverValidatorPrompt(GOTEntity entity) {
        super(entity);
    }

    @Override
    public List<String> validateResolver(GOTNode item) throws NavException, VTDException {
        String dtbInfo;
        ResolverNode rNode = ResolverNodeFactory.getRNodeByItem(item);
        List<String> propertyNames = item.getPropertys().stream().map(p -> {
            try {
                return p.getName();
            }
            catch (NavException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        List<Element> rPropertyList = rNode.getProperties();
        ArrayList<String> result = new ArrayList<String>();
        for (String property : propertyNames) {
            if (!this.matchPropertyRedundant(property, rPropertyList).booleanValue()) continue;
            result.add(String.valueOf(this.getURL(item)) + ":\u591a\u51fa:Property:" + property);
        }
        for (Element rProperty : rPropertyList) {
            if (!this.matchPropertyLack(rProperty, propertyNames).booleanValue()) continue;
            result.add(String.valueOf(this.getURL(item)) + ":\u7f3a\u5c11:Property:" + rProperty.elementText("Name"));
        }
        List<ResolverNode> childResolverNodes = rNode.getChildNodes();
        for (ResolverNode childResolverNode : childResolverNodes) {
            Element infoElement;
            Element nodeElement = childResolverNode.getNode();
            if (nodeElement == null || !StringUtils.isNotBlank((CharSequence)(infoElement = childResolverNode.getNode().element("Info")).elementText("MinOccurs")) || Integer.parseInt(infoElement.elementText("MinOccurs")) <= 0 || !item.selectNodes("./" + childResolverNode.getName()).isEmpty()) continue;
            result.add(String.format("%s\u7f3a\u5c11:%s\u5b50\u8282\u70b9", this.getURL(item), childResolverNode.getName()));
        }
        if (item.isEntityNode() && !(dtbInfo = this.matchDTB(item.getEntity())).equals("")) {
            result.add(0, String.valueOf(this.getURL(item)) + dtbInfo);
        }
        return result;
    }
}

