/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.ui.event;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.designer.core.LayerLevelManager;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.got.vtd.NodeProperty;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.util.GOTDom4jUtils;
import gongqi.gdt.designer.core.event.ValidationResult;
import gongqi.gdt.designer.core.event.ValidationResultEvent;
import gongqi.gdt.designer.core.got.node.NodeFactory;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import info.gongqi.got.help.GOTPPHelpUtil;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.TreeChineseLabel;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.ui.event.MouseRightMenuEvent;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.TreeUIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class TableMouseEvent
extends MouseAdapter {
    public TreeUi treeUi;
    private Logger log = Logger.getLogger(TableMouseEvent.class);
    public boolean first = true;

    public void mouseDoubleClick(MouseEvent e) {
        Table table = this.treeUi.getTable();
        int count = table.getSelectionCount();
        if (count != 0) {
            TableItem item = table.getItem(table.getSelectionIndex());
            Point point = new Point(e.x, e.y);
            int tmpCol = 0;
            int i = 0;
            while (i < table.getColumnCount()) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(point)) {
                    tmpCol = i;
                    break;
                }
                ++i;
            }
            int selectCol = tmpCol;
            if (selectCol == 0) {
                return;
            }
            if (this.first) {
                this.first = false;
            }
            try {
                this.eidtTableItem(table, item, selectCol);
            }
            catch (VTDException vTDException) {
                this.log.error((Object)e);
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 3) {
            Menu menu = new Menu((Control)this.treeUi.getTable());
            List lists = NodeGOT.gridRightMenuData.elements();
            for (final Element element : lists) {
                MenuItem enterRelation = new MenuItem(menu, 8);
                enterRelation.setText(element.attributeValue("label"));
                enterRelation.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        if (element.attributeValue("func").equals("showXML")) {
                            String entityId = (String)TableMouseEvent.this.treeUi.getTable().getSelection()[0].getData("entityId");
                            String xpath = (String)TableMouseEvent.this.treeUi.getTable().getSelection()[0].getData("xpath");
                            String name = TableMouseEvent.this.treeUi.getTable().getSelection()[0].getText();
                            EntityNode entityNode = GotXmlDto.getInstance().getEntityById(entityId);
                            if (entityNode == null) {
                                return;
                            }
                            Element property = (Element)entityNode.toElement().selectSingleNode(String.format("%s/Properties/Property/Name[text()='%s']/..", xpath, name));
                            if (property == null) {
                                return;
                            }
                            GOTMessageDialog.showXmlInfo(MouseRightMenuEvent.formatXml(property.asXML()), "\u4fe1\u606f");
                        } else if (element.attributeValue("func").equals("enterRelation")) {
                            try {
                                TableMouseEvent.this.enterRelation();
                            }
                            catch (Exception e) {
                                TableMouseEvent.this.log.error((Object)"enterRelation\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                            }
                        } else if (element.attributeValue("func").equals("enterNodeExtends")) {
                            TableMouseEvent.this.enterNodeExtends();
                        } else if (element.attributeValue("func").equals("modifyExtends")) {
                            TableMouseEvent.this.modifyExtends();
                        } else if (element.attributeValue("func").equals("help")) {
                            TableMouseEvent.this.help();
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
            }
            this.treeUi.getTable().setMenu(menu);
        }
    }

    public void mouseUp(MouseEvent e) {
        super.mouseUp(e);
    }

    public TableMouseEvent(TreeUi treeUi) {
        this.treeUi = treeUi;
    }

    private void handle(TreeItem treeItem, String newStr, String oldStr, TableItem item) {
        try {
            String propertyName = item.getText(0);
            GOTNode innerNode = TreeUIUtil.getCurrentElement2(treeItem);
            EntityNode entityNode = innerNode.getEntity();
            Element entity = entityNode.toElement();
            Element innerElement = (Element)entity.selectSingleNode(innerNode.getEntityXPath());
            Element propertyElement = (Element)innerElement.selectSingleNode(String.format("./Properties/Property/Name[text()='%s']/..", propertyName));
            String name = item.getText();
            propertyElement.element("Value").setText(newStr);
            String refentityId = propertyElement.attributeValue("refentityid");
            NodeGOT nodeGOT = NodeFactory.getNode(innerElement);
            nodeGOT.setRefentityId(refentityId);
            List<ValidationResult> array = null;
            ValidationResultEvent resultEvent = nodeGOT.validateProperty(propertyElement);
            if (resultEvent != null) {
                array = resultEvent.results;
            }
            if (array == null && (resultEvent = nodeGOT.validatePropertyChanged(propertyElement)) != null) {
                array = resultEvent.results;
            }
            if (array == null) {
                nodeGOT.doAfterPropertyModified(propertyElement, oldStr);
                nodeGOT.setRefentityId("");
                GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(nodeGOT.xml));
                if (!propertyElement.elementText("Value").equals(oldStr)) {
                    ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_MODIFIEDSUCCESS);
                    if (!item.isDisposed()) {
                        item.setText(1, newStr);
                    }
                    GOTNode nodeTar = TreeUIUtil.getCurrentElement2(treeItem);
                    if (name.equals("Extends")) {
                        entityNode = nodeTar.getEntity();
                        Element entityElement = entityNode.toElement();
                        String label = TreeChineseLabel.commitProperties(nodeTar);
                        if (GotXmlDto.getInstance().ifInUnsaveMap(entityNode.getId()) && entityNode.getNodeType().equals("Table") && this.checkIsNewItem(nodeTar.getId(), entityNode.getId()) && treeItem.getText().contains("A_TableField")) {
                            if (newStr.contains(".")) {
                                String[] names = newStr.split("\\.");
                                newStr = names[names.length - 1];
                            }
                            Element elementTar = (Element)entityElement.selectSingleNode(nodeTar.getEntityXPath());
                            String newName = this.setUniqueName(newStr, elementTar);
                            elementTar.addAttribute("name", newName);
                            this.updateInnerItemName(entityElement, elementTar.attributeValue("id"), newName, label);
                        }
                        GotXmlDto.getInstance().updateEntityElement(entityElement);
                    } else if (name.equals("GroupType") && "Group".equals(propertyElement.getParent().getParent().attributeValue("type"))) {
                        if (!item.isDisposed()) {
                            TableItem[] items;
                            TableItem[] tableItemArray = items = item.getParent().getItems();
                            int newName = items.length;
                            int elementTar = 0;
                            while (elementTar < newName) {
                                TableItem tableItem = tableItemArray[elementTar];
                                if (tableItem.getText().equals("Layout")) {
                                    String value = nodeTar.getProperty(name).getValue();
                                    tableItem.setText(1, value);
                                }
                                ++elementTar;
                            }
                        }
                    } else if (name.equals("DataSource") && "FieldGroup".equals(propertyElement.getParent().getParent().attributeValue("type"))) {
                        if (!item.isDisposed()) {
                            TableItem[] items;
                            TableItem[] tableItemArray = items = item.getParent().getItems();
                            int newName = items.length;
                            int elementTar = 0;
                            while (elementTar < newName) {
                                String value;
                                TableItem tableItem = tableItemArray[elementTar];
                                if (tableItem.getText().equals("FieldGroup")) {
                                    value = nodeTar.getProperty(name).getValue();
                                    tableItem.setText(1, value);
                                } else if (tableItem.getText().equals("Component")) {
                                    value = nodeTar.getProperty(name).getValue();
                                    tableItem.setText(1, value);
                                }
                                ++elementTar;
                            }
                        }
                    } else if (name.equals("Component") && "FieldGroup".equals(propertyElement.getParent().getParent().attributeValue("type"))) {
                        String fgId = treeItem.getData("id").toString();
                        for (TreeUi treeUi : FormDataSyn.treeUis) {
                            TreeItem itemTar = treeUi.itemsMap.get(fgId);
                            if (itemTar == null) continue;
                            itemTar.removeAll();
                        }
                        entityNode = nodeTar.getEntity();
                        Element entityElement = entityNode.toElement();
                        GotXmlDto.getInstance().updateEntityElement(entityElement);
                        Element elementTar = (Element)entityElement.selectSingleNode(nodeTar.getEntityXPath());
                        List elements = elementTar.elements("FormItem");
                        int i = 0;
                        while (i < elements.size()) {
                            FormDataSyn.actionSyn(treeItem, (Element)elements.get(i), null, true);
                            ++i;
                        }
                    }
                } else {
                    ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_NOTCHANGED);
                }
            } else {
                propertyElement.element("Value").setText(oldStr);
                String info = String.valueOf(propertyElement.elementText("Name")) + ": ";
                for (ValidationResult r : array) {
                    info = String.valueOf(info) + r.errorMessage;
                }
                ConfigComposite.configComposite.set_text_op_info(info);
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
        }
    }

    public void enterRelation() throws VTDException {
        TableItem[] item = this.treeUi.getTable().getSelection();
        if (item.length == 0) {
            return;
        }
        String entityId = (String)this.treeUi.getTable().getSelection()[0].getData("entityId");
        String xpath = (String)this.treeUi.getTable().getSelection()[0].getData("xpath");
        EntityNode entityNode = GotXmlDto.getInstance().getEntityById(entityId);
        if (entityNode == null) {
            return;
        }
        GOTNode innerNode = entityNode.selectSingleNode(xpath);
        NodeProperty selectedItem = innerNode.getProperty(item[0].getText());
        if (selectedItem != null) {
            EntityNode entity = null;
            String innerId = null;
            if (selectedItem.hasAttribute("innerid")) {
                innerId = selectedItem.getInnerId();
                entity = entityNode;
            } else if (selectedItem.hasAttribute("refinnerid")) {
                innerId = selectedItem.getRefInnerId();
                entity = GotXmlDto.getInstance().getEntityById(selectedItem.getRefEntityId());
            } else if (selectedItem.hasAttribute("refentityid")) {
                entity = GotXmlDto.getInstance().getEntityById(selectedItem.getRefEntityId());
                innerId = null;
            }
            if (entity != null) {
                if ("false".equals(entity.getAttributeValue("fixVisible"))) {
                    return;
                }
                if (!entity.getCreatedLayer().equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer()) && entity.hasAttribute("visible") && entity.getAttributeValue("visible").equals("false")) {
                    return;
                }
                TreeUiBean bean = new TreeUiBean(FormDataSyn.getTreeItrmByNode((GOTNode)entity, null), false);
                TreeItem[] treeItemArray = bean.tree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem iterable_element = treeItemArray[n2];
                    this.expendItems(iterable_element, innerId, bean);
                    ++n2;
                }
            }
        }
    }

    public void expendItems(TreeItem item, String innerId, TreeUiBean bean) {
        GOTNode element;
        item.setExpanded(true);
        if (innerId != null && !innerId.equals("") && innerId.equals((element = TreeUIUtil.getCurrentElement2(item)).getId())) {
            item.getParent().setSelection(item);
            bean.treeUip.loadTableValue(bean.table, element, item);
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem temp = treeItemArray[n2];
            this.expendItems(temp, innerId, bean);
            ++n2;
        }
    }

    public void enterNodeExtends() {
        TableItem itemTable = this.treeUi.getTable().getSelection()[0];
        if ("true".equals(itemTable.getData("batch"))) {
            return;
        }
        TreeItem treeItem = (TreeItem)itemTable.getData("treeItem");
        GOTNode item = TreeUIUtil.getCurrentElement2(treeItem);
        EntityNode _entity = item.getEntity();
        if (_entity == null) {
            return;
        }
        String _entityId = _entity.getId();
        String _innerId = _entityId.equals(item.getId()) ? null : item.getId();
        String result = "";
        try {
            result = LoadXmlCore.gotServices.getNodeExtends(item.getNodeType(), _entityId, _innerId);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
            GOTMessageDialog.alert(e);
        }
        this.rpc_result_getNodeRef(result);
    }

    private void rpc_result_getNodeRef(String result) {
        if (result != null) {
            Element xml = GOTXMLHelper.createElementByXMLString(result);
            GOTMessageDialog.showEnterNodeRef(xml);
        }
    }

    private void modifyExtends() {
        TableItem tableitem = this.treeUi.getTable().getSelection()[0];
        if ("true".equals(tableitem.getData("batch"))) {
            return;
        }
        String entityId = (String)tableitem.getData("entityId");
        String xpath = (String)tableitem.getData("xpath");
        Element entityNode = GotXmlDto.getInstance().getEntity(entityId);
        Element innerNode = (Element)entityNode.selectSingleNode(xpath);
        Element selectedItem = (Element)innerNode.selectSingleNode(String.format("./Properties/Property/Name[text()='%s']/..", tableitem.getText()));
        TreeItem node = (TreeItem)tableitem.getData("treeItem");
        if (selectedItem != null && (selectedItem.attribute("refentityid") != null || selectedItem.attribute("refinnerid") != null || selectedItem.attribute("innerid") != null)) {
            GOTMessageDialog.modifyExtendsDialog(selectedItem);
            GOTNode element = TreeUIUtil.getCurrentElement2(node);
            this.treeUi.loadTableValue(this.treeUi.getTable(), element, node);
        }
    }

    private void help() {
        TableItem tableitem = this.treeUi.getTable().getSelection()[0];
        String entityId = (String)tableitem.getData("entityId");
        String xpath = (String)tableitem.getData("xpath");
        EntityNode entity = GotXmlDto.getInstance().getEntityById(entityId);
        try {
            GOTNode innerNode = entity.selectSingleNode(xpath);
            String propertyName = tableitem.getText();
            String path = String.format("//%s/Properties/Property/Name[text()='%s']/..", innerNode.getNodeType(), propertyName);
            String type = entity.getNodeType();
            if (type.equals("DataType")) {
                String type_ = entity.getNodeType();
                type = String.valueOf(type) + "-" + type_;
            }
            String xml = GOTPPHelpUtil.getPPHelpText(type, path, propertyName);
            GOTMessageDialog.showXmlInfo(xml, "\u5e2e\u52a9");
        }
        catch (VTDException e) {
            this.log.error((Object)e);
        }
    }

    public void eidtTableItem(Table table, TableItem item, int selectCol) throws VTDException {
        int nodeCreateLayerLevel;
        String propertyName = item.getText(0);
        List<TreeItem> treeItems = new ArrayList<TreeItem>();
        if ("true".equals(item.getData("batch"))) {
            treeItems = (List)item.getData("treeItems");
        } else {
            treeItems.add((TreeItem)item.getData("treeItem"));
        }
        if (treeItems.isEmpty()) {
            return;
        }
        TreeItem treeItem = (TreeItem)treeItems.get(0);
        GOTNode innerNode = TreeUIUtil.getCurrentElement2(treeItem);
        String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        if (!(!"plg".equals(currentLayer) || (nodeCreateLayerLevel = ((LayerLevelManager)ObjectContainer.getInstance(LayerLevelManager.class)).getLayerLevel(innerNode.getCreatedLayer())) >= 5 || "FormItem".equals(innerNode.getName()) && "Visible".equals(propertyName))) {
            return;
        }
        Element entityElement = innerNode.getEntity().toElement();
        Element innerElement = (Element)entityElement.selectSingleNode(innerNode.getEntityXPath());
        NodeGOT node = NodeFactory.getNode(innerElement);
        String allowInfo = node.allowPropertyEdit(propertyName);
        if (!allowInfo.equals(Macros.INFO_TRUE)) {
            if (!allowInfo.equals(Macros.INFO_FALSE)) {
                TreeOperationInfo.addErrorInfo(allowInfo);
                ConfigComposite.configComposite.set_text_op_info(allowInfo);
            }
            return;
        }
        String proType = node.resolverNode.getPropertyValue(propertyName, "Type");
        if (proType.equals("enum") || proType.equals("comboBox") || proType.equals("boolean") || propertyName.equals("DataMethod")) {
            List<String> array = node.getPropertyItemEditorArray(propertyName, "", innerNode);
            if (array == null) {
                return;
            }
            Collections.sort(array);
            this.comboEdit(table, item, selectCol, treeItems, array);
        } else {
            this.textEdit(table, item, selectCol, treeItems);
        }
    }

    public String[] selectItems(String[] strs, String tar) {
        tar = tar.trim();
        ArrayList<String> lists = new ArrayList<String>();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String temp = stringArray[n2];
            String last = "";
            if (temp.contains(".")) {
                String[] name = temp.split("\\.");
                last = name[name.length - 1];
            }
            if (temp.toLowerCase().startsWith(tar.toLowerCase()) || temp.equals("") || last.toLowerCase().startsWith(tar.toLowerCase())) {
                lists.add(temp);
            }
            ++n2;
        }
        return lists.toArray(new String[lists.size()]);
    }

    public void textEdit(final Table table, final TableItem item, final int selectCol, final List<TreeItem> treeItems) throws NavException {
        final int selectionIndex = table.getSelectionIndex();
        String propertyName = item.getText(0);
        if ("DisplayStyle".equals(propertyName)) {
            for (TreeItem treeitem : treeItems) {
                GOTNode innerNode = TreeUIUtil.getCurrentElement2(treeitem);
                EntityNode entityNode = innerNode.getEntity();
                Element entity = entityNode.toElement();
                Element innerElement = (Element)entity.selectSingleNode(innerNode.getEntityXPath());
                Element propertyElement = (Element)innerElement.selectSingleNode(String.format("./Properties/Property/Name[text()='%s']/..", propertyName));
                String orgText = item.getText(1);
                String aValue = GOTMessageDialog.displayStyleDialog(orgText);
                if (aValue == null || aValue.equals(orgText)) {
                    return;
                }
                propertyElement.element("Value").setText(aValue);
                GotXmlDto.getInstance().updateEntityElement(entity);
                FormDataSyn.restore(treeitem, null);
            }
            return;
        }
        final TableEditor editor = new TableEditor(table);
        Control oldEditor = editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        final Text changeItemText = new Text((Composite)table, 0);
        changeItemText.computeSize(-1, table.getItemHeight());
        editor.grabHorizontal = true;
        editor.minimumHeight = changeItemText.getSize().y;
        editor.minimumWidth = changeItemText.getSize().x;
        editor.setEditor((Control)changeItemText, item, selectCol);
        String labelText = item.getText(selectCol);
        if (((Boolean)item.getData("ifExtend")).booleanValue()) {
            labelText = "";
        }
        changeItemText.setFont(item.getFont());
        changeItemText.setText(labelText);
        changeItemText.forceFocus();
        changeItemText.selectAll();
        changeItemText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusevent) {
                Control defaultEditor = editor.getEditor();
                editor.setEditor(defaultEditor, item, selectCol);
                String cT = changeItemText.getText();
                String iT = item.getText(selectCol);
                if (cT.equals(iT) || ((Boolean)item.getData("ifExtend")).booleanValue() && cT.equals("")) {
                    ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_NOTCHANGED);
                    item.setText(selectCol, item.getText(selectCol));
                } else {
                    String newValue = changeItemText.getText();
                    for (TreeItem treeItem : treeItems) {
                        TableMouseEvent.this.handle(treeItem, newValue, item.getText(selectCol), item);
                    }
                    FormDataSyn.restore((TreeItem)treeItems.get(0), null);
                }
                changeItemText.dispose();
                table.select(selectionIndex);
                TableMouseEvent.this.first = true;
            }
        });
        changeItemText.addKeyListener((KeyListener)new KeyAdapter(){
            private boolean entryKeyIn = false;

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    if (this.entryKeyIn) {
                        table.forceFocus();
                    } else {
                        this.entryKeyIn = true;
                    }
                }
            }
        });
    }

    public void comboEdit(final Table table, final TableItem item, final int selectCol, final List<TreeItem> treeitems, List<String> array) throws NavException {
        final TableEditor editor = new TableEditor(table);
        Control oldEditor = editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        final int selectionIndex = table.getSelectionIndex();
        String propertyName = item.getText(0);
        if ("AttachmentFileType".equals(propertyName)) {
            for (TreeItem treeitem : treeitems) {
                GOTNode innerNode = TreeUIUtil.getCurrentElement2(treeitem);
                EntityNode entityNode = innerNode.getEntity();
                Element entity = entityNode.toElement();
                Element innerElement = (Element)entity.selectSingleNode(innerNode.getEntityXPath());
                Element propertyElement = (Element)innerElement.selectSingleNode(String.format("./Properties/Property/Name[text()='%s']/..", propertyName));
                String aValue = GOTMessageDialog.fileTypeSelect(item.getText(selectCol));
                String orgText = item.getText(1);
                if (aValue == null || aValue.equals(orgText)) {
                    return;
                }
                propertyElement.element("Value").setText(aValue);
                GotXmlDto.getInstance().updateEntityElement(entity);
                innerNode = TreeUIUtil.getCurrentElement2(treeitem);
                FormDataSyn.restore(treeitem, innerNode);
            }
            return;
        }
        if (array.size() < 1) {
            array.add(0, "");
        } else if (!array.get(0).equals("")) {
            array.add(0, "");
        }
        Object[] comItem = array.toArray(new String[array.size()]);
        final String allComItemStr = StringUtils.join((Object[])comItem);
        final Combo comOptionValue = new Combo((Composite)table, 2048);
        comOptionValue.setFont(table.getFont());
        comOptionValue.setItems((String[])comItem);
        comOptionValue.computeSize(-1, table.getItemHeight());
        editor.grabHorizontal = true;
        editor.minimumHeight = comOptionValue.getSize().y - 2;
        editor.minimumWidth = comOptionValue.getSize().x;
        editor.setEditor((Control)comOptionValue, item, selectCol);
        if (((Boolean)item.getData("ifExtend")).booleanValue()) {
            comOptionValue.setText("");
        } else {
            comOptionValue.setText(item.getText(selectCol));
        }
        comOptionValue.forceFocus();
        comOptionValue.setListVisible(true);
        comOptionValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!comOptionValue.getListVisible()) {
                    Control defaultEditor = editor.getEditor();
                    editor.setEditor(defaultEditor, item, selectCol);
                    if (comOptionValue.getText().equals(item.getText(selectCol)) || !allComItemStr.contains(comOptionValue.getText()) || comOptionValue.getText().equals("") && ((Boolean)item.getData("ifExtend")).booleanValue()) {
                        ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_NOTCHANGED);
                        item.setText(selectCol, item.getText(selectCol));
                    } else {
                        String newValue = comOptionValue.getText();
                        for (TreeItem treeitem : treeitems) {
                            TableMouseEvent.this.handle(treeitem, newValue, item.getText(selectCol), item);
                        }
                        FormDataSyn.restore((TreeItem)treeitems.get(0), null);
                    }
                    TableMouseEvent.this.first = true;
                    comOptionValue.dispose();
                }
                table.select(selectionIndex);
            }
        });
        comOptionValue.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusevent) {
                table.select(selectionIndex);
                TableMouseEvent.this.first = true;
                comOptionValue.dispose();
            }

            public void focusGained(FocusEvent e) {
                comOptionValue.setListVisible(true);
            }
        });
        comOptionValue.addKeyListener((KeyListener)new KeyAdapter((String[])comItem){
            private final /* synthetic */ String[] val$comItem;
            {
                this.val$comItem = stringArray;
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000005 || e.keyCode == 0x1000006 || e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                    e.doit = false;
                    return;
                }
                if (e.keyCode == 13) {
                    if (e.keyCode == 13) {
                        if (!TableMouseEvent.this.first) {
                            Control defaultEditor = editor.getEditor();
                            editor.setEditor(defaultEditor, item, selectCol);
                            if (comOptionValue.getText().equals(item.getText(selectCol)) || !allComItemStr.contains(comOptionValue.getText()) || comOptionValue.getText().equals("") && ((Boolean)item.getData("ifExtend")).booleanValue()) {
                                ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_NOTCHANGED);
                                item.setText(selectCol, item.getText(selectCol));
                            } else {
                                for (TreeItem treeitem : treeitems) {
                                    TableMouseEvent.this.handle(treeitem, comOptionValue.getText(), item.getText(selectCol), item);
                                }
                                FormDataSyn.restore((TreeItem)treeitems.get(0), null);
                            }
                            table.select(selectionIndex);
                            TableMouseEvent.this.first = true;
                            comOptionValue.dispose();
                        } else {
                            TableMouseEvent.this.first = false;
                        }
                    }
                } else if (String.valueOf(e.character).matches("[a-zA-Z0-1]") || e.keyCode == 8) {
                    String newStr = comOptionValue.getText();
                    if (StringUtils.isNotBlank((String)newStr)) {
                        String[] items = TableMouseEvent.this.selectItems(this.val$comItem, newStr);
                        comOptionValue.setItems(items);
                        if (items.length < 10) {
                            comOptionValue.setVisibleItemCount(items.length);
                        } else {
                            comOptionValue.setVisibleItemCount(10);
                        }
                        comOptionValue.setListVisible(true);
                        comOptionValue.setText(newStr);
                        comOptionValue.setSelection(comOptionValue.getSize());
                        comOptionValue.forceFocus();
                    } else {
                        comOptionValue.setItems(this.val$comItem);
                        if (this.val$comItem.length < 10) {
                            comOptionValue.setVisibleItemCount(this.val$comItem.length);
                        } else {
                            comOptionValue.setVisibleItemCount(10);
                        }
                        comOptionValue.setListVisible(true);
                    }
                }
            }
        });
    }

    private boolean checkIsNewItem(String itemId, String id) {
        String xpath;
        EntityNode result = LoadXmlCore.gotServices.getEntity(id);
        if (result == null) {
            return true;
        }
        Element resultXML = GOTXMLHelper.createElementByXMLString(result.asXML());
        List list = resultXML.selectNodes(xpath = "TableFields/TableField[@id='" + itemId + "']");
        return list == null || list.isEmpty();
    }

    private void updateInnerItemName(Element entity, String id, String name, String label) {
        String xpath = "//Properties/Property[@innerid='" + id + "']";
        List elements = entity.selectNodes(xpath);
        for (Element element : elements) {
            element = element.getParent().getParent();
            for (TreeUi ui : FormDataSyn.treeUis) {
                TreeItem item = FormDataSyn.getTreeItrmByElement(element, ui);
                if (item == null) continue;
                item.setText(name);
                item.setData("label", (Object)label);
                element.addAttribute("name", name);
            }
        }
    }

    private String setUniqueName(String name, Element element) {
        if (GOTDom4jUtils.isNamespaceId((String)element.attributeValue("id"))) {
            String namespace = GOTDom4jUtils.getNamespaceById((String)element.attributeValue("id"));
            if (!name.contains(".")) {
                name = String.valueOf(namespace) + "." + name;
            }
        }
        List elements = element.getParent().elements();
        String temp = name;
        int last = 0;
        boolean same = false;
        for (Element element2 : elements) {
            int num;
            String attrName;
            if (element.equals(element2) || !(attrName = element2.attributeValue("name")).startsWith(name)) continue;
            if (attrName.equals(name)) {
                same = true;
            }
            if (!TableMouseEvent.isNumber(attrName = attrName.replace(name, "")) || (num = Integer.valueOf(attrName).intValue()) <= last) continue;
            last = num;
        }
        if (last > 0) {
            temp = String.valueOf(name) + ++last;
        } else if (same) {
            temp = String.valueOf(name) + 1;
        }
        return temp;
    }

    public static boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }
}

