/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.gdt.designer.core.got.validate.EntityValidateService;
import gongqi.gdt.designer.core.got.validate.ValidateResult;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.ui.MergeMatchResultDialog;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.util.GOTMessageDialog;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class MergeMatchingTips
extends Dialog {
    protected Object resultDialog = "";
    protected Shell shell;
    public ProgressBar progressBar;
    private Boolean canceled = false;

    public MergeMatchingTips(Shell parent, int style) {
        super(parent, style);
        this.setText("\u6b63\u5728\u9a8c\u8bc1");
    }

    public Object open(Button btn, List<GOTEntity> entityNodes, EntityValidateService.MergeMatching type) {
        this.createContents(btn, entityNodes, type);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.resultDialog;
    }

    private void createContents(Button btn, List<GOTEntity> entityNodes, EntityValidateService.MergeMatching type) {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MergeMatchingTips.this.canceled = true;
            }
        });
        this.shell.setSize(600, 50);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.progressBar = new ProgressBar((Composite)this.shell, 65536);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        new Thread(() -> this.start(btn, entityNodes, type)).start();
        GOTMessageDialog.shells.add(this.shell);
    }

    private void start(final Button btn, List<GOTEntity> entityNodes, EntityValidateService.MergeMatching type) {
        long currentTimeMillis = System.currentTimeMillis();
        int cur = 0;
        int total = entityNodes.size();
        final ArrayList<ValidateResult> results = new ArrayList<ValidateResult>();
        for (GOTEntity entityNode : entityNodes) {
            ValidateResult result;
            if (this.canceled.booleanValue()) {
                this.canceled = false;
                this.setAlert("", "\u8bca\u65ad\u4fe1\u606f(\u64cd\u4f5c\u88ab\u4e2d\u65ad)");
                return;
            }
            BigDecimal percent = BigDecimal.valueOf(cur * 100).divide(BigDecimal.valueOf(total), 2, RoundingMode.HALF_UP);
            this.setShellText("\u6b63\u5728\u9a8c\u8bc1" + entityNode.getName() + " " + percent.toString() + "%");
            this.setProgressBar(percent.intValue());
            ++cur;
            if (!LoadXML.nodeShowRuleDoMerge(entityNode) || (result = new EntityValidateService(entityNode, type).validateResolver()).getResults().isEmpty()) continue;
            results.add(result);
        }
        long time = System.currentTimeMillis() - currentTimeMillis;
        System.out.println(time);
        this.setProgressBar(100);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!MergeMatchingTips.this.shell.isDisposed()) {
                    MergeMatchingTips.this.shell.close();
                }
                if (results.isEmpty()) {
                    btn.setBackground(Display.getDefault().getSystemColor(1));
                    GOTMessageDialog.showXmlInfo("\u672a\u53d1\u73b0\u5dee\u5f02", "\u8bca\u65ad\u4fe1\u606f");
                } else {
                    btn.setBackground(Display.getDefault().getSystemColor(3));
                    MergeMatchResultDialog dialog = new MergeMatchResultDialog(results);
                    dialog.open();
                }
            }
        });
    }

    public void setProgressBar(final int num) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeMatchingTips.this.progressBar.isDisposed()) {
                    return;
                }
                MergeMatchingTips.this.progressBar.setSelection(num);
            }
        });
    }

    public void setShellText(final String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeMatchingTips.this.shell.isDisposed()) {
                    return;
                }
                MergeMatchingTips.this.shell.setText(text);
            }
        });
    }

    public void setAlert(final String text, final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GOTMessageDialog.showXmlInfo(text, title);
            }
        });
    }
}

