/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.handler;

import gongqi.designer.core.LayerChainContext;
import gongqi.designer.got.GOTManager;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.tools.StringHelper;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.core.LayeredGOTEntityManager;
import gongqi.gdt.designer.handler.JDTHandler;
import gongqi.gdt.osgi.JDTService;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class CodeOperateHandler {
    public static boolean addMethod(String classId) {
        JDTService server = JDTHandler.getServer();
        if (server != null) {
            try {
                server.openMethodInEditor(CodeOperateHandler.getEntityFullyQualifiedName(classId), null, null);
            }
            catch (Throwable e) {
                throw new ERPException("\u83b7\u53d6\u672a\u5b9e\u73b0\u65b9\u6cd5\u5f02\u5e38", e);
            }
        }
        return true;
    }

    public static boolean deleteMethod(String classId, String methodName, String parameterTypes) {
        JDTService server = JDTHandler.getServer();
        if (server != null) {
            try {
                String[] methodPatameterTypes = new String[]{};
                if (StringHelper.isNotBlank((String)parameterTypes) && parameterTypes.length() > 0) {
                    methodPatameterTypes = parameterTypes.indexOf(64) == -1 ? new String[]{parameterTypes} : parameterTypes.split("@");
                }
                String fullyQualifiedName = CodeOperateHandler.getEntityFullyQualifiedName(classId);
                server.deleteMethod(fullyQualifiedName, methodName, methodPatameterTypes);
            }
            catch (Exception e) {
                throw new ERPException("\u83b7\u53d6\u672a\u5b9e\u73b0\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            }
        }
        return true;
    }

    public static boolean editMethod(String classId, String methodName, String parameterTypes) {
        JDTService server = JDTHandler.getServer();
        if (server != null) {
            try {
                String[] methodPatameterTypes = new String[]{};
                if (StringHelper.isNotBlank((String)parameterTypes) && parameterTypes.length() > 0) {
                    methodPatameterTypes = parameterTypes.indexOf(64) == -1 ? new String[]{parameterTypes} : parameterTypes.split("@");
                }
                String fullyQualifiedName = CodeOperateHandler.getEntityFullyQualifiedName(classId);
                server.openMethodInEditor(fullyQualifiedName, methodName, methodPatameterTypes);
            }
            catch (Exception e) {
                throw new ERPException("\u83b7\u53d6\u672a\u5b9e\u73b0\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            }
        }
        return true;
    }

    public static Object getMethodsCanbeOverride(String classId) {
        List methods = new ArrayList();
        JDTService server = JDTHandler.getServer();
        if (server != null) {
            try {
                String entityId = classId.split("-")[0];
                Element entityElement = ((GOTManager)ObjectContainer.getInstance(GOTManager.class)).getEntity(entityId);
                String fullyQualifiedName = CodeOperateHandler.getEntityFullyQualifiedName(classId);
                methods = server.getTypeUnImplementMethods(entityElement.attributeValue("name"), fullyQualifiedName, entityElement.attributeValue("modifiedLayer"));
                for (Map method : methods) {
                    int modifier = (Integer)method.get("modifier");
                    if (Modifier.isPublic(modifier)) {
                        method.put("modifier", "public");
                    } else if (Modifier.isProtected(modifier)) {
                        method.put("modifier", "protected");
                    }
                    String[] parameterTypes = (String[])method.get("parameterTypes");
                    StringBuffer buff = new StringBuffer("@");
                    String[] stringArray = parameterTypes;
                    int n = parameterTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String parameterType = stringArray[n2];
                        buff.append(String.valueOf(parameterType) + "@");
                        ++n2;
                    }
                    method.put("parameterTypes", buff.length() > 1 ? buff.substring(1, buff.length() - 1) : "");
                }
            }
            catch (Exception e) {
                throw new ERPException("\u83b7\u53d6\u672a\u5b9e\u73b0\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            }
        }
        return methods;
    }

    public static Object getMethodsImplemented(String classId) {
        List methods = new ArrayList();
        JDTService server = JDTHandler.getServer();
        if (server != null) {
            try {
                String entityId = classId.split("-")[0];
                Element entityElement = ((GOTManager)ObjectContainer.getInstance(GOTManager.class)).getEntity(entityId);
                String fullyQualifiedName = CodeOperateHandler.getEntityFullyQualifiedName(classId);
                methods = server.getTypeImplementMethods(entityElement.attributeValue("name"), fullyQualifiedName, entityElement.attributeValue("modifiedLayer"));
                for (Map method : methods) {
                    int modifier = (Integer)method.get("modifier");
                    if (Modifier.isPublic(modifier)) {
                        method.put("modifier", "public");
                    } else if (Modifier.isProtected(modifier)) {
                        method.put("modifier", "protected");
                    }
                    String[] parameterTypes = (String[])method.get("parameterTypes");
                    StringBuffer buff = new StringBuffer("@");
                    String[] stringArray = parameterTypes;
                    int n = parameterTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String parameterType = stringArray[n2];
                        buff.append(String.valueOf(parameterType) + "@");
                        ++n2;
                    }
                    method.put("parameterTypes", buff.length() > 1 ? buff.substring(1, buff.length() - 1) : "");
                }
            }
            catch (Throwable e) {
                throw new ERPException("\u83b7\u53d6\u672a\u5b9e\u73b0\u65b9\u6cd5\u5f02\u5e38", e);
            }
        }
        return methods;
    }

    public static boolean overrideMethod(String classId, String methodName, String nodeName, String parameterTypes) throws Exception {
        JDTService server = JDTHandler.getServer();
        if (server != null) {
            String[] methodPatameterTypes = new String[]{};
            if (StringHelper.isNotBlank((String)parameterTypes) && parameterTypes.length() > 0) {
                methodPatameterTypes = parameterTypes.indexOf(64) == -1 ? new String[]{parameterTypes} : parameterTypes.split("@");
            }
            String fullyQualifiedName = CodeOperateHandler.getEntityFullyQualifiedName(classId);
            server.overrideMethod(fullyQualifiedName, methodName, nodeName, methodPatameterTypes);
        }
        return true;
    }

    private static String getEntityFullyQualifiedName(String classId) {
        String entityFullyQualifiedName = null;
        String[] classIdArray = classId.split("-");
        String entityId = classIdArray[0];
        Element entityElement = ((GOTManager)ObjectContainer.getInstance(GOTManager.class)).getEntity(entityId);
        String createdLayer = entityElement.attributeValue("createdLayer");
        String modifiedLayer = entityElement.attributeValue("modifiedLayer");
        LayeredGOTEntityManager entityManager = (LayeredGOTEntityManager)ObjectContainer.getInstance(LayeredGOTEntityManager.class);
        EntityType entityType = entityManager.getEntityType(entityId);
        EntityNode entityNode = ((GOTManager)ObjectContainer.getInstance(GOTManager.class)).getEntityNode(entityId);
        if (entityNode == null) {
            throw new ERPException(String.format("\u65e0\u6548\u7684\u5b9e\u4f53\u7f16\u53f7\uff1a%s", entityId));
        }
        if (entityType == EntityType.Table) {
            Element tableElement = GOTHelper.getTable((String)entityId);
            String tableName = tableElement.attributeValue("name");
            String hostingLayer = tableElement.attributeValue("modifiedLayer");
            if (entityManager.isSolutionEntityId(entityId)) {
                if ("plg".equals(createdLayer) && "ext".equals(modifiedLayer)) {
                    String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
                    SolutionPluginDefinition solutionPluginDefinition = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(solutionPluginName);
                    String solutionName = solutionPluginDefinition.getSolutionName();
                    entityFullyQualifiedName = String.format("%s.layers.%s.tables.%s", solutionName, hostingLayer, tableName.substring(tableName.lastIndexOf(".") + 1));
                } else {
                    String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
                    entityFullyQualifiedName = String.format("%s.layers.%s.tables.%s", solutionName, hostingLayer, tableName.substring(tableName.lastIndexOf(".") + 1));
                }
            } else {
                entityFullyQualifiedName = String.format("gongqi.erp.layers.%s.tables.%s", hostingLayer, tableName);
            }
        } else if (entityType == EntityType.Form) {
            Element formElement = GOTHelper.getForm((String)entityId);
            String formName = formElement.attributeValue("name");
            String hostingLayer = formElement.attributeValue("modifiedLayer");
            if ("Form".equals(classIdArray[1])) {
                if (entityManager.isSolutionEntityId(entityId)) {
                    if ("plg".equals(createdLayer) && "ext".equals(modifiedLayer)) {
                        String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
                        SolutionPluginDefinition solutionPluginDefinition = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(solutionPluginName);
                        String solutionName = solutionPluginDefinition.getSolutionName();
                        String formSimpleName = formName.substring(formName.lastIndexOf(".") + 1);
                        entityFullyQualifiedName = String.format("%s.layers.%s.forms.%s.Form_%s", solutionName, hostingLayer, formSimpleName, formSimpleName);
                    } else if ("app".equals(createdLayer) && "plg".equals(modifiedLayer)) {
                        String solutionPluginName = LayerChainContext.getCurrentSolutionPluginName();
                        String formSimpleName = formName.substring(formName.lastIndexOf(".") + 1);
                        entityFullyQualifiedName = String.format("%s.layers.%s.forms.%s.Form_%s", solutionPluginName, hostingLayer, formSimpleName, formSimpleName);
                    } else {
                        String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
                        String formSimpleName = formName.substring(formName.lastIndexOf(".") + 1);
                        entityFullyQualifiedName = String.format("%s.layers.%s.forms.%s.Form_%s", solutionName, hostingLayer, formSimpleName, formSimpleName);
                    }
                } else {
                    entityFullyQualifiedName = String.format("gongqi.erp.layers.%s.forms.%s.Form_%s", hostingLayer, formName, formName);
                }
            } else if ("FormDataSource".equals(classIdArray[1])) {
                Element formDataSourceElement = (Element)formElement.selectSingleNode(String.format("FormDataSources/FormDataSource[@id='%s']", classIdArray[2]));
                if (entityManager.isSolutionEntityId(entityId)) {
                    if ("plg".equals(createdLayer) && "ext".equals(modifiedLayer)) {
                        String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
                        SolutionPluginDefinition solutionPluginDefinition = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(solutionPluginName);
                        String solutionName = solutionPluginDefinition.getSolutionName();
                        String formSimpleName = formName.substring(formName.lastIndexOf(".") + 1);
                        String formDataSourceSimpleName = formDataSourceElement.attributeValue("name");
                        if (formDataSourceSimpleName.contains(".")) {
                            formDataSourceSimpleName = formDataSourceSimpleName.substring(formDataSourceSimpleName.lastIndexOf(".") + 1);
                        }
                        entityFullyQualifiedName = String.format("%s.layers.%s.forms.%s.datasource.Form_%s_DataSource_%s", solutionName, hostingLayer, formSimpleName, formSimpleName, formDataSourceSimpleName);
                    } else if ("app".equals(createdLayer) && "plg".equals(modifiedLayer)) {
                        String solutionPluginName = LayerChainContext.getCurrentSolutionPluginName();
                        String formSimpleName = formName.substring(formName.lastIndexOf(".") + 1);
                        String formDataSourceSimpleName = formDataSourceElement.attributeValue("name");
                        if (formDataSourceSimpleName.contains(".")) {
                            formDataSourceSimpleName = formDataSourceSimpleName.substring(formDataSourceSimpleName.lastIndexOf(".") + 1);
                        }
                        entityFullyQualifiedName = String.format("%s.layers.%s.forms.%s.datasource.Form_%s_DataSource_%s", solutionPluginName, hostingLayer, formSimpleName, formSimpleName, formDataSourceSimpleName);
                    } else {
                        String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
                        String formSimpleName = formName.substring(formName.lastIndexOf(".") + 1);
                        String formDataSourceSimpleName = formDataSourceElement.attributeValue("name");
                        if (formDataSourceSimpleName.contains(".")) {
                            formDataSourceSimpleName = formDataSourceSimpleName.substring(formDataSourceSimpleName.lastIndexOf(".") + 1);
                        }
                        entityFullyQualifiedName = String.format("%s.layers.%s.forms.%s.datasource.Form_%s_DataSource_%s", solutionName, hostingLayer, formSimpleName, formSimpleName, formDataSourceSimpleName);
                    }
                } else {
                    entityFullyQualifiedName = String.format("gongqi.erp.layers.%s.forms.%s.datasource.Form_%s_DataSource_%s", hostingLayer, formName, formName, formDataSourceElement.attributeValue("name"));
                }
            }
        }
        return entityFullyQualifiedName;
    }
}

