/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.toolsgot;

import gongqi.gdt.designer.core.got.node.NodeFactory;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.got.validate.DoMerge;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GOTXMLHelper {
    public static final String AutoField_CreateDate = "CreatedDate";
    public static final String AutoField_CreatedTime = "CreatedTime";
    public static final String AutoField_CreatedBy = "CreatedBy";
    public static final String AutoField_ModifiedDate = "ModifiedDate";
    public static final String AutoField_ModifiedTime = "ModifiedTime";
    public static final String AutoField_ModifiedBy = "ModifiedBy";
    public static final String AutoField_RecVersion = "RecVersion";
    public static final String AutoField_RecId = "RecId";
    private static Map<String, Element> autoTableFields = new LinkedHashMap<String, Element>();
    private static List<Element> autoTableFieldGroupItems = new ArrayList<Element>();
    private static Element autoRecIdxTableIndex = null;
    private static Element createdSessionId = null;
    private static Element modifiedSessionId = null;

    public static Element createElement(String name) {
        String xml = "<" + name + " />";
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            Logger.getLogger(GOTXMLHelper.class).error((Object)e);
        }
        Element root = document.getRootElement();
        return root;
    }

    public static Element createElementByXMLString(String xml) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            Logger.getLogger(DoMerge.class).error((Object)e);
        }
        Element root = document.getRootElement();
        return root;
    }

    public static void addDateAndTime(Element baseXML) {
        GOTXMLHelper.addProperty(baseXML, AutoField_CreateDate, "");
        GOTXMLHelper.addProperty(baseXML, AutoField_CreatedTime, "");
        GOTXMLHelper.addProperty(baseXML, AutoField_CreatedBy, "");
        GOTXMLHelper.addProperty(baseXML, AutoField_ModifiedDate, "");
        GOTXMLHelper.addProperty(baseXML, AutoField_ModifiedTime, "");
        GOTXMLHelper.addProperty(baseXML, AutoField_ModifiedBy, "");
    }

    public static void addProperty(Element baseXML, String name, String value) {
        Element ps;
        if (baseXML.element("Properties") != null) {
            ps = baseXML.element("Properties");
        } else {
            baseXML.addElement("Properties", "");
            ps = baseXML.element("Properties");
        }
        List proList = ps.elements("Property");
        Boolean isExist = false;
        for (Element pro : proList) {
            if (!pro.elementText("Name").equals(name)) continue;
            isExist = true;
            if (pro.element("Value") == null) {
                pro.addElement("Value", value);
                break;
            }
            pro.element("Value").setText(value);
            break;
        }
        if (!isExist.booleanValue()) {
            String xml = "<Property><Name>" + name + "</Name>" + "<Value>" + value + "</Value>" + "</Property>";
            ps.add(GOTXMLHelper.createElementByXMLString(xml).detach());
        }
    }

    public static void setProperty(Element baseXML, String name, String value, Boolean overwrite) {
        List propertyList = baseXML.element("Properties").elements("Property");
        for (Element property : propertyList) {
            if (!property.elementText("Name").equals(name)) continue;
            if (overwrite.booleanValue()) {
                property.element("Value").setText(value);
                continue;
            }
            if (!property.elementText("Value").equals("")) continue;
            property.element("Value").setText(value);
        }
    }

    public static String getPropertyValue(Element node, String propertyName) {
        return GOTHelp.getPPAttValue(node, "Name", propertyName);
    }

    private static Element initAutoElement(NodeGOT node, String id, String refentityid, String refentityValue) {
        Element element = node.xml.createCopy();
        element.addAttribute("id", id);
        element.addAttribute("name", refentityValue);
        element.addAttribute("fixVisible", "false");
        Element extend = GOTHelp.getPPAttElement(element, "Name", "Extends");
        extend.addAttribute("refentityid", refentityid);
        extend.element("Value").setText(refentityValue);
        Element allowEdit = GOTHelp.getPPAttElement(element, "Name", "AllowEdit");
        allowEdit.element("Value").setText("Never");
        Element notNull = GOTHelp.getPPAttElement(element, "Name", "NotNull");
        notNull.element("Value").setText("false");
        return element;
    }

    public static List<Element> getAutoTableFields() {
        return autoTableFields.values().stream().map(f -> f.createCopy()).collect(Collectors.toList());
    }

    public static Element getAutoTableField(String fieldId) {
        if (autoTableFields.containsKey(fieldId)) {
            return autoTableFields.get(fieldId).createCopy();
        }
        return null;
    }

    public static List<Element> getAutoTableFieldGroupItems() {
        return autoTableFieldGroupItems.stream().map(f -> f.createCopy()).collect(Collectors.toList());
    }

    public static Element getAutoRecIdxTableIndex() {
        return autoRecIdxTableIndex.createCopy();
    }

    public static Element getCreatedSessionId() {
        return createdSessionId.createCopy();
    }

    public static Element getModifiedSessionId() {
        return modifiedSessionId.createCopy();
    }

    public static void init() {
        autoTableFields = new LinkedHashMap<String, Element>();
        NodeGOT dateNode = NodeFactory.createNode("TableField", "Date", "");
        NodeGOT timeNode = NodeFactory.createNode("TableField", "Time", "");
        NodeGOT stringNode = NodeFactory.createNode("TableField", "String", "");
        NodeGOT longNode = NodeFactory.createNode("TableField", "Long", "");
        Element createdDate = GOTXMLHelper.initAutoElement(dateNode, "7", "20000008", AutoField_CreateDate);
        autoTableFields.put(AutoField_CreateDate, createdDate);
        Element createdTime = GOTXMLHelper.initAutoElement(timeNode, "8", "20000010", AutoField_CreatedTime);
        autoTableFields.put(AutoField_CreatedTime, createdTime);
        Element createdBy = GOTXMLHelper.initAutoElement(stringNode, "9", "20000007", AutoField_CreatedBy);
        autoTableFields.put(AutoField_CreatedBy, createdBy);
        Element modifiedDate = GOTXMLHelper.initAutoElement(dateNode, "11", "20000012", AutoField_ModifiedDate);
        autoTableFields.put(AutoField_ModifiedDate, modifiedDate);
        Element modifiedTime = GOTXMLHelper.initAutoElement(timeNode, "12", "20000014", AutoField_ModifiedTime);
        autoTableFields.put(AutoField_ModifiedTime, modifiedTime);
        Element modifiedBy = GOTXMLHelper.initAutoElement(stringNode, "13", "20000011", AutoField_ModifiedBy);
        autoTableFields.put(AutoField_ModifiedBy, modifiedBy);
        Element recVersion = GOTXMLHelper.initAutoElement(longNode, "5", "20000002", AutoField_RecVersion);
        autoTableFields.put(AutoField_RecVersion, recVersion);
        Element recId = GOTXMLHelper.initAutoElement(longNode, "4", "20000001", AutoField_RecId);
        autoTableFields.put(AutoField_RecId, recId);
        NodeGOT tableIndexNode = NodeFactory.createNode("TableIndex", "", "");
        autoRecIdxTableIndex = tableIndexNode.xml;
        autoRecIdxTableIndex.addAttribute("name", "RecIdx");
        autoRecIdxTableIndex.addAttribute("id", "14");
        Element unique = GOTHelp.getPPAttElement(autoRecIdxTableIndex, "Name", "Unique");
        unique.element("Value").setText("true");
        NodeGOT tableIndexItemNode = NodeFactory.createNode("TableIndexItem", "", "");
        Element tableIndexItem = tableIndexItemNode.xml;
        tableIndexItem.addAttribute("name", AutoField_RecId);
        tableIndexItem.addAttribute("id", "25");
        Element field = GOTHelp.getPPAttElement(tableIndexItem, "Name", "Field");
        field.addAttribute("innerid", "4");
        field.element("Value").setText(AutoField_RecId);
        Element sortOrder = GOTHelp.getPPAttElement(tableIndexItem, "Name", "SortOrder");
        sortOrder.element("Value").setText("ASC");
        autoRecIdxTableIndex.add(tableIndexItem.detach());
        autoTableFieldGroupItems = new ArrayList<Element>();
        NodeGOT tableFieldGroupItemNode = NodeFactory.createNode("TableFieldGroupItem", "", "");
        Element createdDateGroupItem = tableFieldGroupItemNode.xml.createCopy();
        createdDateGroupItem.addAttribute("name", AutoField_CreateDate);
        createdDateGroupItem.addAttribute("id", "16");
        field = GOTHelp.getPPAttElement(createdDateGroupItem, "Name", "Field");
        field.addAttribute("innerid", "7");
        field.element("Value").setText(AutoField_CreateDate);
        autoTableFieldGroupItems.add(createdDateGroupItem);
        Element createdTimeGroupItem = tableFieldGroupItemNode.xml.createCopy();
        createdTimeGroupItem.addAttribute("name", AutoField_CreateDate);
        createdTimeGroupItem.addAttribute("id", "17");
        field = GOTHelp.getPPAttElement(createdTimeGroupItem, "Name", "Field");
        field.addAttribute("innerid", "8");
        field.element("Value").setText(AutoField_CreatedTime);
        autoTableFieldGroupItems.add(createdTimeGroupItem);
        Element createdByGroupItem = tableFieldGroupItemNode.xml.createCopy();
        createdByGroupItem.addAttribute("name", AutoField_CreatedBy);
        createdByGroupItem.addAttribute("id", "18");
        field = GOTHelp.getPPAttElement(createdByGroupItem, "Name", "Field");
        field.addAttribute("innerid", "9");
        field.element("Value").setText(AutoField_CreatedBy);
        autoTableFieldGroupItems.add(createdByGroupItem);
        Element modifiedDateGroupItem = tableFieldGroupItemNode.xml.createCopy();
        modifiedDateGroupItem.addAttribute("name", AutoField_ModifiedDate);
        modifiedDateGroupItem.addAttribute("id", "20");
        field = GOTHelp.getPPAttElement(modifiedDateGroupItem, "Name", "Field");
        field.addAttribute("innerid", "11");
        field.element("Value").setText(AutoField_ModifiedDate);
        autoTableFieldGroupItems.add(modifiedDateGroupItem);
        Element modifiedTimeGroupItem = tableFieldGroupItemNode.xml.createCopy();
        modifiedTimeGroupItem.addAttribute("name", AutoField_ModifiedTime);
        modifiedTimeGroupItem.addAttribute("id", "21");
        field = GOTHelp.getPPAttElement(modifiedTimeGroupItem, "Name", "Field");
        field.addAttribute("innerid", "12");
        field.element("Value").setText(AutoField_ModifiedTime);
        autoTableFieldGroupItems.add(modifiedTimeGroupItem);
        Element modifiedByGroupItem = tableFieldGroupItemNode.xml.createCopy();
        modifiedByGroupItem.addAttribute("name", AutoField_ModifiedBy);
        modifiedByGroupItem.addAttribute("id", "22");
        field = GOTHelp.getPPAttElement(modifiedByGroupItem, "Name", "Field");
        field.addAttribute("innerid", "13");
        field.element("Value").setText(AutoField_ModifiedBy);
        autoTableFieldGroupItems.add(modifiedByGroupItem);
        createdSessionId = GOTXMLHelper.initAutoElement(stringNode, "6", "20000009", "CreatedSessionId");
        modifiedSessionId = GOTXMLHelper.initAutoElement(stringNode, "10", "20000013", "ModifiedSessionId");
    }

    public static void setPropertyByQName(Element des, String desName, Element src, String srcName) {
        GOTHelp.getPPAttElement(des, "Name", desName).element("Value").setText(GOTHelp.getPPAttValue(src, "Name", srcName));
    }

    public static Boolean deleteNode(Element node) {
        if (node.attribute("version") != null) {
            return true;
        }
        if (node.getParent() == null) {
            node = null;
            return false;
        }
        Element parent = node.getParent();
        boolean b = parent.remove(node);
        GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(parent));
        return b;
    }

    public static void deletePropery(Element base, String proName) {
        Element e = GOTHelp.getPPAttElement(base, "Name", proName);
        base.element("Properties").remove(e);
    }

    public static void addPropertyUnCheck(Element base, String name, String value) {
        Element ps;
        if (base.element("Properties") != null) {
            ps = base.element("Properties");
        } else {
            base.element("Properties").setText("");
            ps = base.element("Properties");
        }
        String xml = "<Property><Name>" + name + "</Name>" + "<Value>" + value + "</Value>" + "</Property>";
        ps.add(GOTXMLHelper.createElementByXMLString(xml).detach());
    }
}

