/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.util;

import com.ximpleware.NavException;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.utils.Images;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.util.GOTUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ComposeIMG {
    public static String TABLE = "Table";
    public static String TABLEFIELD = "TableField";
    public static String TABLEFIELDGROUPITEM = "TableFieldGroupItem";
    public static String FORM = "Form";
    public static String FORMDATASOURCEFIELD = "FormDataSourceField";
    public static String DATATYPE = "DataType";
    public static String ENUM = "Enum";
    public static String MENU = "Menu";
    public static String MENUITEM = "MenuItem";
    public static String REPORTFIELD = "ReportField";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_ENUM = "Enum";
    public static final String TYPE_LONG = "Long";
    public static final String TYPE_TIME = "Time";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_DECIMAL = "Decimal";
    public static final String TYPE_COMPONENT = "Component";
    public static final String TYPE_BOOLEAN = "Boolean";
    protected static Boolean currentLayer = false;
    protected static Boolean locked = false;
    protected static Boolean invisible = false;
    protected static Boolean deprecated = false;
    protected static Boolean unsaved = false;
    protected static Boolean baseTypeImg = false;
    protected static String data_type;
    protected static String data_type_img_name;
    protected static String layer_currentLayer;
    protected static String layer_deprecated;
    protected static String layer_invisible;
    protected static String layer_locked;
    protected static String layer_unsaved;
    public static Map<String, Image> imgMap;

    static {
        layer_currentLayer = "/layer_currentLayer.png";
        layer_deprecated = "/layer_deprecated.png";
        layer_invisible = "/layer_invisible.png";
        layer_locked = "/layer_locked.png";
        layer_unsaved = "/layer_unsaved.png";
        imgMap = new HashMap<String, Image>();
    }

    public static Image drawImg(GOTNode node) {
        Image image = null;
        baseTypeImg = false;
        try {
            ComposeIMG.choiceRes(node);
        }
        catch (NavException navException) {}
        if (!(currentLayer.booleanValue() || locked.booleanValue() || invisible.booleanValue() || deprecated.booleanValue() || unsaved.booleanValue() || baseTypeImg.booleanValue())) {
            image = ComposeIMG.drawImgDef(node);
            return image;
        }
        String imgName = ComposeIMG.treeItemImgName(node);
        String mapKey = String.valueOf(locked.toString()) + invisible.toString() + currentLayer.toString() + deprecated.toString() + unsaved.toString() + imgName + node.getNodeType() + data_type_img_name;
        if (imgMap.get(mapKey) != null) {
            baseTypeImg = false;
            locked = false;
            invisible = false;
            currentLayer = false;
            deprecated = false;
            unsaved = false;
            return imgMap.get(mapKey);
        }
        InputStream inStream = Images.getIconInputStream(String.valueOf(imgName) + ".png");
        if (inStream == null) {
            return Images.getIcon("Default.png");
        }
        try {
            InputStream inputStream;
            int y;
            int x;
            BufferedImage buf_locked;
            BufferedImage buf = ImageIO.read(inStream);
            Graphics2D graphics2d = null;
            if (baseTypeImg.booleanValue() && data_type_img_name != null && !"".equals(data_type_img_name)) {
                inStream = Images.getIconInputStream(String.valueOf(data_type_img_name) + ".png");
                if (inStream == null) {
                    System.out.println(String.valueOf(data_type_img_name) + ".png");
                } else {
                    if (graphics2d == null) {
                        graphics2d = buf.createGraphics();
                    }
                    buf_locked = ImageIO.read(inStream);
                    x = buf.getWidth() - buf_locked.getWidth();
                    y = buf.getHeight() - buf_locked.getHeight();
                    graphics2d.drawImage(buf_locked, x, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
                    baseTypeImg = false;
                }
            }
            if (locked.booleanValue()) {
                if (graphics2d == null) {
                    graphics2d = buf.createGraphics();
                }
                inStream = Images.getImageInputStream(layer_locked);
                buf_locked = ImageIO.read(inStream);
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
                locked = false;
            }
            if (invisible.booleanValue()) {
                if (graphics2d == null) {
                    graphics2d = buf.createGraphics();
                }
                inStream = Images.getImageInputStream(layer_invisible);
                buf_locked = ImageIO.read(inStream);
                x = buf.getWidth() - buf_locked.getWidth();
                graphics2d.drawImage(buf_locked, x, 0, buf_locked.getWidth(), buf_locked.getHeight(), null);
                invisible = false;
            }
            if (currentLayer.booleanValue()) {
                if (graphics2d == null) {
                    graphics2d = buf.createGraphics();
                }
                inStream = Images.getImageInputStream(layer_currentLayer);
                buf_locked = ImageIO.read(inStream);
                int y2 = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, 0, y2, buf_locked.getWidth(), buf_locked.getHeight(), null);
                currentLayer = false;
            }
            if (deprecated.booleanValue()) {
                if (graphics2d == null) {
                    graphics2d = buf.createGraphics();
                }
                inStream = Images.getImageInputStream(layer_deprecated);
                buf_locked = ImageIO.read(inStream);
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x / 2, y / 2, buf_locked.getWidth(), buf_locked.getHeight(), null);
                deprecated = false;
            }
            if (unsaved.booleanValue()) {
                if (graphics2d == null) {
                    graphics2d = buf.createGraphics();
                }
                inStream = Images.getImageInputStream(layer_unsaved);
                buf_locked = ImageIO.read(inStream);
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x / 2 - 1, y / 2 - 1, buf_locked.getWidth(), buf_locked.getHeight(), null);
                unsaved = false;
            }
            if (graphics2d != null) {
                graphics2d.dispose();
            }
            if ((inputStream = ComposeIMG.bufferedImageToInputStream(buf)) != null) {
                image = ComposeIMG.getImage(inputStream);
            }
            inStream.close();
            imgMap.put(mapKey, image);
        }
        catch (IOException e) {
            Logger.getLogger(ComposeIMG.class).error((Object)"", (Throwable)e);
        }
        return image;
    }

    @Deprecated
    public static Image drawImg(Element node) {
        Image image = null;
        baseTypeImg = false;
        String imgName = ComposeIMG.treeItemImgName(node);
        ComposeIMG.choiceRes(node);
        if (!(currentLayer.booleanValue() || locked.booleanValue() || invisible.booleanValue() || deprecated.booleanValue() || unsaved.booleanValue() || baseTypeImg.booleanValue())) {
            image = ComposeIMG.drawImgDef(node);
            return image;
        }
        String mapKey = String.valueOf(locked.toString()) + invisible.toString() + currentLayer.toString() + deprecated.toString() + unsaved.toString() + imgName + node.getName() + data_type_img_name;
        if (imgMap.get(mapKey) != null) {
            baseTypeImg = false;
            locked = false;
            invisible = false;
            currentLayer = false;
            deprecated = false;
            unsaved = false;
            return imgMap.get(mapKey);
        }
        InputStream inStream = Images.getIconInputStream(String.valueOf(imgName) + ".png");
        if (inStream == null) {
            return Images.getIcon("Default.png");
        }
        try {
            InputStream inputStream;
            int y;
            int x;
            Graphics2D graphics2d;
            BufferedImage buf_locked;
            BufferedImage buf = ImageIO.read(inStream);
            if (baseTypeImg.booleanValue() && data_type_img_name != null && !"".equals(data_type_img_name)) {
                inStream = Images.getIconInputStream(String.valueOf(data_type_img_name) + ".png");
                if (inStream == null) {
                    System.out.println(String.valueOf(data_type_img_name) + ".png");
                } else {
                    buf_locked = ImageIO.read(inStream);
                    graphics2d = buf.createGraphics();
                    x = buf.getWidth() - buf_locked.getWidth();
                    y = buf.getHeight() - buf_locked.getHeight();
                    graphics2d.drawImage(buf_locked, x, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
                    graphics2d.dispose();
                    baseTypeImg = false;
                }
            }
            if (locked.booleanValue()) {
                inStream = Images.getImageInputStream(layer_locked);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x, y, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                locked = false;
            }
            if (invisible.booleanValue()) {
                inStream = Images.getImageInputStream(layer_invisible);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                x = buf.getWidth() - buf_locked.getWidth();
                graphics2d.drawImage(buf_locked, x, 0, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                invisible = false;
            }
            if (currentLayer.booleanValue()) {
                inStream = Images.getImageInputStream(layer_currentLayer);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                int y2 = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, 0, y2, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                currentLayer = false;
            }
            if (deprecated.booleanValue()) {
                inStream = Images.getImageInputStream(layer_deprecated);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x / 2, y / 2, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                deprecated = false;
            }
            if (unsaved.booleanValue()) {
                inStream = Images.getImageInputStream(layer_unsaved);
                buf_locked = ImageIO.read(inStream);
                graphics2d = buf.createGraphics();
                x = buf.getWidth() - buf_locked.getWidth();
                y = buf.getHeight() - buf_locked.getHeight();
                graphics2d.drawImage(buf_locked, x / 2 - 1, y / 2 - 1, buf_locked.getWidth(), buf_locked.getHeight(), null);
                graphics2d.dispose();
                unsaved = false;
            }
            if ((inputStream = ComposeIMG.bufferedImageToInputStream(buf)) != null) {
                image = ComposeIMG.getImage(inputStream);
            }
            inStream.close();
            imgMap.put(mapKey, image);
        }
        catch (IOException e) {
            Logger.getLogger(ComposeIMG.class).error((Object)"", (Throwable)e);
        }
        return image;
    }

    public static Image drawImgDef(Element node) {
        Image image = null;
        String imgName = ComposeIMG.treeItemImgName(node);
        if ("".equals(imgName)) {
            return image;
        }
        if (imgMap.containsKey(imgName)) {
            return imgMap.get(imgName);
        }
        image = Images.getIcon(String.valueOf(imgName) + ".png");
        imgMap.put(imgName, image);
        return image;
    }

    public static Image drawImgDef(String imgName) {
        Image image = null;
        if ("".equals(imgName) || imgName.startsWith("Node_")) {
            imgName = "Default";
        }
        if (imgMap.containsKey(imgName)) {
            return imgMap.get(imgName);
        }
        image = Images.getIcon(String.valueOf(imgName) + ".png");
        if (image == null) {
            image = Images.getIcon("Default.png");
        }
        imgMap.put(imgName, image);
        return image;
    }

    public static Image drawImgDef(gongqi.gdt.designer.service.node.GOTNode gotNode) {
        Image image = null;
        String imgName = ComposeIMG.treeItemImgName(gotNode);
        if ("".equals(imgName)) {
            return image;
        }
        if (imgMap.containsKey(imgName)) {
            return imgMap.get(imgName);
        }
        image = Images.getIcon(String.valueOf(imgName) + ".png");
        imgMap.put(imgName, image);
        return image;
    }

    private static String treeItemImgName(gongqi.gdt.designer.service.node.GOTNode node) {
        String name = node.getNodeType();
        String imgName = "";
        if (!"".endsWith(name) && name != null) {
            String type;
            imgName = name;
            if (!(name.equals(DATATYPE) || name.equals(TABLEFIELD) || name.equals(FORMDATASOURCEFIELD) || name.equals(REPORTFIELD) || !StringUtils.isNotBlank((String)(type = node.getAttributeValue("type"))) || name.equals(TABLEFIELDGROUPITEM))) {
                imgName = String.valueOf(imgName) + type.replace("Editor", "");
                return imgName;
            }
            if (GOTUtil.imgNames.contains(String.valueOf(imgName) + ".png")) {
                return imgName;
            }
        }
        return imgName;
    }

    private static String treeItemImgName(Element node) {
        Attribute attribute;
        String name = node.getName();
        String imgName = "";
        if (!"".endsWith(name) && name != null) {
            imgName = name;
            if (!(name.equals(DATATYPE) || name.equals(TABLEFIELD) || name.equals(FORMDATASOURCEFIELD) || name.equals(REPORTFIELD) || (attribute = node.attribute("type")) == null || name.equals(TABLEFIELDGROUPITEM))) {
                imgName = String.valueOf(imgName) + attribute.getText().replace("Editor", "");
                return imgName;
            }
            if (GOTUtil.imgNames.contains(String.valueOf(imgName) + ".png")) {
                return imgName;
            }
        }
        imgName = (attribute = node.attribute("saved")) != null && "0".equals(attribute.getText()) ? "DefaultUnsaved" : "Default";
        return imgName;
    }

    private static void choiceRes(GOTNode node) throws NavException {
        block35: {
            String nodeName;
            data_type_img_name = "";
            if (node.hasAttribute("nextInnerId")) {
                if (node.hasAttribute("createdLayer") && node.getCreatedLayer().equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
                    currentLayer = true;
                }
                if (node.hasAttribute("locked") && node.getAttributeValue("locked").equals("true")) {
                    locked = true;
                }
                if (node.hasAttribute("visible") && node.getAttributeValue("visible").equals("false")) {
                    invisible = true;
                }
                if (node.hasAttribute("deprecated") && node.getAttributeValue("deprecated").equals("true")) {
                    deprecated = true;
                }
                if (node.hasAttribute("saved") && node.getAttributeValue("saved").equals("0")) {
                    unsaved = true;
                }
            }
            if (node.hasAttribute("id") && node.getAttributeValue("createdLayer").equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
                currentLayer = true;
            }
            if (!(nodeName = node.getNodeType()).equals(DATATYPE) && !nodeName.equals(TABLEFIELD) && !nodeName.equals(FORMDATASOURCEFIELD) && !nodeName.equals(REPORTFIELD) || !node.hasAttribute("type")) break block35;
            switch (node.getAttributeValue("type")) {
                case "Boolean": {
                    data_type_img_name = unsaved == false ? "BooleanType" : "BooleanTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Component": {
                    data_type_img_name = unsaved == false ? "ComponentType" : "ComponentTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Date": {
                    data_type_img_name = unsaved == false ? "DateType" : "DateTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Decimal": {
                    data_type_img_name = unsaved == false ? "DecimalType" : "DecimalTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Enum": {
                    data_type_img_name = unsaved == false ? "EnumType" : "EnumTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Long": {
                    data_type_img_name = unsaved == false ? "LongType" : "LongTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "String": {
                    data_type_img_name = unsaved == false ? "StringType" : "StringTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Time": {
                    data_type_img_name = unsaved == false ? "TimeType" : "TimeTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
            }
        }
    }

    @Deprecated
    private static void choiceRes(Element node) {
        block35: {
            String nodeName;
            data_type_img_name = "";
            Attribute attribute = node.attribute("nextInnerId");
            if (attribute != null) {
                attribute = node.attribute("createdLayer");
                if (attribute != null && attribute.getText().equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
                    currentLayer = true;
                }
                if ((attribute = node.attribute("locked")) != null && attribute.getText().equals("true")) {
                    locked = true;
                }
                if ((attribute = node.attribute("visible")) != null && attribute.getText().equals("false")) {
                    invisible = true;
                }
                if ((attribute = node.attribute("deprecated")) != null && attribute.getText().equals("true")) {
                    deprecated = true;
                }
                if ((attribute = node.attribute("saved")) != null && attribute.getText().equals("0")) {
                    unsaved = true;
                }
            }
            if ((attribute = node.attribute("id")) != null && (attribute = node.attribute("createdLayer")).getText().equals(((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer())) {
                currentLayer = true;
            }
            if (!(nodeName = node.getName()).equals(DATATYPE) && !nodeName.equals(TABLEFIELD) && !nodeName.equals(FORMDATASOURCEFIELD) && !nodeName.equals(REPORTFIELD) || (attribute = node.attribute("type")) == null) break block35;
            switch (attribute.getText()) {
                case "Boolean": {
                    data_type_img_name = unsaved == false ? "BooleanType" : "BooleanTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Component": {
                    data_type_img_name = unsaved == false ? "ComponentType" : "ComponentTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Date": {
                    data_type_img_name = unsaved == false ? "DateType" : "DateTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Decimal": {
                    data_type_img_name = unsaved == false ? "DecimalType" : "DecimalTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Enum": {
                    data_type_img_name = unsaved == false ? "EnumType" : "EnumTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Long": {
                    data_type_img_name = unsaved == false ? "LongType" : "LongTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "String": {
                    data_type_img_name = unsaved == false ? "StringType" : "StringTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
                case "Time": {
                    data_type_img_name = unsaved == false ? "TimeType" : "TimeTypeUnSaved";
                    baseTypeImg = true;
                    break;
                }
            }
        }
    }

    private static InputStream bufferedImageToInputStream(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", os);
        ByteArrayInputStream input = new ByteArrayInputStream(os.toByteArray());
        os.close();
        return input;
    }

    private static Image getImage(InputStream stream) throws IOException {
        try {
            Display display = Display.getCurrent();
            ImageData data = new ImageData(stream);
            if (data.transparentPixel > 0) {
                Image image = new Image((Device)display, data, data.getTransparencyMask());
                return image;
            }
            Image image = new Image((Device)display, data);
            return image;
        }
        finally {
            stream.close();
        }
    }

    public static Image drawImgDef(GOTNode entityNode) {
        Image image = null;
        String imgName = ComposeIMG.treeItemImgName(entityNode);
        if ("".equals(imgName)) {
            return image;
        }
        if (imgMap.containsKey(imgName)) {
            return imgMap.get(imgName);
        }
        image = Images.getIcon(String.valueOf(imgName) + ".png");
        imgMap.put(imgName, image);
        return image;
    }

    private static String treeItemImgName(GOTNode entityNode) {
        String name = entityNode.getNodeType();
        String imgName = "";
        if (!"".endsWith(name) && name != null) {
            imgName = name;
            if (!(name.equals(DATATYPE) || name.equals(TABLEFIELD) || name.equals(FORMDATASOURCEFIELD) || name.equals(REPORTFIELD))) {
                try {
                    if (entityNode.hasAttribute("type") && !name.equals(TABLEFIELDGROUPITEM)) {
                        imgName = String.valueOf(imgName) + entityNode.getAttributeValue("type").replace("Editor", "");
                        return imgName;
                    }
                }
                catch (NavException navException) {}
            }
            if (GOTUtil.imgNames.contains(String.valueOf(imgName) + ".png")) {
                return imgName;
            }
        }
        imgName = GotXmlDto.getInstance().ifInUnsaveMap(entityNode.getEntity().getId()) ? "DefaultUnsaved" : "Default";
        return imgName;
    }
}

