/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.designer.got.vtd.GOTNode;
import gongqi.gdt.designer.utils.cache.GOTFinalValueHelper;
import info.gongqi.got.tool.GOTHelp;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TreeChineseLabel {
    public static String getStringLength(String s) {
        int length = 0;
        String chinese = "[\u4e00-\u9fa5]";
        int i = 0;
        while (i < s.length()) {
            String temp = s.substring(i, i + 1);
            length = temp.matches(chinese) || temp.matches("[A-Z]") || temp.contains(".") ? (length += 2) : ++length;
            if (length > 12) {
                s = s.substring(0, i);
                s = String.valueOf(s) + "...";
                break;
            }
            ++i;
        }
        return s;
    }

    public static String commitProperties(GOTNode data) {
        String chineseLabel = "";
        if (data != null) {
            String elName = data.getNodeType();
            String property = "Label";
            String flabel = "";
            try {
                if (elName.equals("FormDataSource")) {
                    flabel = GOTHelp.getFormDataSourceLabel(data);
                } else if (elName.equals("TableIndexItem")) {
                    flabel = GOTHelp.getTableIndexItemLabel(data);
                } else {
                    if (elName.equals("Form")) {
                        property = "Title";
                    }
                    flabel = GOTFinalValueHelper.getFinalValue(data, property);
                }
            }
            catch (Exception e) {
                Logger.getLogger(TreeChineseLabel.class).error((Object)e);
            }
            if (StringUtils.isNotBlank((String)flabel)) {
                chineseLabel = "\u3010" + flabel + "\u3011";
            }
        }
        return chineseLabel;
    }
}

