/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.erp.gotmodel.core.EntityType;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class MergeSaveAll
extends Dialog {
    protected Object resultDialog = "";
    protected Shell shell;
    public ProgressBar progressBar;
    private Boolean canceled = false;
    private List<EntityNode> xmllist = new ArrayList<EntityNode>();

    public MergeSaveAll(Shell parent, int style) {
        super(parent, style);
        this.setText("\u6b63\u5728\u9a8c\u8bc1");
    }

    public Object open(String action) {
        this.createContents(action);
        if (!this.canceled.booleanValue()) {
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.resultDialog;
    }

    private void createContents(String action) {
        if ("all".equals(action)) {
            this.xmllist = GotXmlDto.getInstance().getUnsaveEntitys();
        } else if ("Form".equals(action)) {
            this.xmllist = GotXmlDto.getInstance().getEntityList(EntityType.Form);
        }
        if (this.xmllist == null || this.xmllist.isEmpty()) {
            this.canceled = true;
            return;
        }
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MergeSaveAll.this.canceled = true;
            }
        });
        this.shell.setSize(600, 50);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.progressBar = new ProgressBar((Composite)this.shell, 65536);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        this.start(0, this.xmllist.size(), true);
    }

    public void start(final int i, final int total, final Boolean merge) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MergeSaveAll.this.saveAllUnsavedNode(i, total, merge);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).MergeSaveAll.this.shell.isDisposed()) {
                            return;
                        }
                        (this).MergeSaveAll.this.shell.dispose();
                    }
                });
            }
        };
        new Thread(runnable).start();
    }

    public void saveAllUnsavedNode(int i, int total, Boolean merge) {
        if (this.canceled.booleanValue()) {
            this.canceled = false;
            return;
        }
        if (i == 0) {
            this.setProgressBar(0);
        }
        if (i >= total) {
            if (this.canceled.booleanValue()) {
                this.canceled = false;
            }
            return;
        }
        final EntityNode nodeSaving = this.xmllist.get(i);
        int percent = (i + 1) * 100 / total;
        this.setShellText("\u6b63\u5728\u4fdd\u5b58" + nodeSaving.getName() + " " + percent + "%");
        this.setProgressBar(percent);
        Element entityElement = nodeSaving.toElement();
        if ("0".equals(entityElement.attributeValue("saved"))) {
            entityElement.remove(entityElement.attribute("saved"));
        }
        if (merge.booleanValue()) {
            try {
                LoadXmlCore.gotServices.updateEntityAlone(entityElement.asXML());
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e);
                GOTMessageDialog.alert(e);
            }
        } else {
            try {
                LoadXmlCore.gotServices.saveEntity(entityElement.asXML());
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e);
                GOTMessageDialog.alert(e);
            }
        }
        if (GotXmlDto.getInstance().ifInUnsaveMap(nodeSaving.getId())) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    TreeItem treeItem = FormDataSyn.getTreeItrmByNode((GOTNode)nodeSaving, null);
                    GotXmlDto.getInstance().saveEntity(nodeSaving.getId());
                    if (treeItem != null) {
                        FormDataSyn.setSaved(treeItem);
                    }
                }
            });
        }
        this.saveAllUnsavedNode(i + 1, total, true);
    }

    public void setProgressBar(final int num) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeSaveAll.this.progressBar.isDisposed()) {
                    return;
                }
                MergeSaveAll.this.progressBar.setSelection(num);
            }
        });
    }

    public void setShellText(final String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeSaveAll.this.shell.isDisposed()) {
                    return;
                }
                MergeSaveAll.this.shell.setText(text);
            }
        });
    }

    public void setAlert(final String text, final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GOTMessageDialog.showXmlInfo(text, title);
            }
        });
    }
}

