/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import com.ximpleware.VTDException;
import gongqi.designer.core.DesignerServer;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.core.got.node.NodeFactory;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.got.node.NodeNameInvalidException;
import gongqi.gdt.designer.core.toolsgot.Macros;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.util.ComposeIMG;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.NumCore;
import info.gongqi.got.util.TreeUIUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FormDataSyn {
    public static List<TreeUi> treeUis = new ArrayList<TreeUi>();
    public static TreeUi dragTreeUi;
    public static TreeItem current;
    public static TreeUi currentTreeUi;
    private static Font font_bold;

    public static void actionCopySyn(TreeItem baseCopyItem, final Element elementNode, final int index, final boolean old) {
        try {
            final String id = baseCopyItem.getData("id").toString();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < treeUis.size()) {
                        TreeUi treeUi = treeUis.get(i);
                        TreeItem copyItem = treeUi.itemsMap.get(id);
                        if (copyItem != null) {
                            TreeItem parentTreeItem = copyItem.getParentItem();
                            TreeItem addNewTreeItem = null;
                            addNewTreeItem = parentTreeItem != null ? FormDataSyn.bulidTree(elementNode, parentTreeItem, index, treeUi, parentTreeItem.getExpanded()) : FormDataSyn.bulidTree(elementNode, copyItem.getParent(), index, treeUi, true);
                            GOTNode gotNode = TreeUIUtil.getCurrentElement2(addNewTreeItem);
                            if (copyItem.getParent().equals(treeUi.getTree()) && old) {
                                treeUi.getTree().setSelection(addNewTreeItem);
                                treeUi.loadTableValue(treeUi.getTable(), gotNode, addNewTreeItem);
                                NodeGOT node = NodeFactory.getNode(elementNode);
                                if ("true".equals(node.allowEdit())) {
                                    FormDataSyn.treeItemEditor(addNewTreeItem, node, true, treeUi);
                                }
                            }
                            treeUi.updateEntitySaveStyle(gotNode);
                        }
                        ++i;
                    }
                }
            });
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void actionSyn(final TreeItem currentTreeItem, final Element elementNode, final Integer index, final boolean old) {
        try {
            final String id = currentTreeItem.getData("id").toString();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < treeUis.size()) {
                        TreeUi treeUi = treeUis.get(i);
                        TreeItem parentTreeItem = treeUi.itemsMap.get(id);
                        if (parentTreeItem != null) {
                            TreeItem addNewTreeItem = FormDataSyn.bulidTree(elementNode, parentTreeItem, index, treeUi, parentTreeItem.getExpanded());
                            GOTNode gotNode = TreeUIUtil.getCurrentElement2(addNewTreeItem);
                            if (currentTreeItem.getParent().equals(treeUi.getTree()) && old) {
                                treeUi.getTree().setSelection(addNewTreeItem);
                                treeUi.loadTableValue(treeUi.getTable(), gotNode, addNewTreeItem);
                                NodeGOT node = NodeFactory.getNode(elementNode);
                                if ("true".equals(node.allowEdit())) {
                                    FormDataSyn.treeItemEditor(addNewTreeItem, node, true, treeUi);
                                }
                            }
                            treeUi.updateEntitySaveStyle(gotNode);
                        }
                        ++i;
                    }
                }
            });
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void deleteTreeItem(TreeItem trtmNewTreeitem, boolean updateSelect) {
        try {
            String id = (String)trtmNewTreeitem.getData("id");
            for (TreeUi treeUi : treeUis) {
                TreeItem item = treeUi.itemsMap.get(id);
                if (item == null) continue;
                TreeItem parent = item.getParentItem();
                if (parent != null && updateSelect && !parent.isDisposed() && !trtmNewTreeitem.isDisposed() && parent != null && trtmNewTreeitem.getParent() == treeUi.getTree()) {
                    GOTNode element;
                    TreeItem select;
                    int index = parent.indexOf(item);
                    if (index == 0) {
                        if (parent.getItemCount() == 1) {
                            treeUi.getTree().setSelection(parent);
                            GOTNode element2 = TreeUIUtil.getCurrentElement2(parent);
                            treeUi.loadTableValue(treeUi.getTable(), element2, parent);
                        } else {
                            select = parent.getItem(index + 1);
                            treeUi.getTree().setSelection(select);
                            element = TreeUIUtil.getCurrentElement2(select);
                            if (element != null) {
                                treeUi.loadTableValue(treeUi.getTable(), element, select);
                            }
                        }
                    } else {
                        select = parent.getItem(index - 1);
                        treeUi.getTree().setSelection(select);
                        element = TreeUIUtil.getCurrentElement2(select);
                        treeUi.loadTableValue(treeUi.getTable(), element, select);
                    }
                }
                treeUi.itemsMap.remove(id);
                FormDataSyn.deleteChild(item, treeUi);
                item.removeAll();
                item.dispose();
                if (parent == null || !parent.getText().equals("Menus")) continue;
                FormDataSyn.sendList(parent);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void deleteOneTreeItem(TreeItem trtmNewTreeitem) {
        try {
            String id = (String)trtmNewTreeitem.getData("id");
            for (TreeUi treeUi : treeUis) {
                TreeItem item = treeUi.itemsMap.get(id);
                if (item == null) continue;
                treeUi.itemsMap.remove(id);
                item.removeAll();
                item.dispose();
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)"", (Throwable)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    private static void deleteChild(TreeItem item, TreeUi treeUi) {
        try {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = item.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                String id = (String)treeItem.getData("id");
                treeUi.itemsMap.remove(id);
                FormDataSyn.deleteChild(treeItem, treeUi);
                ++n2;
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void textSyn(TreeItem trtmNewTreeitem) {
        try {
            String id = (String)trtmNewTreeitem.getData("id");
            GOTNode element = TreeUIUtil.getCurrentElement2(trtmNewTreeitem);
            for (TreeUi treeUi : treeUis) {
                TreeItem item = FormDataSyn.getTreeItrmEntityById(treeUi, id);
                if (item == null) continue;
                String text = LoadXML.nodeText(element);
                item.setText(text);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void treeItemEditor(final TreeItem treeitem, final NodeGOT node, boolean edit, final TreeUi ui) {
        try {
            if (treeitem.isDisposed()) {
                return;
            }
            final TreeEditor editor = new TreeEditor(treeitem.getParent());
            Control oldEditor = editor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
            final String oldText = treeitem.getText();
            final Text changeItemText = new Text((Composite)treeitem.getParent(), 2048);
            changeItemText.setFont(treeitem.getFont());
            if (ConfigComposite.configComposite.DPIZOOM.compareTo(BigDecimal.ONE) > 0) {
                Font fonts = changeItemText.getFont();
                FontData data = fonts.getFontData()[0];
                data.height -= 1.0f;
                fonts = new Font((Device)changeItemText.getDisplay(), data);
                changeItemText.setFont(fonts);
            }
            changeItemText.computeSize(treeitem.getParent().getBorderWidth(), treeitem.getParent().getItemHeight());
            editor.grabHorizontal = true;
            editor.minimumHeight = changeItemText.getSize().y;
            editor.minimumWidth = changeItemText.getSize().x;
            editor.setEditor((Control)changeItemText, treeitem);
            final String editText = FormDataSyn.editText(oldText);
            changeItemText.setText(editText);
            changeItemText.setEditable(edit);
            changeItemText.forceFocus();
            changeItemText.selectAll();
            changeItemText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusevent) {
                    try {
                        Control defaultEditor = editor.getEditor();
                        editor.setEditor(defaultEditor, treeitem);
                        if (!changeItemText.getText().trim().equals(editText.trim())) {
                            FormDataSyn.afterModifyTreeItem(treeitem, node, ui, changeItemText, oldText);
                        }
                    }
                    finally {
                        changeItemText.dispose();
                    }
                }
            });
            changeItemText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13) {
                        try {
                            Control defaultEditor = editor.getEditor();
                            editor.setEditor(defaultEditor, treeitem);
                            if (!changeItemText.getText().trim().equals(editText.trim())) {
                                FormDataSyn.afterModifyTreeItem(treeitem, node, ui, changeItemText, oldText);
                            }
                        }
                        finally {
                            changeItemText.dispose();
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    private static void afterModifyTreeItem(TreeItem treeitem, NodeGOT node, TreeUi ui, Text changeItemText, String oldText) {
        try {
            String elementId;
            if (node == null || node.xml == null) {
                return;
            }
            if (node.xml.getName().equals("Forms")) {
                Element eleForm = node.xml.element("Form");
                node = NodeFactory.getNode(eleForm);
            }
            String newElementName = StringUtils.isNotBlank((String)(elementId = node.xml.attributeValue("id"))) && elementId.contains(".") ? String.valueOf(elementId.substring(0, elementId.lastIndexOf("."))) + "." + changeItemText.getText() : changeItemText.getText();
            if (oldText.contains("::") && oldText.substring(oldText.indexOf("::") + 2).equals(newElementName) || oldText.equals(newElementName)) {
                return;
            }
            if (node.validateNewName(newElementName).booleanValue()) {
                GOTNode tableIndexes;
                List selectNodes;
                int n;
                Element componentPro;
                GOTNode data;
                node.xml.addAttribute("name", newElementName);
                if (oldText.contains("::")) {
                    oldText = oldText.split("::")[1];
                }
                node.doAfterNameModified(oldText);
                Element entity = NodeGOT.getEntity(node.xml);
                if (entity != null) {
                    GotXmlDto.getInstance().updateEntityElement(entity);
                }
                if ((data = TreeUIUtil.getCurrentElement2(treeitem)).getNodeType().equals("FormItem")) {
                    String result = String.valueOf(data.getAttributeValue("type")) + "::" + changeItemText.getText();
                    changeItemText.setText(result);
                }
                treeitem.setData("chinese", (Object)"false");
                ui.loadTableValue(ui.getTable(), data, treeitem);
                if ("FieldGroup".equals(node.xml.attributeValue("type")) && (componentPro = GOTHelper.getProperty((Element)node.xml, (String)"Component")).attribute("refentityid") != null) {
                    TreeItem[] items;
                    TreeItem[] treeItemArray = items = treeitem.getItems();
                    int n2 = items.length;
                    n = 0;
                    while (n < n2) {
                        TreeItem child = treeItemArray[n];
                        FormDataSyn.textSyn(child);
                        ++n;
                    }
                }
                if (data.getNodeType().equals("FormDataSource")) {
                    TreeItem[] dataSources;
                    TreeItem[] treeItemArray = dataSources = treeitem.getParentItem().getItems();
                    n = dataSources.length;
                    int child = 0;
                    while (child < n) {
                        TreeItem[] dataSourceItems;
                        TreeItem dataSource = treeItemArray[child];
                        TreeItem[] treeItemArray2 = dataSourceItems = dataSource.getItems();
                        int n3 = dataSourceItems.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TreeItem dataSourceItem = treeItemArray2[n4];
                            if ("Relation".equals(dataSourceItem.getText())) {
                                TreeItem[] treeItemArray3 = dataSourceItem.getItems();
                                int n5 = treeItemArray3.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    TreeItem relation = treeItemArray3[n6];
                                    FormDataSyn.textSyn(relation);
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                        ++child;
                    }
                }
                if (data.getNodeType().equals("TableField") && !(selectNodes = (tableIndexes = data.getEntity().selectSingleNode("./TableIndexes")).selectNodes(String.format("./TableIndex/TableIndexItem/Properties/Property[@innerid='%s']", data.getId()))).isEmpty()) {
                    TreeItem treeItem = FormDataSyn.getTreeItrmByNode(tableIndexes, null);
                    FormDataSyn.restore(treeItem, tableIndexes);
                }
                FormDataSyn.textSyn(treeitem);
                FormDataSyn.updateEntitySaveStyle(treeitem);
            } else {
                TreeOperationInfo.addErrorInfo(Macros.ERROR_VALUE_UNLAWFUL);
                ConfigComposite.configComposite.set_text_op_info(Macros.ERROR_VALUE_UNLAWFUL);
            }
        }
        catch (NodeNameInvalidException e) {
            TreeOperationInfo.addErrorInfo(e.getMessage());
            ConfigComposite.configComposite.set_text_op_info(e.getMessage());
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)"", (Throwable)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void updateEntitySaveStyle(TreeItem treeitem) {
        TreeItem enityItem = FormDataSyn.getEntityTreeItem(treeitem);
        if (enityItem == null) {
            return;
        }
        GOTNode gotNode = TreeUIUtil.getCurrentElement2(enityItem);
        for (TreeUi treeUi : treeUis) {
            treeUi.updateEntitySaveStyle(gotNode);
        }
    }

    private static TreeItem bulidTree(Element gotNode, TreeItem parentTree, Integer index, TreeUi treeUi, boolean expended) {
        TreeItem trtmNewTreeitem = null;
        String elName = gotNode.getName();
        if ("Table".equals(elName) || "Form".equals(elName) || "MenuItem".equals(elName) || "Enum".equals(elName)) {
            index = 0;
        }
        trtmNewTreeitem = index != null ? new TreeItem(parentTree, 0, index.intValue()) : new TreeItem(parentTree, 0);
        FormDataSyn.initTreeItem(gotNode, trtmNewTreeitem, treeUi);
        if (gotNode.getName().equals("Menu")) {
            FormDataSyn.sendList(trtmNewTreeitem.getParentItem());
        }
        List childNodes = gotNode.elements();
        for (Element childNode : childNodes) {
            if (!LoadXML.nodeShowRule(childNode)) continue;
            FormDataSyn.bulidTree(childNode, trtmNewTreeitem, null, treeUi, false);
        }
        parentTree.setExpanded(expended);
        return trtmNewTreeitem;
    }

    private static TreeItem bulidTree(Element gotNode, Tree parentTree, Integer index, TreeUi treeUi, boolean expended) {
        TreeItem trtmNewTreeitem = null;
        String elName = gotNode.getName();
        if ("Table".equals(elName) || "Form".equals(elName) || "MenuItem".equals(elName) || "Enum".equals(elName)) {
            index = 0;
        }
        trtmNewTreeitem = index != null ? new TreeItem(parentTree, 0, index.intValue()) : new TreeItem(parentTree, 0);
        FormDataSyn.initTreeItem(gotNode, trtmNewTreeitem, treeUi);
        List childNodes = gotNode.elements();
        for (Element childNode : childNodes) {
            if (!LoadXML.nodeShowRule(childNode)) continue;
            FormDataSyn.bulidTree(childNode, trtmNewTreeitem, null, treeUi, false);
        }
        if (gotNode.getName().equals("Menu")) {
            FormDataSyn.sendList(trtmNewTreeitem.getParentItem());
        }
        return trtmNewTreeitem;
    }

    private static void initTreeItem(Element gotNode, TreeItem treeItem, TreeUi treeUi) {
        Element entity = NodeGOT.getEntity(gotNode);
        String text = LoadXML.nodeText(gotNode);
        if ("".equals(text)) {
            text = gotNode.getName();
        }
        treeItem.setData("elementName", (Object)gotNode.getName());
        if (StringUtils.isNotBlank((String)gotNode.attributeValue("id"))) {
            treeItem.setData("elementId", (Object)gotNode.attributeValue("id"));
        }
        if (entity != null) {
            treeItem.setData("elementEntityId", (Object)entity.attributeValue("id"));
        }
        treeItem.setData("chinese", (Object)"false");
        treeItem.setText(text);
        FormDataSyn.setFont(gotNode, treeItem);
        treeItem.setImage(ComposeIMG.drawImg(gotNode));
        String treeItemId = NumCore.getTreeItemId(entity, gotNode);
        treeItem.setData("id", (Object)treeItemId);
        treeUi.itemsMap.put(treeItemId, treeItem);
    }

    @Deprecated
    public static void setUnSave(TreeItem trtmNewTreeitem) {
        try {
            if (trtmNewTreeitem != null) {
                Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
                Element entity = NodeGOT.getEntity(element);
                while (element != null) {
                    if (entity.attribute("saved") == null) {
                        entity.addAttribute("saved", "0");
                    }
                    if ("0".equals(element.attributeValue("saved"))) {
                        trtmNewTreeitem.setForeground(trtmNewTreeitem.getDisplay().getSystemColor(3));
                        trtmNewTreeitem.setImage(ComposeIMG.drawImg(element));
                        GotXmlDto.getInstance().updateEntityElement(entity);
                        ConfigComposite.configComposite.setUnsavedText();
                        return;
                    }
                    element = element.getParent();
                    trtmNewTreeitem = trtmNewTreeitem.getParentItem();
                }
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void setSaved(TreeItem trtmNewTreeitem) {
        try {
            if (trtmNewTreeitem == null) {
                return;
            }
            GOTNode gotNode = TreeUIUtil.getCurrentElement2(trtmNewTreeitem);
            if (gotNode == null) {
                return;
            }
            EntityNode entity = gotNode.getEntity();
            String treeItemId = NumCore.getTreeItemId((GOTNode)entity);
            for (TreeUi treeUi : treeUis) {
                TreeItem item = treeUi.itemsMap.get(treeItemId);
                if (item == null) continue;
                treeUi.restoreNode(item, (GOTNode)entity, false, null);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void restore(TreeItem trtmNewTreeitem, GOTNode gotNode) {
        try {
            String id = (String)trtmNewTreeitem.getData("id");
            if (gotNode == null) {
                gotNode = TreeUIUtil.getCurrentElement2(trtmNewTreeitem);
            }
            int i = 0;
            while (i < treeUis.size()) {
                trtmNewTreeitem = FormDataSyn.treeUis.get((int)i).itemsMap.get(id);
                if (trtmNewTreeitem != null) {
                    treeUis.get(i).cleanMaps(trtmNewTreeitem);
                    List<String> expandTreeItemIds = FormDataSyn.getExpandTreeItemIds(trtmNewTreeitem);
                    treeUis.get(i).restoreNode(trtmNewTreeitem, gotNode, true, expandTreeItemIds);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)"", (Throwable)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    private static List<String> getExpandTreeItemIds(TreeItem treeItem) {
        ArrayList<String> ids = new ArrayList<String>();
        if (treeItem.getExpanded()) {
            ids.add(treeItem.getData("id").toString());
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            ids.addAll(FormDataSyn.getExpandTreeItemIds(childItem));
            ++n2;
        }
        return ids;
    }

    public static void restore2(TreeItem trtmNewTreeitem, Element gotNode) {
        try {
            String id = (String)trtmNewTreeitem.getData("id");
            if (gotNode == null) {
                return;
            }
            int i = 0;
            while (i < treeUis.size()) {
                trtmNewTreeitem = FormDataSyn.treeUis.get((int)i).itemsMap.get(id);
                if (trtmNewTreeitem != null) {
                    treeUis.get(i).cleanMaps(trtmNewTreeitem);
                    List<String> expandTreeItemIds = FormDataSyn.getExpandTreeItemIds(trtmNewTreeitem);
                    treeUis.get(i).restoreNode(trtmNewTreeitem, gotNode, true, expandTreeItemIds);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)"", (Throwable)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void restoreSyn(TreeItem baseItem, TreeItem tarItem, TreeUi ui) {
        try {
            tarItem.setData("id", (Object)baseItem.getData("id").toString());
            if (TreeUIUtil.isUINode(baseItem.getText())) {
                tarItem.setData("elementName", baseItem.getData("elementName"));
                tarItem.setText(baseItem.getText());
                FormDataSyn.restoreSynItems_Part(baseItem, tarItem, ui);
                tarItem.setData("items", (Object)"all");
            } else {
                String label;
                GOTNode element = TreeUIUtil.getCurrentElement2(baseItem);
                tarItem.setText(LoadXML.nodeText(element));
                tarItem.setData("elementName", (Object)element.getNodeType());
                if (StringUtils.isNotBlank((String)element.getId())) {
                    tarItem.setData("elementId", (Object)element.getId());
                }
                if (element.getEntity() != null) {
                    tarItem.setData("elementEntityId", (Object)element.getEntity().getId());
                }
                if (StringUtils.isBlank((String)(label = (String)baseItem.getData("label")))) {
                    tarItem.setData("chinese", (Object)"false");
                    ui.setChineseLabel(tarItem, false);
                } else {
                    tarItem.setData("label", (Object)label);
                }
                FormDataSyn.restoreSynItems(baseItem, tarItem, ui, element);
                tarItem.setData("items", (Object)"part");
            }
            tarItem.setFont(baseItem.getFont());
            tarItem.setImage(baseItem.getImage());
            tarItem.setBackground(baseItem.getBackground());
            tarItem.setForeground(baseItem.getForeground());
            tarItem.setExpanded(true);
            ui.itemsMap.put(baseItem.getData("id").toString(), tarItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    private static void restoreSynItems_Part(TreeItem baseItem, TreeItem tarItem, TreeUi ui) {
        try {
            TreeItem[] baseItems;
            TreeItem[] treeItemArray = baseItems = baseItem.getItems();
            int n = baseItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                String id = child.getData("id").toString();
                TreeItem trtmNewTreeitem = new TreeItem(tarItem, 0);
                trtmNewTreeitem.setData("id", (Object)id);
                if (TreeUIUtil.isUINode(child.getText())) {
                    trtmNewTreeitem.setText(child.getText());
                    trtmNewTreeitem.setData("elementName", child.getData("elementName"));
                    FormDataSyn.restoreSynItems_Part(child, trtmNewTreeitem, ui);
                    trtmNewTreeitem.setData("items", (Object)"all");
                } else {
                    String label;
                    EntityNode entity;
                    GOTNode element = TreeUIUtil.getCurrentElement2(child);
                    trtmNewTreeitem.setText(LoadXML.nodeText(element));
                    trtmNewTreeitem.setData("elementName", (Object)element.getNodeType());
                    if (StringUtils.isNotBlank((String)element.getId())) {
                        trtmNewTreeitem.setData("elementId", (Object)element.getId());
                    }
                    if ((entity = element.getEntity()) != null) {
                        trtmNewTreeitem.setData("elementEntityId", (Object)entity.getId());
                    }
                    if (StringUtils.isBlank((String)(label = (String)child.getData("label")))) {
                        trtmNewTreeitem.setData("chinese", (Object)"false");
                        ui.setChineseLabel(trtmNewTreeitem, false);
                    } else {
                        trtmNewTreeitem.setData("label", (Object)label);
                    }
                    TreeItem[] baseItemChild = child.getItems();
                    if (baseItemChild.length > 0) {
                        TreeItem trtmNewTreeitem2 = new TreeItem(trtmNewTreeitem, 0);
                        trtmNewTreeitem2.setText("loading...");
                        trtmNewTreeitem2.setData("items", (Object)"part");
                    }
                }
                trtmNewTreeitem.setFont(child.getFont());
                trtmNewTreeitem.setImage(child.getImage());
                trtmNewTreeitem.setBackground(child.getBackground());
                trtmNewTreeitem.setData("items", (Object)"part");
                ui.itemsMap.put(id, trtmNewTreeitem);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    private static void restoreSynItems(TreeItem baseItem, TreeItem tarItem, TreeUi ui, GOTNode parentNode) {
        try {
            TreeItem[] baseItems;
            TreeItem[] treeItemArray = baseItems = baseItem.getItems();
            int n = baseItems.length;
            int n2 = 0;
            while (n2 < n) {
                EntityNode entity;
                TreeItem child = treeItemArray[n2];
                String id = child.getData("id").toString();
                TreeItem trtmNewTreeitem = new TreeItem(tarItem, 0);
                trtmNewTreeitem.setData("id", (Object)id);
                GOTNode element = TreeUIUtil.getCurrentNode(parentNode, child);
                trtmNewTreeitem.setText(LoadXML.nodeText(element));
                trtmNewTreeitem.setData("elementName", (Object)element.getNodeType());
                if (StringUtils.isNotBlank((String)element.getId())) {
                    trtmNewTreeitem.setData("elementId", (Object)element.getId());
                }
                if ((entity = element.getEntity()) != null) {
                    trtmNewTreeitem.setData("elementEntityId", (Object)entity.getId());
                }
                trtmNewTreeitem.setFont(child.getFont());
                trtmNewTreeitem.setImage(child.getImage());
                trtmNewTreeitem.setBackground(child.getBackground());
                String label = (String)child.getData("label");
                if (StringUtils.isBlank((String)label)) {
                    trtmNewTreeitem.setData("chinese", (Object)"false");
                    ui.setChineseLabel(trtmNewTreeitem, false);
                } else {
                    trtmNewTreeitem.setData("label", (Object)label);
                }
                ui.itemsMap.put(id, trtmNewTreeitem);
                FormDataSyn.restoreSynItems(child, trtmNewTreeitem, ui, element);
                ++n2;
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void setFont(GOTNode node, TreeItem trtmNewTreeitem) {
        try {
            if (font_bold == null) {
                Font fonts = new Font((Device)trtmNewTreeitem.getDisplay(), "\u5b8b\u4f53", 9, 0);
                FontData data = fonts.getFontData()[0];
                data.setStyle(1);
                font_bold = new Font((Device)trtmNewTreeitem.getParent().getShell().getDisplay(), data);
            }
            String createdLayer = node.getCreatedLayer();
            String modifiedLayer = node.getModifiedLayer();
            if (((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer().equals(createdLayer) || ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer().equals(modifiedLayer)) {
                trtmNewTreeitem.setFont(font_bold);
            } else {
                trtmNewTreeitem.setFont(null);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    @Deprecated
    public static void setFont(Element node, TreeItem trtmNewTreeitem) {
        try {
            if (font_bold == null) {
                Font fonts = new Font((Device)trtmNewTreeitem.getDisplay(), "\u5b8b\u4f53", 9, 0);
                FontData data = fonts.getFontData()[0];
                data.setStyle(1);
                font_bold = new Font((Device)trtmNewTreeitem.getParent().getShell().getDisplay(), data);
            }
            String createdLayer = node.attributeValue("createdLayer");
            String modifiedLayer = node.attributeValue("modifiedLayer");
            if (((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer().equals(createdLayer) || ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer().equals(modifiedLayer)) {
                trtmNewTreeitem.setFont(font_bold);
            } else {
                trtmNewTreeitem.setFont(null);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void refTreeItem(Element eleDate) {
        try {
            TreeItem child;
            String entityId = eleDate.attributeValue("entityId");
            String innerId = eleDate.attributeValue("innerId");
            TreeItem item = FormDataSyn.getEntityTreeItem(entityId);
            if (item == null) {
                GOTMessageDialog.alert("\u8282\u70b9\u4e0d\u5728\u5f53\u524d\u5c42");
                return;
            }
            TreeUiBean bean = new TreeUiBean(item, false);
            if (StringUtils.isNotBlank((String)innerId) && (child = FormDataSyn.getTreeItemById(innerId, bean.treeUip)) != null) {
                bean.treeUip.getTree().setSelection(child);
                GOTNode element = TreeUIUtil.getCurrentElement2(child);
                bean.treeUip.loadTableValue(bean.treeUip.getTable(), element, child);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    @Deprecated
    public static TreeItem getTreeItrmByElement(Element node, TreeUi ui) {
        Element entity;
        String treeItemId;
        if (treeUis.isEmpty()) {
            return null;
        }
        if (ui == null) {
            ui = treeUis.get(0);
        }
        if (ui.itemsMap.containsKey(treeItemId = NumCore.getTreeItemId(entity = NodeGOT.getEntity(node), node))) {
            return ui.itemsMap.get(treeItemId);
        }
        String entityItemId = NumCore.getTreeItemId(entity, entity);
        if (ui.itemsMap.containsKey(entityItemId)) {
            ui.loadChildItem(ui.itemsMap.get(entityItemId));
            return ui.itemsMap.get(treeItemId);
        }
        return null;
    }

    public static TreeItem getTreeItrmByNode(GOTNode node, TreeUi ui) {
        String treeItemId;
        if (treeUis.isEmpty()) {
            return null;
        }
        if (ui == null) {
            ui = treeUis.get(0);
        }
        if (ui.itemsMap.containsKey(treeItemId = NumCore.getTreeItemId(node))) {
            return ui.itemsMap.get(treeItemId);
        }
        EntityNode entity = node.getEntity();
        String entityTreeId = NumCore.getTreeItemId((GOTNode)entity);
        if (ui.itemsMap.containsKey(entityTreeId)) {
            ui.loadChildItem(ui.itemsMap.get(entityTreeId));
            return ui.itemsMap.get(treeItemId);
        }
        return null;
    }

    public static TreeItem getEntityTreeItem(TreeItem item) {
        TreeItem parentItem = null;
        try {
            if (FormDataSyn.checkEntityTreeItem(item)) {
                parentItem = item;
                return parentItem;
            }
            parentItem = item.getParentItem();
            while (parentItem != null) {
                if (FormDataSyn.checkEntityTreeItem(parentItem)) {
                    return parentItem;
                }
                parentItem = parentItem.getParentItem();
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
        return null;
    }

    public static boolean checkEntityTreeItem(TreeItem treeItem) {
        String elementEntityId;
        String elementId = treeItem.getData("elementId") == null ? "" : treeItem.getData("elementId").toString();
        String string = elementEntityId = treeItem.getData("elementEntityId") == null ? "" : treeItem.getData("elementEntityId").toString();
        return StringUtils.isNotBlank((String)elementEntityId) && elementId.equals(elementEntityId);
    }

    public static TreeItem getTreeItrmEntityById(TreeUi treeUi, String id) {
        if (treeUis.isEmpty()) {
            return null;
        }
        TreeItem returnItem = treeUi.itemsMap.get(id);
        return returnItem;
    }

    public static void setItemSelection(TreeItem treeItem) {
        try {
            String id = treeItem.getData("id").toString();
            for (TreeUi treeUi : treeUis) {
                TreeItem item = treeUi.itemsMap.get(id);
                if (item == null) continue;
                treeUi.getTree().setSelection(item);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static String editText(String text) {
        String returnText = text;
        if (returnText.contains("::")) {
            returnText = returnText.substring(returnText.lastIndexOf("::") + 2);
        }
        if (returnText.contains(".")) {
            returnText = returnText.substring(returnText.lastIndexOf(".") + 1);
        }
        return returnText;
    }

    public static void stopGotConfim() {
        MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, 196);
        messagebox.setText("\u5173\u95edGOT");
        messagebox.setMessage("\u786e\u5b9a\u91cd\u65b0\u52a0\u8f7dGOT\u5417?");
        int message = messagebox.open();
        if (message == 64) {
            ConfigComposite.configComposite.init();
            FormDataSyn.stopGot();
        }
    }

    public static void stopGot() {
        try {
            for (Shell shell : GOTMessageDialog.shells) {
                if (shell.isDisposed()) continue;
                shell.close();
            }
            GOTMessageDialog.shells = new ArrayList<Shell>();
            int i = 0;
            while (i < treeUis.size()) {
                TreeUi treeUi = treeUis.get(i);
                treeUi.getTable().removeAll();
                treeUi.getTree().removeAll();
                treeUi.dragSource.dispose();
                treeUi.dropTarget.dispose();
                Iterator<Shell> iterator = null;
                ++i;
            }
            treeUis = new ArrayList<TreeUi>();
            GOTMessageDialog.shells = new ArrayList<Shell>();
            DesignerServer.stop();
            dragTreeUi = null;
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static TreeItem getEntityTreeItem(String search) {
        EntityNode node;
        block4: {
            node = GotXmlDto.getInstance().getEntityById(search);
            if (node != null) break block4;
            return null;
        }
        try {
            String treeItemId = NumCore.getTreeItemId((GOTNode)node);
            if (FormDataSyn.treeUis.get((int)0).itemsMap.containsKey(treeItemId)) {
                return FormDataSyn.treeUis.get((int)0).itemsMap.get(treeItemId);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
        return null;
    }

    public static TreeItem getTreeItemById(String search, TreeUi ui) {
        try {
            for (String id : ui.itemsMap.keySet()) {
                String elementId;
                TreeItem treeItem = ui.itemsMap.get(id);
                if (treeItem.isDisposed()) continue;
                String string = elementId = treeItem.getData("elementId") == null ? null : treeItem.getData("elementId").toString();
                if (!search.equals(elementId)) continue;
                return treeItem;
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
        return null;
    }

    public static void reset() {
        try {
            if (treeUis.size() > 0) {
                Tree tree = treeUis.get(0).getTree();
                TreeItem[] treeItemArray = tree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getText().equals("GOT")) {
                        TreeItem[] treeItems;
                        item.setExpanded(true);
                        TreeItem[] treeItemArray2 = treeItems = item.getItems();
                        int n3 = treeItems.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TreeItem treeItem = treeItemArray2[n4];
                            if (treeItem.getText().equals("DataDictionary")) {
                                TreeItem[] treeItems2;
                                treeItem.setExpanded(true);
                                TreeItem[] treeItemArray3 = treeItems2 = treeItem.getItems();
                                int n5 = treeItems2.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    TreeItem treeItem2 = treeItemArray3[n6];
                                    treeItem2.setExpanded(false);
                                    ++n6;
                                }
                            } else {
                                treeItem.setExpanded(false);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void showPrefix(boolean pre) {
        for (TreeUi treeUi : treeUis) {
            for (String id : treeUi.itemsMap.keySet()) {
                String elementEntityId;
                TreeItem treeItem = treeUi.itemsMap.get(id);
                if (treeItem.isDisposed()) continue;
                String elementId = treeItem.getData("elementId") == null ? null : treeItem.getData("elementId").toString();
                String string = elementEntityId = treeItem.getData("elementEntityId") == null ? null : treeItem.getData("elementEntityId").toString();
                if (elementEntityId == null || elementId == null || !elementEntityId.equals(elementId)) continue;
                EntityNode entityNode = GotXmlDto.getInstance().getEntityById(elementEntityId);
                treeItem.setText(LoadXML.nodeText((GOTNode)entityNode));
                FormDataSyn.setInnerNodeText(treeItem, (GOTNode)entityNode);
            }
        }
    }

    public static void setInnerNodeText(TreeItem parentItem, GOTNode entityNode) {
        TreeItem[] items;
        if (!parentItem.getExpanded()) {
            return;
        }
        GOTNode temp = entityNode;
        if (temp == null) {
            return;
        }
        TreeItem[] treeItemArray = items = parentItem.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String elementId;
            TreeItem treeItem = treeItemArray[n2];
            String string = elementId = treeItem.getData("elementId") == null ? null : treeItem.getData("elementId").toString();
            if (StringUtils.isNotBlank((String)elementId)) {
                String elementName = treeItem.getData("elementName").toString();
                try {
                    entityNode = temp.selectSingleNode(String.format("//%s[@id = '%s']", elementName, elementId));
                    if (entityNode != null) {
                        treeItem.setText(LoadXML.nodeText(entityNode));
                    }
                }
                catch (VTDException vTDException) {}
                FormDataSyn.setInnerNodeText(treeItem, entityNode);
            }
            FormDataSyn.setInnerNodeText(treeItem, temp);
            ++n2;
        }
    }

    public static void setShowTreeItemByLayerAndSolution() {
        if (treeUis.size() > 0) {
            treeUis.get(0).refreshGOTTree();
        }
    }

    public static void sendList(TreeItem parent) {
        try {
            TreeItem[] items = parent.getItems();
            ArrayList<String> ids = new ArrayList<String>();
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                GOTNode data;
                TreeItem treeItem = treeItemArray[n2];
                if (!treeItem.isDisposed() && !"0".equals((data = TreeUIUtil.getCurrentElement2(treeItem)).getAttributeValue("saved"))) {
                    String id = data.getId();
                    ids.add(id);
                }
                ++n2;
            }
            if (!ids.isEmpty()) {
                LoadXmlCore.gotServices.saveMenuOrder(ids);
            }
        }
        catch (Exception e) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GOTMessageDialog.alert(e);
                }
            });
            Logger.getLogger(FormDataSyn.class).error((Object)e);
            TreeOperationInfo.addErrorInfo(e.getMessage());
        }
    }

    public static void refreshTreeItemLabel(TreeItem entityTreeItem, GOTNode entity) {
        if (entityTreeItem == null) {
            return;
        }
        String id = entityTreeItem.getData("id").toString();
        for (TreeUi treeUi : treeUis) {
            TreeItem treeItem = treeUi.itemsMap.get(id);
            if (treeItem == null) continue;
            FormDataSyn.refreshTreeItemLabel(treeUi, treeItem, entity);
        }
    }

    private static void refreshTreeItemLabel(TreeUi treeUi, TreeItem treeItem, GOTNode entity) {
        treeItem.setData("chinese", (Object)false);
        treeUi.setChineseLabel(treeItem, entity);
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            FormDataSyn.refreshTreeItemLabel(treeUi, childItem, entity);
            ++n2;
        }
    }
}

