/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.designer.core.DesignerServer;
import gongqi.erp.framework.core.GongqiEnvironment;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import info.gongqi.got.database.Database;
import info.gongqi.got.database.DatabaseFactory;
import info.gongqi.got.datadictionary.Datadictionary;
import info.gongqi.got.datadictionary.MemoryDatadictionary;
import info.gongqi.got.merge.MergeDatabase;
import info.gongqi.got.merge.MergeDatabaseFactory;
import info.gongqi.got.merge.ProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class MergeDatabaseUtil {
    private static Logger log = Logger.getLogger(MergeDatabaseUtil.class);

    public static Datadictionary castGotModelToDictionary(GOTModel gotModel) {
        MemoryDatadictionary memoryDatadictionary = new MemoryDatadictionary();
        memoryDatadictionary.addEnumDocuments((String[])gotModel.getEntitys(EntityType.Enum).values().stream().map(e -> e.asXML()).toArray(String[]::new));
        memoryDatadictionary.addDataTypeDocuments((String[])gotModel.getEntitys(EntityType.DataType).values().stream().map(e -> e.asXML()).toArray(String[]::new));
        memoryDatadictionary.addTableDocuments((String[])gotModel.getEntitys(EntityType.Table).values().stream().map(e -> e.asXML()).toArray(String[]::new));
        return memoryDatadictionary;
    }

    private static Database getDatabase() {
        File containerDir = ((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getContainerDir();
        String devDataArea = FileUtils.readFileToDocument((File)new File(containerDir, "/WEB-INF/config/DataArea.xml")).getRootElement().selectSingleNode("./general-configuration/property[@name='gongqi.framework.data.dev_data_area']").getText();
        Element dataAreaConfigurationElement = FileUtils.readFileToDocument((File)new File(containerDir, String.format("/WEB-INF/config/dataArea/dataArea.%s.xml", devDataArea))).getRootElement();
        Element sessionFactoryElement = (Element)dataAreaConfigurationElement.selectSingleNode("./hibernate-configuration/session-factory");
        String jdbcUrl = sessionFactoryElement.selectSingleNode(String.format("./property[@name='%s']", "hibernate.connection.url")).getText();
        String jdbcUsername = sessionFactoryElement.selectSingleNode(String.format("./property[@name='%s']", "hibernate.connection.username")).getText();
        String jdbcPassword = sessionFactoryElement.selectSingleNode(String.format("./property[@name='%s']", "hibernate.connection.password")).getText();
        Database database = DatabaseFactory.createDatabase((String)jdbcUrl, (String)jdbcUsername, (String)jdbcPassword, (Collection)DesignerServer.db_ignoreRegexs);
        return database;
    }

    public static List<String> validateGotDatabase(Datadictionary datadictionary, final List<String> scopeIds) {
        Database database = MergeDatabaseUtil.getDatabase();
        final ArrayList<String> difTableNames = new ArrayList<String>();
        ProgressMonitor monitor = new ProgressMonitor(){

            public void onWorked(String tableId, String tableName, String description) {
                if (tableId == null) {
                    if (tableName.contains("$")) {
                        String prefix = tableName.substring(0, tableName.indexOf("$")).replace("_", ".");
                        if (scopeIds.contains(prefix)) {
                            difTableNames.add(tableName);
                        }
                    } else {
                        difTableNames.add(tableName);
                    }
                } else if (tableId.contains(".")) {
                    if (scopeIds.contains(tableId = tableId.substring(0, tableId.lastIndexOf(".")))) {
                        difTableNames.add(tableName);
                    }
                } else {
                    difTableNames.add(tableName);
                }
            }

            public void onStart() {
                log.info((Object)"onStart");
            }

            public void onException(Throwable e) {
                log.error((Object)"\u6821\u9a8c\u7ed3\u6784\u5931\u8d25", e);
            }

            public void onComplete() {
                log.info((Object)"\u7ed3\u6784\u6821\u9a8c\u5b8c\u6210");
            }
        };
        try {
            try {
                MergeDatabase mergeDatabase = MergeDatabaseFactory.getInstance();
                mergeDatabase.validateGotDatabase(datadictionary, database, monitor);
            }
            catch (Exception e) {
                log.error((Object)"\u6821\u9a8c\u7ed3\u6784\u5931\u8d25", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        finally {
            if (database != null) {
                database.close();
            }
        }
        return difTableNames;
    }

    public static Map<String, String> validateDataConflict(Datadictionary sourceDatadictionary, Datadictionary targetDatadictionary, final List<String> scopeIds) {
        final HashMap<String, String> configs = new HashMap<String, String>();
        ProgressMonitor monitor = new ProgressMonitor(){

            public void onWorked(String tableId, String tableName, String description) {
                if (tableId.contains(".")) {
                    if (scopeIds.contains(tableId = tableId.substring(0, tableId.lastIndexOf(".")))) {
                        configs.put(tableName, description);
                    }
                } else {
                    configs.put(tableName, description);
                }
            }

            public void onStart() {
            }

            public void onException(Throwable e) {
                log.error((Object)"\u6570\u636e\u6821\u9a8c\u5f02\u5e38", e);
            }

            public void onComplete() {
                log.debug((Object)"validateDatabaseData Complete");
            }
        };
        try (Database database = MergeDatabaseUtil.getDatabase();){
            try {
                MergeDatabase mergeDatabase = MergeDatabaseFactory.getInstance();
                mergeDatabase.validateDatabaseData(sourceDatadictionary, targetDatadictionary, database, monitor);
            }
            catch (Throwable e) {
                log.error((Object)"\u6821\u9a8c\u6570\u636e\u5931\u8d25", e);
                throw new RuntimeException(e);
            }
        }
        return configs;
    }

    public static Set<String> compareGotDatabase(Datadictionary sourceDatadictionary, Datadictionary targetDatadictionary) {
        final HashSet<String> tableIds = new HashSet<String>();
        ProgressMonitor monitor = new ProgressMonitor(){

            public void onWorked(String tableId, String tableName, String message) {
                tableIds.add(tableId);
            }

            public void onStart() {
            }

            public void onException(Throwable e) {
                log.error((Object)"\u6570\u636e\u6821\u9a8c\u5931\u8d25", e);
            }

            public void onComplete() {
            }
        };
        MergeDatabase mergeDatabase = MergeDatabaseFactory.getInstance();
        mergeDatabase.compareGotDatabase(sourceDatadictionary, targetDatadictionary, monitor);
        return tableIds;
    }

    public static List<String> modifyDatabase(Set<String> tableIds, Datadictionary sourceDatadictionary, Datadictionary targetDatadictionary) {
        final ArrayList<String> modifys = new ArrayList<String>();
        ProgressMonitor monitor = new ProgressMonitor(){

            public void onWorked(String tableId, String tableName, String message) {
                modifys.add(message);
            }

            public void onStart() {
            }

            public void onException(Throwable e) {
            }

            public void onComplete() {
            }
        };
        try (Database database = MergeDatabaseUtil.getDatabase();){
            try {
                MergeDatabase mergeDatabase = MergeDatabaseFactory.getInstance();
                mergeDatabase.modifyDatabase(tableIds, sourceDatadictionary, targetDatadictionary, database, monitor);
            }
            catch (Exception e) {
                log.error((Object)"\u62df\u5408\u7ed3\u6784\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return modifys;
    }
}

