/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.modify;

import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.modify.BaseModify;
import gongqi.gdt.designer.service.node.GOTEntity;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class TableModify
extends BaseModify {
    public TableModify(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalTargetGOT) {
        super(sourceGOT, targetGOT, originalTargetGOT);
    }

    @Override
    protected void afterEntityRename(GOTEntity entity, String srcName, String destName) {
        File srcJavaFile = new File(this.getJavaSourceDir(entity), String.format("/tables/%s.java", srcName));
        if (!srcJavaFile.exists()) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u4e0d\u5b58\u5728%s", entity.getId(), srcJavaFile.getName()));
            return;
        }
        try {
            String srcJavaText = FileUtils.readFileToString((File)srcJavaFile, (String)"UTF-8");
            String destJavaText = srcJavaText.replaceFirst(String.format("package\\s+%s\\.tables;", this.getJavaPackage(entity).replace(".", "\\.")), String.format("package %s.tables;", this.getJavaPackage(entity))).replaceFirst(String.format("public\\s+class\\s+%s", srcName), String.format("public class %s", destName)).replaceFirst(String.format("import\\s+%s\\.tables\\.base\\.Base%s;", this.getJavaPackage(entity).replace(".", "\\."), srcName), String.format("import %s.tables.base.Base%s;", this.getJavaPackage(entity).replace(".", "\\."), destName));
            FileUtils.write((File)srcJavaFile, (CharSequence)destJavaText, (String)"utf-8");
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("\u4fee\u6539\u5b9e\u4f53\u3010%s %s\u3011\u5185\u5bb9\u9519\u8bef", entity.getId(), srcName), e);
        }
        File destJavaFile = new File(this.getJavaSourceDir(entity), String.format("/tables/%s.java", destName));
        if (!destJavaFile.exists()) {
            srcJavaFile.renameTo(destJavaFile);
        } else {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u540d\u76ee\u6807\u6587\u4ef6", entity.getId(), srcName, destName));
        }
        File srcBaseTableJavaFile = new File(this.getJavaSourceDir(entity), String.format("/tables/base/Base%s.java", srcName));
        if (!srcBaseTableJavaFile.exists()) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sBaseJava\u6587\u4ef6\u4e0d\u5b58\u5728%s", entity.getId(), srcBaseTableJavaFile.getName()));
            return;
        }
        try {
            String srcJavaText = FileUtils.readFileToString((File)srcBaseTableJavaFile, (String)"UTF-8");
            String destJavaText = srcJavaText.replaceFirst(String.format("package\\s+%s\\.tables\\.base;", this.getJavaPackage(entity).replace(".", "\\.")), String.format("package %s.tables\\.base;", this.getJavaPackage(entity))).replaceFirst(String.format("public\\s+class\\s+Base%s", srcName), String.format("public class Base%s", destName));
            Pattern pattern = Pattern.compile(String.format("extends\\s+[a-zA-Z]+[0-9a-zA-Z_]*(\\.[a-zA-Z]+[0-9a-zA-Z_]*)*\\.layers\\.[a-zA-Z0-9]{3}\\.tables\\.%s\\s*\\{", srcName));
            Matcher matcher = pattern.matcher(destJavaText);
            if (matcher.find()) {
                String src = matcher.group();
                String dest = src.replaceFirst(String.format("\\.tables\\.%s\\s*\\{", srcName), String.format(".tables.%s {", destName, destName));
                destJavaText = destJavaText.replace(src, dest);
            }
            FileUtils.write((File)srcBaseTableJavaFile, (CharSequence)destJavaText, (String)"utf-8");
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("\u4fee\u6539\u5b9e\u4f53BaseJava\u3010%s %s\u3011\u5185\u5bb9\u9519\u8bef", entity.getId(), srcName), e);
        }
        File destBaseTableJavaFile = new File(this.getJavaSourceDir(entity), String.format("/tables/base/%s.java", destName));
        if (!destBaseTableJavaFile.exists()) {
            srcBaseTableJavaFile.renameTo(destBaseTableJavaFile);
        } else {
            this.log.warn((Object)String.format("Table\u3010%s\u3011Base Java\u6587\u4ef6\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u540d\u76ee\u6807\u6587\u4ef6", entity.getId(), srcName, destName));
        }
    }
}

