/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.gdt.designer.ProjectConstants;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;

public class PedestalLayerInfo {
    private String layerId;
    private String layerName;
    private String label;
    private String namespace;
    private LayerDeploymentMode deploymentMode;
    private String currentVersion;
    private String targetVersion;
    private TableItem bindItem;
    private String downloadUrl;
    private Boolean online;
    private boolean emptyLayer = true;
    private PedestalLayerInfo lowerLayerInfo;

    public PedestalLayerInfo getLowerLayerInfo() {
        return this.lowerLayerInfo;
    }

    public void setLowerLayerInfo(PedestalLayerInfo lowerLayerInfo) {
        this.lowerLayerInfo = lowerLayerInfo;
    }

    public void setEmptyLayer(boolean emptyLayer) {
        this.emptyLayer = emptyLayer;
    }

    public boolean isEmptyLayer() {
        return this.emptyLayer;
    }

    public Boolean isOnline() {
        return this.online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public TableItem getBindItem() {
        return this.bindItem;
    }

    public void setBindItem(TableItem bindItem) {
        this.bindItem = bindItem;
    }

    public LayerDeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(LayerDeploymentMode deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public File getUpdateFile(String version) {
        File basePath = ProjectConstants.getBasePath();
        if (this.deploymentMode.equals((Object)LayerDeploymentMode.Package)) {
            File updateFile = new File(basePath, String.format("Temp/LayerChainCache/UpdateFile/%s/%s/layer_%s.lyr", this.layerId, version, this.layerId, version));
            return updateFile;
        }
        File updateFile = new File(basePath, String.format("Temp/LayerChainCache/UpdateFile/%s/%s/%s", this.layerId, version, this.layerId));
        return updateFile;
    }

    public void updateBindItem() {
        this.bindItem.setText(0, this.getLayerName());
        this.bindItem.setText(1, this.getNamespace());
        this.bindItem.setText(2, this.getLabel());
        this.bindItem.setText(3, this.getDeploymentMode().equals((Object)LayerDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
        this.bindItem.setText(4, this.getCurrentVersion());
        this.bindItem.setText(5, this.getTargetVersion() == null ? "" : this.getTargetVersion());
        this.bindItem.setText(6, this.isOnline() == null ? "" : (this.isOnline() != false ? "\u5728\u7ebf" : "\u79bb\u7ebf"));
        if (StringUtils.isNotBlank((String)this.getTargetVersion()) && !this.getTargetVersion().equals(this.getCurrentVersion())) {
            FontData fontData = this.bindItem.getFont().getFontData()[0];
            fontData.setStyle(1);
            this.bindItem.setFont(new Font((Device)Display.getCurrent(), fontData));
        } else {
            FontData fontData = this.bindItem.getFont().getFontData()[0];
            fontData.setStyle(0);
            this.bindItem.setFont(new Font((Device)Display.getCurrent(), fontData));
        }
        this.bindItem.setForeground(Display.getCurrent().getSystemColor(2));
    }

    public PedestalLayerInfo clone() {
        PedestalLayerInfo pedestalLayerInfo = new PedestalLayerInfo();
        pedestalLayerInfo.setLayerId(this.layerId);
        pedestalLayerInfo.setLayerName(this.layerName);
        pedestalLayerInfo.setLabel(this.label);
        pedestalLayerInfo.setNamespace(this.namespace);
        pedestalLayerInfo.setDeploymentMode(this.deploymentMode);
        pedestalLayerInfo.setCurrentVersion(this.currentVersion);
        pedestalLayerInfo.setTargetVersion(this.targetVersion);
        pedestalLayerInfo.setBindItem(this.bindItem);
        pedestalLayerInfo.setDownloadUrl(this.downloadUrl);
        pedestalLayerInfo.setOnline(this.online);
        return pedestalLayerInfo;
    }
}

