/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.utils.LayerJavaCode;
import gongqi.gdt.designer.utils.LayerJavaMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityMethods {
    private GOTEntity sourceEntity;
    private GOTEntity targetEntity;
    private List<LayerJavaCode> sourceJavaCodes;
    private List<LayerJavaCode> targetJavaCodes;
    private EntityType entityType;

    public EntityMethods(GOTEntity sourceEntity, GOTEntity targetEntity, EntityType entityType) {
        this.sourceEntity = sourceEntity;
        this.targetEntity = targetEntity;
        this.sourceJavaCodes = new ArrayList<LayerJavaCode>();
        this.targetJavaCodes = new ArrayList<LayerJavaCode>();
        this.entityType = entityType;
    }

    public void setSourceJavaCodes(List<LayerJavaCode> sourceJavaCodes) {
        this.sourceJavaCodes = sourceJavaCodes;
    }

    public void setTargetJavaCodes(List<LayerJavaCode> targetJavaCodes) {
        this.targetJavaCodes = targetJavaCodes;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    private Set<String> getTargetJavaCodes() {
        return this.targetJavaCodes.stream().map(t -> t.getSimpleName()).collect(Collectors.toSet());
    }

    private Set<String> getSourceJavaCodes() {
        return this.sourceJavaCodes.stream().map(s -> s.getSimpleName()).collect(Collectors.toSet());
    }

    public List<String> getAllCodes() {
        Set<String> codes = this.getTargetJavaCodes();
        codes.addAll(this.getSourceJavaCodes());
        return codes.stream().sorted((o1, o2) -> o1.compareTo((String)o1)).collect(Collectors.toList());
    }

    private List<LayerJavaCode> getSourceJavaCode(String simpleName) {
        return this.sourceJavaCodes.stream().filter(c -> simpleName.equals(c.getSimpleName())).collect(Collectors.toList());
    }

    private List<LayerJavaCode> getTargetJavaCode(String simpleName) {
        return this.targetJavaCodes.stream().filter(c -> simpleName.equals(c.getSimpleName())).collect(Collectors.toList());
    }

    public Map<String, List<LayerJavaMethod>> getSourceMethods(String simpleName) {
        return this.getSourceJavaCode(simpleName).stream().flatMap(s -> s.getLayerJavaMethods().stream()).collect(Collectors.groupingBy(LayerJavaMethod::getSignature));
    }

    public Map<String, List<LayerJavaMethod>> getTargetMethods(String simpleName) {
        return this.getTargetJavaCode(simpleName).stream().flatMap(s -> s.getLayerJavaMethods().stream()).collect(Collectors.groupingBy(LayerJavaMethod::getSignature));
    }

    public LayerJavaCode.JavaType getJavaType(String simpleName) {
        List<LayerJavaCode> targetJavaCode = this.getTargetJavaCode(simpleName);
        if (targetJavaCode.isEmpty()) {
            return this.getSourceJavaCode(simpleName).get(0).getJavaType();
        }
        return targetJavaCode.get(0).getJavaType();
    }
}

