/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import gongqi.gdt.designer.utils.MarketUtil;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MarketOnlineVersion {
    private String title;
    private Shell shell;
    private Table table;
    private Label dependInfo;
    private PedestalLayerInfo pedestalInfo;
    private SolutionLayerInfo solutionInfo;
    private SolutionPluginInfo pluginInfo;
    private LayerType layerType;

    public MarketOnlineVersion(PedestalLayerInfo pedestalInfo) {
        this.pedestalInfo = pedestalInfo;
        this.title = pedestalInfo.getLayerName();
        this.layerType = LayerType.Obj;
    }

    public MarketOnlineVersion(SolutionLayerInfo solutionInfo) {
        this.solutionInfo = solutionInfo;
        this.title = String.valueOf(solutionInfo.getSolutionName()) + "(" + solutionInfo.getSolutionId() + ")";
        this.layerType = LayerType.App;
    }

    public MarketOnlineVersion(SolutionPluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
        this.title = String.valueOf(pluginInfo.getPluginName()) + "(" + pluginInfo.getPluginId() + ")";
        this.layerType = LayerType.Plugin;
    }

    public void open() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 65600);
        this.shell.setText(this.title);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(620), SWTUtils.zoom(400));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.createContent();
        try {
            if (this.layerType.equals((Object)LayerType.Obj)) {
                this.buildPedestalTable();
            } else if (this.layerType.equals((Object)LayerType.App)) {
                this.buildAppTable();
            } else if (this.layerType.equals((Object)LayerType.Plugin)) {
                this.buildPluginTable();
            }
            TableItem[] items = this.table.getItems();
            if (items.length > 0) {
                TableItem tableItem = items[0];
                this.table.setSelection(0);
                String info = (String)tableItem.getData("dependInfo");
                info = info == null ? "" : info;
                this.dependInfo.setText(info);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)e.getMessage());
        }
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContent() {
        this.table = new Table((Composite)this.shell, 0x10010800);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-80));
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-30));
        this.table.setLayoutData((Object)formData);
        TableColumn versionColumn = new TableColumn(this.table, 0);
        versionColumn.setText("\u7248\u672c\u53f7");
        versionColumn.setWidth(SWTUtils.zoom(80));
        TableColumn dateColumn = new TableColumn(this.table, 0);
        dateColumn.setText("\u7248\u672c\u65e5\u671f");
        dateColumn.setWidth(SWTUtils.zoom(100));
        TableColumn summaryColumn = new TableColumn(this.table, 0);
        summaryColumn.setText("\u7248\u672c\u4ecb\u7ecd");
        summaryColumn.setWidth(SWTUtils.zoom(320));
        Button button_Confirm = new Button((Composite)this.shell, 8);
        button_Confirm.setText("\u786e\u8ba4");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(30));
        formData.top = new FormAttachment((Control)this.table, 0, 128);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-5));
        button_Confirm.setLayoutData((Object)formData);
        Listener listener = null;
        if (this.layerType.equals((Object)LayerType.Obj)) {
            listener = this.selectPedestalListener();
        } else if (this.layerType.equals((Object)LayerType.App)) {
            listener = this.selectSolutionListener();
        } else if (this.layerType.equals((Object)LayerType.Plugin)) {
            listener = this.selectPluginListener();
        }
        button_Confirm.addListener(3, listener);
        Button button_Cancel = new Button((Composite)this.shell, 8);
        button_Cancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(30));
        formData.top = new FormAttachment((Control)button_Confirm, SWTUtils.zoom(5), 1024);
        formData.right = new FormAttachment((Control)button_Confirm, 0, 131072);
        button_Cancel.setLayoutData((Object)formData);
        button_Cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarketOnlineVersion.this.shell.close();
            }
        });
        this.dependInfo = new Label((Composite)this.shell, 16384);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-8));
        formData.left = new FormAttachment((Control)this.table, 0, 16384);
        formData.right = new FormAttachment((Control)this.table, 0, 131072);
        this.dependInfo.setForeground(Display.getCurrent().getSystemColor(9));
        this.dependInfo.setLayoutData((Object)formData);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem tableItem = MarketOnlineVersion.this.table.getSelection()[0];
                String info = (String)tableItem.getData("dependInfo");
                info = info == null ? "" : info;
                MarketOnlineVersion.this.dependInfo.setText(info);
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                Point point = new Point(event.x, event.y);
                TableItem tableItem = MarketOnlineVersion.this.table.getItem(point);
                if (tableItem != null) {
                    String tooltipText = tableItem.getText(2);
                    MarketOnlineVersion.this.table.setToolTipText(tooltipText);
                }
            }
        });
    }

    private Listener selectPedestalListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = MarketOnlineVersion.this.table.getSelection();
                if (selection.length <= 0) {
                    return;
                }
                TableItem item = selection[0];
                String downloadUrl = (String)item.getData();
                if (StringUtils.isBlank((String)downloadUrl)) {
                    return;
                }
                MarketOnlineVersion.this.pedestalInfo.setDownloadUrl(downloadUrl);
                MarketOnlineVersion.this.pedestalInfo.setTargetVersion(item.getText(0));
                MarketOnlineVersion.this.pedestalInfo.setOnline(true);
                MarketOnlineVersion.this.pedestalInfo.updateBindItem();
                MarketOnlineVersion.this.shell.close();
            }
        };
    }

    private Listener selectSolutionListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = MarketOnlineVersion.this.table.getSelection();
                if (selection.length <= 0) {
                    return;
                }
                TableItem item = selection[0];
                String appUserId = (String)item.getData("appUserId");
                if (StringUtils.isBlank((String)appUserId)) {
                    return;
                }
                MarketOnlineVersion.this.solutionInfo.setAppUserId(appUserId);
                MarketOnlineVersion.this.solutionInfo.setTargetVersion(item.getText(0));
                MarketOnlineVersion.this.solutionInfo.setOnline(true);
                MarketOnlineVersion.this.solutionInfo.updateBindItem();
                MarketOnlineVersion.this.shell.close();
            }
        };
    }

    private Listener selectPluginListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = MarketOnlineVersion.this.table.getSelection();
                if (selection.length <= 0) {
                    return;
                }
                TableItem item = selection[0];
                String downloadPluginId = (String)item.getData();
                if (StringUtils.isBlank((String)downloadPluginId)) {
                    return;
                }
                MarketOnlineVersion.this.pluginInfo.setTargetVersion(item.getText(0));
                MarketOnlineVersion.this.pluginInfo.setDownloadPluginId(downloadPluginId);
                MarketOnlineVersion.this.pluginInfo.setOnline(true);
                MarketOnlineVersion.this.pluginInfo.updateBindItem();
                MarketOnlineVersion.this.shell.close();
            }
        };
    }

    private void buildPedestalTable() {
        JSONArray content = MarketOnlineVersion.getPedestalVersionList(this.pedestalInfo);
        if (content == null) {
            return;
        }
        int i = 0;
        while (i < content.size()) {
            JSONObject versionInfo = content.getJSONObject(i);
            String version = versionInfo.getString("version");
            String uploadDate = versionInfo.getString("date");
            if (uploadDate.length() > 10) {
                uploadDate = uploadDate.substring(0, 10);
            }
            JSONArray lines = versionInfo.getJSONArray("versionLine");
            String versionSummary = lines.stream().map(l -> ((JSONObject)l).getString("content")).collect(Collectors.joining(System.lineSeparator()));
            String url = versionInfo.getString("url");
            TableItem subItem = new TableItem(this.table, 0);
            subItem.setText(new String[]{version, uploadDate, versionSummary});
            subItem.setData((Object)url);
            if (version.equals(this.pedestalInfo.getCurrentVersion())) {
                FontData fontData = subItem.getFont().getFontData()[0];
                fontData.setStyle(1);
                subItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            ++i;
        }
        this.table.addListener(8, this.selectPedestalListener());
    }

    private void buildAppTable() {
        JSONObject content = MarketOnlineVersion.getSolutionVersionList(this.solutionInfo);
        if (content == null) {
            return;
        }
        String appUserId = content.getString("appUserId");
        JSONArray versionArray = content.getJSONArray("versionArray");
        if (versionArray == null || versionArray.isEmpty()) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        int i = 0;
        while (i < versionArray.size()) {
            JSONObject versionInfo = versionArray.getJSONObject(i);
            String version = versionInfo.getString("version");
            Timestamp uploadDate = versionInfo.getTimestamp("uploadDate");
            Date date = new Date(uploadDate.getTime());
            JSONArray lines = versionInfo.getJSONArray("lines");
            String versionSummary = String.join((CharSequence)"\n", lines.toJavaList(String.class));
            TableItem subItem = new TableItem(this.table, 0);
            subItem.setText(new String[]{version, format.format(date), versionSummary});
            subItem.setData("appUserId", (Object)appUserId);
            if (version.equals(this.solutionInfo.getCurrentVersion())) {
                FontData fontData = subItem.getFont().getFontData()[0];
                fontData.setStyle(1);
                subItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            subItem.setData("sysVersion", (Object)versionInfo.getString("sysVersion"));
            subItem.setData("objVersion", (Object)versionInfo.getString("objVersion"));
            subItem.setData("inyVersion", (Object)versionInfo.getString("inyVersion"));
            subItem.setData("entVersion", (Object)versionInfo.getString("entVersion"));
            subItem.setData("dependInfo", (Object)String.format("sys(%s)  obj(%s)  iny(%s)  ent(%s)", versionInfo.getString("sysVersion"), versionInfo.getString("objVersion"), versionInfo.getString("inyVersion"), versionInfo.getString("entVersion")));
            ++i;
        }
        this.table.addListener(8, this.selectSolutionListener());
    }

    private void buildPluginTable() {
        JSONObject content = MarketOnlineVersion.getPlugionVersionList(this.pluginInfo);
        if (content == null) {
            return;
        }
        JSONArray pluginArray = content.getJSONArray("content");
        String appPluginId = content.getString("appPluginId");
        if (pluginArray == null || pluginArray.isEmpty() || StringUtils.isBlank((String)appPluginId)) {
            return;
        }
        int i = 0;
        while (i < pluginArray.size()) {
            JSONObject versionInfo = pluginArray.getJSONObject(i);
            String version = versionInfo.getString("versionId");
            String uploadDate = versionInfo.getString("date");
            if (uploadDate.length() > 10) {
                uploadDate = uploadDate.substring(0, 10);
            }
            JSONArray lines = versionInfo.getJSONArray("versionLines");
            String versionSummary = lines.stream().map(l -> ((JSONObject)l).getString("content")).collect(Collectors.joining(System.lineSeparator()));
            TableItem subItem = new TableItem(this.table, 0);
            subItem.setText(new String[]{version, uploadDate, versionSummary});
            subItem.setData((Object)appPluginId);
            if (version.equals(this.pluginInfo.getCurrentVersion())) {
                FontData fontData = subItem.getFont().getFontData()[0];
                fontData.setStyle(1);
                subItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            subItem.setData("sysVersion", (Object)versionInfo.getString("sysVersion"));
            subItem.setData("objVersion", (Object)versionInfo.getString("objVersion"));
            subItem.setData("inyVersion", (Object)versionInfo.getString("inyVersion"));
            subItem.setData("entVersion", (Object)versionInfo.getString("entVersion"));
            subItem.setData("appVersion", (Object)versionInfo.getString("appVersion"));
            subItem.setData("frameworkVersion", (Object)versionInfo.getString("frameworkVersion"));
            subItem.setData("dependInfo", (Object)String.format("sys(%s)  obj(%s)  iny(%s)  ent(%s)  app(%s)  framework(%s)", versionInfo.getString("sysVersion"), versionInfo.getString("objVersion"), versionInfo.getString("inyVersion"), versionInfo.getString("entVersion"), versionInfo.getString("appVersion"), versionInfo.getString("frameworkVersion")));
            ++i;
        }
        this.table.addListener(8, this.selectPluginListener());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONArray getPedestalVersionList(PedestalLayerInfo pedestalInfo) {
        if (!pedestalInfo.getLayerId().equals("obj")) {
            return null;
        }
        String layerLabel = pedestalInfo.getLabel();
        String doMainId = "";
        String cookieText = MarketUtil.getCookie();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                CloseableHttpResponse response;
                block27: {
                    HttpEntity entity;
                    JSONObject responseResult;
                    Object var10_15;
                    Throwable throwable2;
                    HttpGet httpGet;
                    String baseUrl;
                    block26: {
                        baseUrl = MarketUtil.baseUrl;
                        httpGet = new HttpGet(String.format("%s/doMain/my/doMain", baseUrl));
                        httpGet.addHeader("Cookie", MarketUtil.getCookie());
                        throwable2 = null;
                        var10_15 = null;
                        try {
                            response = httpClient.execute((HttpUriRequest)httpGet);
                            try {
                                if (response.getStatusLine().getStatusCode() != 200 || (responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(entity = response.getEntity()), (String)"utf-8"))).getIntValue("errcode") != 0) break block26;
                                JSONArray layerList = responseResult.getJSONArray("content");
                                int i = 0;
                                while (i < layerList.size()) {
                                    JSONObject layer = layerList.getJSONObject(i);
                                    String doMain = layer.getString("doMain");
                                    if (!doMain.equals(layerLabel)) {
                                        ++i;
                                        continue;
                                    }
                                    doMainId = layer.getString("id");
                                    break;
                                }
                            }
                            finally {
                                if (response != null) {
                                    response.close();
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            }
                            if (throwable2 == throwable3) throw throwable2;
                            throwable2.addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                    httpGet = new HttpGet(String.format("%s/doMain/doMainVersions?doMain=%s&doMainId=%s&isTrial=false", baseUrl, layerLabel, doMainId));
                    httpGet.addHeader("Cookie", cookieText);
                    throwable2 = null;
                    var10_15 = null;
                    try {
                        JSONArray jSONArray;
                        response = httpClient.execute((HttpUriRequest)httpGet);
                        try {
                            JSONArray content;
                            if (response.getStatusLine().getStatusCode() != 200 || (responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(entity = response.getEntity()), (String)"utf-8"))).getIntValue("errcode") != 0) break block27;
                            jSONArray = content = responseResult.getJSONObject("content").getJSONArray("data");
                            if (response == null) return jSONArray;
                        }
                        catch (Throwable throwable4) {
                            if (response == null) throw throwable4;
                            response.close();
                            throw throwable4;
                        }
                        response.close();
                        return jSONArray;
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                            throw throwable2;
                        }
                        if (throwable2 == throwable5) throw throwable2;
                        throwable2.addSuppressed(throwable5);
                        throw throwable2;
                    }
                }
                if (response == null) return null;
                response.close();
                return null;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u67e5\u8be2\u7248\u672c\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject getSolutionVersionList(SolutionLayerInfo solutionInfo) {
        String cookieText = MarketUtil.getCookie();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                CloseableHttpResponse response;
                block16: {
                    String baseUrl = MarketUtil.baseUrl;
                    HttpGet httpGet = new HttpGet(String.format("%s/developer/appInfo?appId=%s", baseUrl, solutionInfo.getSolutionId()));
                    httpGet.addHeader("Cookie", cookieText);
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try {
                        JSONObject jSONObject;
                        response = httpClient.execute((HttpUriRequest)httpGet);
                        try {
                            HttpEntity entity;
                            JSONObject responseResult;
                            if (response.getStatusLine().getStatusCode() != 200 || (responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(entity = response.getEntity()), (String)"utf-8"))).getIntValue("errcode") != 0) break block16;
                            jSONObject = responseResult.getJSONObject("content");
                            if (response == null) return jSONObject;
                        }
                        catch (Throwable throwable3) {
                            if (response == null) throw throwable3;
                            response.close();
                            throw throwable3;
                        }
                        response.close();
                        return jSONObject;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                if (response == null) return null;
                response.close();
                return null;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u67e5\u8be2\u7248\u672c\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject getPlugionVersionList(SolutionPluginInfo pluginInfo) {
        JSONArray content;
        JSONObject responseResult;
        HttpEntity entity;
        CloseableHttpResponse response;
        Object var10_18;
        Throwable throwable;
        HttpGet httpGet;
        CloseableHttpClient httpClient;
        Object var6_10;
        String appPluginId;
        String baseUrl;
        String cookieText;
        block35: {
            cookieText = MarketUtil.getCookie();
            baseUrl = MarketUtil.baseUrl;
            String appId = pluginInfo.getSolutionLayerInfo().getSolutionId();
            appPluginId = "";
            try {
                Throwable throwable2 = null;
                var6_10 = null;
                try {
                    httpClient = HttpClients.createDefault();
                    try {
                        httpGet = new HttpGet(String.format("%s/appuser/PluginlistNew?isActive=true&aboutMe=false&info=%s&", baseUrl, appId));
                        httpGet.addHeader("Cookie", MarketUtil.getCookie());
                        throwable = null;
                        var10_18 = null;
                        try {
                            response = httpClient.execute((HttpUriRequest)httpGet);
                            try {
                                if (response.getStatusLine().getStatusCode() != 200) throw new RuntimeException("\u5e94\u7528\u5e02\u573a\u7f51\u7edc\u8bf7\u6c42\u9519\u8bef, http code=" + response.getStatusLine().getStatusCode());
                                entity = response.getEntity();
                                responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                                if (responseResult.getIntValue("errcode") != 0) break block35;
                                content = responseResult.getJSONArray("content");
                                int i = 0;
                                while (i < content.size()) {
                                    String pluginNameSpace;
                                    JSONObject app = content.getJSONObject(i);
                                    String solutionId = app.getString("AppId");
                                    if (solutionId.equals(appId) && (pluginNameSpace = app.getString("PluginNameSpace")).equals(pluginInfo.getPluginId())) {
                                        appPluginId = app.getString("AppPluginId");
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            finally {
                                if (response != null) {
                                    response.close();
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    finally {
                        if (httpClient != null) {
                            httpClient.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u67e5\u8be2\u63d2\u4ef6\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
            }
        }
        if (StringUtils.isBlank((String)appPluginId)) {
            return null;
        }
        try {
            Throwable e = null;
            var6_10 = null;
            try {
                httpClient = HttpClients.createDefault();
                try {
                    block36: {
                        httpGet = new HttpGet(String.format("%s/plugin/version/history?pluginId=%s&isTrial=false", baseUrl, appPluginId));
                        httpGet.addHeader("Cookie", cookieText);
                        throwable = null;
                        var10_18 = null;
                        try {
                            JSONObject jSONObject;
                            response = httpClient.execute((HttpUriRequest)httpGet);
                            try {
                                if (response.getStatusLine().getStatusCode() != 200 || (responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)(entity = response.getEntity()), (String)"utf-8"))).getIntValue("errcode") != 0) break block36;
                                content = responseResult.getJSONArray("content");
                                JSONObject result = new JSONObject();
                                result.put("content", (Object)content);
                                result.put("appPluginId", (Object)appPluginId);
                                jSONObject = result;
                                if (response == null) return jSONObject;
                            }
                            catch (Throwable throwable5) {
                                if (response == null) throw throwable5;
                                response.close();
                                throw throwable5;
                            }
                            response.close();
                            return jSONObject;
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                                throw throwable;
                            }
                            if (throwable == throwable6) throw throwable;
                            throwable.addSuppressed(throwable6);
                            throw throwable;
                        }
                    }
                    if (response == null) return null;
                    response.close();
                    return null;
                }
                finally {
                    if (httpClient != null) {
                        httpClient.close();
                    }
                }
            }
            catch (Throwable throwable7) {
                if (e == null) {
                    e = throwable7;
                    throw e;
                }
                if (e == throwable7) throw e;
                e.addSuppressed(throwable7);
                throw e;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u67e5\u8be2\u7248\u672c\u5217\u8868\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public static void setLastPedestalVersion(PedestalLayerInfo pedestalInfo) {
        JSONArray versionList = MarketOnlineVersion.getPedestalVersionList(pedestalInfo);
        if (versionList == null || versionList.isEmpty()) {
            return;
        }
        JSONObject version = versionList.getJSONObject(0);
        pedestalInfo.setDownloadUrl(version.getString("url"));
        pedestalInfo.setTargetVersion(version.getString("version"));
        pedestalInfo.setOnline(true);
        pedestalInfo.updateBindItem();
    }

    public static boolean setLastSolutionVersion(SolutionLayerInfo solutionInfo, String objVersion) {
        JSONObject content = MarketOnlineVersion.getSolutionVersionList(solutionInfo);
        if (content == null) {
            return false;
        }
        String appUserId = content.getString("appUserId");
        JSONArray versionArray = content.getJSONArray("versionArray");
        if (versionArray == null || versionArray.isEmpty() || StringUtils.isBlank((String)appUserId)) {
            return false;
        }
        Optional<Object> findFirst = versionArray.stream().filter(p -> objVersion.equals(((JSONObject)p).getString("objVersion"))).findFirst();
        if (findFirst.isPresent()) {
            JSONObject versionInfo = (JSONObject)findFirst.get();
            solutionInfo.setAppUserId(appUserId.toString());
            solutionInfo.setTargetVersion(versionInfo.getString("version"));
            solutionInfo.setOnline(true);
            solutionInfo.updateBindItem();
            return true;
        }
        return false;
    }

    public static boolean setLastPluginVersion(SolutionPluginInfo pluginInfo) {
        JSONObject content = MarketOnlineVersion.getPlugionVersionList(pluginInfo);
        if (content == null) {
            return false;
        }
        JSONArray pluginArray = content.getJSONArray("content");
        String appPluginId = content.getString("appPluginId");
        String targetVersion = pluginInfo.getSolutionLayerInfo().getTargetVersion();
        if (StringUtils.isBlank((String)targetVersion) || pluginArray == null || pluginArray.isEmpty() || StringUtils.isBlank((String)appPluginId)) {
            return false;
        }
        Optional<Object> findFirst = pluginArray.stream().filter(p -> targetVersion.equals(((JSONObject)p).getString("appVersion"))).findFirst();
        if (findFirst.isPresent()) {
            JSONObject versionInfo = (JSONObject)findFirst.get();
            pluginInfo.setTargetVersion(versionInfo.getString("versionId"));
            pluginInfo.setDownloadPluginId(appPluginId);
            pluginInfo.setOnline(true);
            pluginInfo.updateBindItem();
            return true;
        }
        return false;
    }

    public static JSONObject getSolutionVersionInfo(SolutionLayerInfo solutionInfo, String version) {
        JSONObject content = MarketOnlineVersion.getSolutionVersionList(solutionInfo);
        if (content == null) {
            return null;
        }
        String appUserId = content.getString("appUserId");
        JSONArray versionArray = content.getJSONArray("versionArray");
        if (versionArray == null || versionArray.isEmpty() || StringUtils.isBlank((String)appUserId)) {
            return null;
        }
        Optional<Object> findFirst = versionArray.stream().filter(p -> version.equals(((JSONObject)p).getString("version"))).findFirst();
        if (findFirst.isPresent()) {
            JSONObject versionInfo = (JSONObject)findFirst.get();
            return versionInfo;
        }
        return null;
    }

    public static JSONObject getPluginVersionInfo(SolutionPluginInfo pluginInfo, String version) {
        JSONObject content = MarketOnlineVersion.getPlugionVersionList(pluginInfo);
        if (content == null) {
            return null;
        }
        JSONArray pluginArray = content.getJSONArray("content");
        Optional<Object> findFirst = pluginArray.stream().filter(p -> version.equals(((JSONObject)p).getString("versionId"))).findFirst();
        if (findFirst.isPresent()) {
            JSONObject versionInfo = (JSONObject)findFirst.get();
            return versionInfo;
        }
        return null;
    }

    private static enum LayerType {
        Obj,
        App,
        Plugin;

    }
}

