/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import com.alibaba.fastjson.JSONObject;
import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.tools.ZipUtil;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.service.LayerUpgradeService;
import gongqi.gdt.designer.service.ProgressMonitor;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.ui.ErrorInfoDialog;
import gongqi.gdt.designer.ui.LayerChainFilter;
import gongqi.gdt.designer.ui.LayerChainPage;
import gongqi.gdt.designer.ui.LayerChainUpgrade;
import gongqi.gdt.designer.ui.StructureCompare;
import gongqi.gdt.designer.utils.EntityMethods;
import gongqi.gdt.designer.utils.Images;
import gongqi.gdt.designer.utils.LayerChainConfig;
import gongqi.gdt.designer.utils.LayerJavaCode;
import gongqi.gdt.designer.utils.LayerJavaMethod;
import gongqi.gdt.designer.utils.MarketUtil;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.util.ComposeIMG;
import info.gongqi.got.util.GOTMessageDialog;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AnalysisResultPage {
    private Shell shell;
    private Logger log = Logger.getLogger(LayerChainUpgrade.class);
    private Tree gotTree;
    private Table detailTable;
    private Tree compareTree;
    private Tree propertyInfoTree;
    private Tree javaMethodTree;
    private TabFolder tabFolder;
    private Composite treeResultComposite;
    private Composite modelResultComposite;
    private Composite codeResultComposite;
    private boolean analysis_Finish = false;
    private boolean upgrade_Succeed = false;
    private Button button_Resource;
    private Button button_analysis;
    private Button button_ExportExcel;
    private Button button_Upgrade;
    private static LayerUpgradeService upgradeService = new LayerUpgradeService();
    private static Element structureXML;
    private static List<String> ignoreAnalysisPropertys;
    private ToolItem addButton;
    private ToolItem deleteButton;
    private ToolItem difButton;
    private ToolItem sameButton;
    private Menu menu;
    private ToolItem showPublic;
    private ToolItem showProtect;
    private ToolItem showPrivate;
    private ToolItem showDefault;
    private ToolItem showPromote;
    private SourceViewer javaCodeText;
    private Label resourceInfo;
    private Label tipInfo;
    private Label methodTipInfo;
    private static Image addImage;
    private static Image deleteImage;
    private static Image difImage;
    private static Image sameImage;
    private static Image orderImage;
    private static Image noAddImage;
    private static Image noDeleteImage;
    private static Image noDifImage;
    private static Image noSameImage;
    private static Image publicMethod;
    private static Image protectMethod;
    private static Image privateMethod;
    private static Image defaultMethod;
    private List<Element> analysisResult_Cache = new ArrayList<Element>();
    private Map<EntityType, Map<String, GOTEntity>> allEntitys = new HashMap<EntityType, Map<String, GOTEntity>>();
    private LayerChainConfig layerChainConfig = new LayerChainConfig();
    private static List<DisplayType> displayScope;

    static {
        ignoreAnalysisPropertys = Arrays.asList("CreatedDate", "CreatedTime", "CreatedBy", "ModifiedDate", "ModifiedTime", "ModifiedBy");
        displayScope = new ArrayList<DisplayType>(Arrays.asList(DisplayType.Add, DisplayType.Dif, DisplayType.Delete));
        addImage = Images.getIcon("layerUpgrade/Add.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        deleteImage = Images.getIcon("layerUpgrade/Delete.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        difImage = Images.getIcon("layerUpgrade/Dif.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        sameImage = Images.getIcon("layerUpgrade/Same.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        orderImage = Images.getIcon("layerUpgrade/Order.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        noAddImage = Images.getIcon("layerUpgrade/noAdd.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        noDeleteImage = Images.getIcon("layerUpgrade/noDelete.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        noDifImage = Images.getIcon("layerUpgrade/noDif.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        noSameImage = Images.getIcon("layerUpgrade/noSame.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        publicMethod = Images.getIcon("layerUpgrade/Method_Public.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        protectMethod = Images.getIcon("layerUpgrade/Method_Protect.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        privateMethod = Images.getIcon("layerUpgrade/Method_Private.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        defaultMethod = Images.getIcon("layerUpgrade/Method_Default.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        try {
            structureXML = DocumentHelper.parseText((String)"<GOT>\r\n\t<DataDictionary>\r\n\t\t<Enums>\r\n\t\t\t<EnumItem/>\r\n\t\t</Enums>\r\n\t\t<DataTypes>\r\n\t\t\t<DataTypeRelation/>\r\n\t\t</DataTypes>\r\n\t\t<Tables>\r\n\t\t\t<TableFields type=\"Default\">\r\n\t\t\t\t<TableField/>\r\n\t\t\t</TableFields>\r\n\t\t\t<TableIndexes type=\"Default\">\r\n\t\t\t\t<TableIndex>\r\n\t\t\t\t\t<TableIndexItem/>\r\n\t\t\t\t</TableIndex>\r\n\t\t\t</TableIndexes>\r\n\t\t\t<TableFieldGroups type=\"Default\">\r\n\t\t\t\t<TableFieldGroup>\r\n\t\t\t\t\t<TableFieldGroupItem/>\r\n\t\t\t\t</TableFieldGroup>\r\n\t\t\t</TableFieldGroups>\r\n\t\t</Tables>\r\n\t</DataDictionary>\r\n\t<Menus>\r\n\t\t<MenuSub>\r\n\t\t\t<MenuRefMenuItem/>\r\n\t\t</MenuSub>\r\n\t\t<MenuRefMenuItem/>\r\n\t</Menus>\r\n\t<MenuItems/>\r\n\t<Forms>\r\n\t\t<FormDataSources type=\"Default\">\r\n\t\t\t<FormDataSource>\r\n\t\t\t\t<FormDataSourceFields type=\"Default\">\r\n\t\t\t\t\t<FormDataSourceField/>\r\n\t\t\t\t</FormDataSourceFields>\r\n\t\t\t\t<FormDataSourceFieldGroups type=\"Default\">\r\n\t\t\t\t\t<FormDataSourceFieldGroup/>\r\n\t\t\t\t</FormDataSourceFieldGroups>\r\n\t\t\t\t<FormDataSourceRelation type=\"Default\">\r\n\t\t\t\t\t<FormDataSourceRelationItem/>\r\n\t\t\t\t</FormDataSourceRelation>\r\n\t\t\t</FormDataSource>\r\n\t\t</FormDataSources>\r\n\t\t<FormDesign type=\"Default\">\r\n\t\t\t<FormItem/>\r\n\t\t</FormDesign>\r\n\t</Forms>\r\n\t<Reports/>\r\n\t<Classes>\r\n\t\t<Class/>\r\n\t</Classes>\r\n</GOT>").getRootElement();
        }
        catch (DocumentException documentException) {}
    }

    public AnalysisResultPage() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setText("\u5c42\u94fe\u5347\u7ea7");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(1200), SWTUtils.zoom(600));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
    }

    public void show() {
        this.createContent();
        this.buildGOTTree();
        this.updateButtonStatus();
        this.shell.open();
        LayerChainPage layerChainPage = new LayerChainPage(info -> {
            this.analysis_Finish = false;
            this.updateButtonStatus();
        }, info -> this.resourceInfo.setText(info));
        layerChainPage.open();
    }

    protected void createContent() {
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) != 0) {
                    TreeItem treeItem = (TreeItem)event.item;
                    if (treeItem == null) {
                        return;
                    }
                    Rectangle bounds = treeItem.getBounds();
                    Color color = null;
                    color = treeItem.getParent().isFocusControl() ? new Color((Device)Display.getCurrent(), 204, 232, 255) : new Color((Device)Display.getCurrent(), 217, 217, 217);
                    event.gc.setBackground(color);
                    event.gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                    event.gc.setForeground(treeItem.getForeground());
                    event.gc.drawText(treeItem.getText(), bounds.x, bounds.y, true);
                }
            }
        };
        Composite center = new Composite((Composite)this.shell, 2048);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-90));
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        center.setLayoutData((Object)formData);
        center.setLayout((Layout)new FormLayout());
        Composite left = new Composite(center, 0);
        formData = new FormData(SWTUtils.zoom(200), -1);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(SWTUtils.zoom(20));
        left.setLayoutData((Object)formData);
        left.setLayout((Layout)new FormLayout());
        this.gotTree = new Tree(left, 67840);
        formData = new FormData(SWTUtils.zoom(200), -1);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-27));
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.gotTree.setLayoutData((Object)formData);
        this.gotTree.setFont(new Font((Device)Display.getCurrent(), "\u5b8b\u4f53", 9, 0));
        this.gotTree.addMouseListener(MouseListener.mouseDownAdapter(this::showTreeItemContextMenu));
        this.gotTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeItem = (TreeItem)e.item;
                AnalysisResultPage.this.showCompareResult(treeItem);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.gotTree.addListener(42, paintListener);
        this.resourceInfo = new Label(left, 16384);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.left = new FormAttachment((Control)this.gotTree, SWTUtils.zoom(5), 16384);
        formData.right = new FormAttachment((Control)this.gotTree, SWTUtils.zoom(-25), 131072);
        this.resourceInfo.setForeground(Display.getCurrent().getSystemColor(9));
        this.resourceInfo.setLayoutData((Object)formData);
        ToolBar gotToolBar = new ToolBar(left, 8519744);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-3));
        formData.left = new FormAttachment((Control)this.gotTree, SWTUtils.zoom(-22), 131072);
        formData.right = new FormAttachment((Control)this.gotTree, 0, 131072);
        gotToolBar.setLayoutData((Object)formData);
        ToolItem filterButton = new ToolItem(gotToolBar, 131072);
        filterButton.setImage(Images.getIcon("layerUpgrade/filter.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        filterButton.setToolTipText("\u7b5b\u9009");
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainFilter layerChainFilter = new LayerChainFilter(LayerChainPage.getSolutions(), AnalysisResultPage.this.layerChainConfig);
                layerChainFilter.show();
                AnalysisResultPage.this.buildGOTTree();
                AnalysisResultPage.this.resetView();
            }
        });
        Sash sash = new Sash(center, 512);
        formData = new FormData();
        formData.left = new FormAttachment((Control)left, 2, 131072);
        formData.top = new FormAttachment((Control)left, 0, 128);
        formData.bottom = new FormAttachment((Control)left, 0, 1024);
        sash.setLayoutData((Object)formData);
        sash.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            left.setSize(e.x, composite.getBounds().height);
            sash.setBounds(e.x + 2, sash.getBounds().y, sash.getBounds().width, sash.getBounds().height);
            int detailTableX = sash.getBounds().x + sash.getBounds().width + 2;
            this.tabFolder.setBounds(detailTableX, this.tabFolder.getBounds().y, composite2.getBounds().width - detailTableX, this.tabFolder.getBounds().height);
        }));
        this.tabFolder = new TabFolder(center, 0);
        formData = new FormData();
        formData.left = new FormAttachment((Control)sash, 2, 131072);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-26));
        this.tabFolder.setLayoutData((Object)formData);
        this.modelResultComposite = new Composite((Composite)this.tabFolder, 0);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.modelResultComposite.setLayoutData((Object)formData);
        this.modelResultComposite.setLayout((Layout)new FormLayout());
        this.treeResultComposite = new Composite(this.modelResultComposite, 0);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.treeResultComposite.setLayoutData((Object)formData);
        this.treeResultComposite.setLayout((Layout)new FormLayout());
        this.compareTree = new Tree(this.treeResultComposite, 67840);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(45);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.compareTree.setLayoutData((Object)formData);
        this.compareTree.addListener(42, paintListener);
        this.compareTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem selection = AnalysisResultPage.this.compareTree.getSelection()[0];
                Object SourceNode = selection.getData("SourceNode");
                Object TargetNode = selection.getData("TargetNode");
                if (SourceNode == null && TargetNode == null) {
                    return;
                }
                String entityType = "";
                Map<Object, Object> attributes = new HashMap();
                try {
                    if (SourceNode != null) {
                        if (SourceNode instanceof GOTNode) {
                            AnalysisResultPage.this.buildTreeInfoTable(((GOTNode)SourceNode).getPropertys(), TargetNode != null ? ((GOTNode)TargetNode).getPropertys() : new ArrayList());
                            attributes = ((GOTNode)SourceNode).getAttributes();
                            entityType = ((GOTNode)SourceNode).getNodeType();
                        } else if (SourceNode instanceof GOTEntity) {
                            AnalysisResultPage.this.buildTreeInfoTable(((GOTEntity)SourceNode).getPropertys(), TargetNode != null ? ((GOTEntity)TargetNode).getPropertys() : new ArrayList());
                            attributes = ((GOTEntity)SourceNode).getAttributes();
                            entityType = ((GOTEntity)SourceNode).getNodeType();
                        }
                    } else if (TargetNode instanceof GOTNode) {
                        AnalysisResultPage.this.buildTreeInfoTable(new ArrayList(), ((GOTNode)TargetNode).getPropertys());
                        attributes = ((GOTNode)TargetNode).getAttributes();
                        entityType = ((GOTNode)TargetNode).getNodeType();
                    } else if (TargetNode instanceof GOTEntity) {
                        AnalysisResultPage.this.buildTreeInfoTable(new ArrayList(), ((GOTEntity)TargetNode).getPropertys());
                        attributes = ((GOTEntity)TargetNode).getAttributes();
                        entityType = ((GOTEntity)TargetNode).getNodeType();
                    }
                }
                catch (Exception exception) {}
                AnalysisResultPage.this.setTipInfo(entityType, attributes);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.compareTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeItem[] selections = AnalysisResultPage.this.compareTree.getSelection();
                if (e.button != 3 || selections.length <= 0) {
                    return;
                }
                if (AnalysisResultPage.this.compareTree.getMenu() != null) {
                    AnalysisResultPage.this.compareTree.getMenu().dispose();
                }
                String id = (String)selections[0].getData("id");
                String nodeType = (String)selections[0].getData("nodeType");
                if (StringUtils.isBlank((String)id)) {
                    return;
                }
                Object data = AnalysisResultPage.this.compareTree.getData();
                if (data == null || !(data instanceof Element)) {
                    return;
                }
                Element element = (Element)data;
                List items = element.elements();
                if ((items = items.stream().filter(item -> id.equals(item.attributeValue("innerId")) || id.equals(item.attributeValue("nodeType")) || item.attributeValue("nodeType").equals(nodeType) && StringUtils.isBlank((String)item.attributeValue("innerId"))).collect(Collectors.toList())).isEmpty()) {
                    return;
                }
                Menu layMenu = new Menu((Control)AnalysisResultPage.this.compareTree);
                MenuItem addItem = new MenuItem(layMenu, 8);
                addItem.setText("\u67e5\u770b\u8be6\u60c5");
                addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TreeItem[] selections = AnalysisResultPage.this.compareTree.getSelection();
                        String id = (String)selections[0].getData("id");
                        String nodeType = (String)selections[0].getData("nodeType");
                        Object data = AnalysisResultPage.this.compareTree.getData();
                        if (data == null || !(data instanceof Element)) {
                            return;
                        }
                        Element element = (Element)data;
                        List<Element> items = element.elements();
                        items = items.stream().filter(item -> id.equals(item.attributeValue("innerId")) || id.equals(item.attributeValue("nodeType")) || item.attributeValue("nodeType").equals(nodeType) && StringUtils.isBlank((String)item.attributeValue("innerId"))).collect(Collectors.toList());
                        ErrorInfoDialog dialog = new ErrorInfoDialog(items);
                        dialog.open();
                    }
                });
                if (items.stream().filter(item -> item.attributeValue("modifyType").equals(ModifyType.InnerNode_Order.name())).findAny().isPresent()) {
                    MenuItem compareStructure = new MenuItem(layMenu, 8);
                    compareStructure.setText("\u5bf9\u6bd4\u7ed3\u6784");
                    compareStructure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            TreeItem selection = AnalysisResultPage.this.compareTree.getSelection()[0];
                            Object SourceNode = selection.getData("SourceNode");
                            Object TargetNode = selection.getData("TargetNode");
                            try {
                                StructureCompare compare = new StructureCompare(SourceNode, TargetNode);
                                compare.open();
                            }
                            catch (Exception e1) {
                                MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u5347", (String)e1.getMessage());
                            }
                        }
                    });
                }
                AnalysisResultPage.this.compareTree.setMenu(layMenu);
            }
        });
        Sash sashRight = new Sash(this.treeResultComposite, 512);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.compareTree, 2, 131072);
        formData.top = new FormAttachment((Control)this.compareTree, 0, 128);
        formData.bottom = new FormAttachment((Control)this.compareTree, 0, 1024);
        sashRight.setLayoutData((Object)formData);
        sashRight.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.compareTree.setSize(e.x, this.compareTree.getBounds().height);
            sashRight.setBounds(e.x + 2, sash.getBounds().y, sash.getBounds().width, sash.getBounds().height);
            int detailTableX = sash.getBounds().x + sash.getBounds().width + 2;
            this.propertyInfoTree.setBounds(detailTableX, this.propertyInfoTree.getBounds().y, composite.getBounds().width - detailTableX, this.propertyInfoTree.getBounds().height);
        }));
        this.propertyInfoTree = new Tree(this.treeResultComposite, 67840);
        formData = new FormData();
        formData.left = new FormAttachment((Control)sashRight, 2, 131072);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment((Control)this.compareTree, 0, 1024);
        this.propertyInfoTree.setLayoutData((Object)formData);
        this.propertyInfoTree.setHeaderVisible(true);
        this.propertyInfoTree.setLinesVisible(true);
        this.propertyInfoTree.addListener(42, paintListener);
        TreeColumn propertyColumn = new TreeColumn(this.propertyInfoTree, 16384, 0);
        propertyColumn.setText("\u5c5e\u6027\u540d");
        propertyColumn.setWidth(150);
        TreeColumn UpgradeBefore = new TreeColumn(this.propertyInfoTree, 16384, 1);
        UpgradeBefore.setText("\u5f53\u524d\u503c");
        UpgradeBefore.setWidth(175);
        TreeColumn UpgradeAfter = new TreeColumn(this.propertyInfoTree, 16384, 2);
        UpgradeAfter.setText("\u5347\u7ea7\u503c");
        UpgradeAfter.setWidth(175);
        this.detailTable = new Table(this.modelResultComposite, 65540);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-24));
        this.detailTable.setLayoutData((Object)formData);
        this.detailTable.setHeaderVisible(true);
        this.detailTable.setLinesVisible(true);
        TableColumn nodeType = new TableColumn(this.detailTable, 0x1000000, 0);
        nodeType.setText("\u7c7b\u578b");
        nodeType.setWidth(100);
        TableColumn descriptionColumn = new TableColumn(this.detailTable, 16384, 1);
        descriptionColumn.setText("\u5185\u5bb9\u63cf\u8ff0");
        descriptionColumn.setWidth(500);
        this.detailTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                AnalysisResultPage.this.detailTable.getColumn(1).setWidth(((AnalysisResultPage)AnalysisResultPage.this).detailTable.getBounds().width - 100);
            }
        });
        this.detailTable.setVisible(false);
        final ToolBar toolBar = new ToolBar(center, 8519744);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-2));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        toolBar.setLayoutData((Object)formData);
        final ToolItem treeLayoutButton = new ToolItem(toolBar, 131104);
        treeLayoutButton.setImage(Images.getIcon("layerUpgrade/treeLayout.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        treeLayoutButton.setSelection(true);
        treeLayoutButton.setToolTipText("\u6811\u5f62\u5c55\u793a");
        final ToolItem tableLayoutButton = new ToolItem(toolBar, 131104);
        tableLayoutButton.setImage(Images.getIcon("layerUpgrade/tableLayout.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        tableLayoutButton.setToolTipText("\u5217\u8868\u5c55\u793a");
        treeLayoutButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean select = treeLayoutButton.getSelection();
                if (select) {
                    AnalysisResultPage.this.detailTable.setVisible(false);
                    AnalysisResultPage.this.treeResultComposite.setVisible(true);
                    tableLayoutButton.setSelection(false);
                } else {
                    treeLayoutButton.setSelection(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tableLayoutButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean select = tableLayoutButton.getSelection();
                if (select) {
                    AnalysisResultPage.this.detailTable.setVisible(true);
                    AnalysisResultPage.this.treeResultComposite.setVisible(false);
                    treeLayoutButton.setSelection(false);
                } else {
                    tableLayoutButton.setSelection(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new ToolItem(toolBar, 2).setWidth(10);
        this.addButton = new ToolItem(toolBar, 131104);
        this.addButton.setImage(addImage);
        this.addButton.setSelection(true);
        this.addButton.setToolTipText("\u663e\u793a\u65b0\u589e");
        this.deleteButton = new ToolItem(toolBar, 131104);
        this.deleteButton.setImage(deleteImage);
        this.deleteButton.setSelection(true);
        this.deleteButton.setToolTipText("\u663e\u793a\u5220\u9664");
        this.difButton = new ToolItem(toolBar, 131104);
        this.difButton.setImage(difImage);
        this.difButton.setSelection(true);
        this.difButton.setToolTipText("\u663e\u793a\u5dee\u5f02");
        this.sameButton = new ToolItem(toolBar, 131104);
        this.sameButton.setImage(noSameImage);
        this.sameButton.setToolTipText("\u663e\u793a\u76f8\u540c");
        SelectionAdapter treeFilterListen = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                displayScope = new ArrayList();
                if (!AnalysisResultPage.this.sameButton.getSelection()) {
                    AnalysisResultPage.this.sameButton.setImage(noSameImage);
                } else {
                    AnalysisResultPage.this.sameButton.setImage(sameImage);
                    displayScope.add(DisplayType.Same);
                }
                if (!AnalysisResultPage.this.difButton.getSelection()) {
                    AnalysisResultPage.this.difButton.setImage(noDifImage);
                } else {
                    AnalysisResultPage.this.difButton.setImage(difImage);
                    displayScope.add(DisplayType.Dif);
                }
                if (!AnalysisResultPage.this.deleteButton.getSelection()) {
                    AnalysisResultPage.this.deleteButton.setImage(noDeleteImage);
                } else {
                    AnalysisResultPage.this.deleteButton.setImage(deleteImage);
                    displayScope.add(DisplayType.Delete);
                }
                if (!AnalysisResultPage.this.addButton.getSelection()) {
                    AnalysisResultPage.this.addButton.setImage(noAddImage);
                } else {
                    AnalysisResultPage.this.addButton.setImage(addImage);
                    displayScope.add(DisplayType.Add);
                }
                TreeItem[] selection = AnalysisResultPage.this.gotTree.getSelection();
                if (selection.length > 0) {
                    AnalysisResultPage.this.showCompareResult(selection[0]);
                }
            }
        };
        this.addButton.addSelectionListener((SelectionListener)treeFilterListen);
        this.deleteButton.addSelectionListener((SelectionListener)treeFilterListen);
        this.difButton.addSelectionListener((SelectionListener)treeFilterListen);
        this.sameButton.addSelectionListener((SelectionListener)treeFilterListen);
        this.tipInfo = new Label(center, 16384);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.left = new FormAttachment((Control)this.tabFolder, SWTUtils.zoom(5), 16384);
        formData.right = new FormAttachment((Control)toolBar, SWTUtils.zoom(-5), 16384);
        this.tipInfo.setForeground(Display.getCurrent().getSystemColor(9));
        this.tipInfo.setLayoutData((Object)formData);
        this.codeResultComposite = new Composite((Composite)this.tabFolder, 0);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.codeResultComposite.setLayoutData((Object)formData);
        this.codeResultComposite.setLayout((Layout)new FormLayout());
        this.javaMethodTree = new Tree(this.codeResultComposite, 67840);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(45);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.javaMethodTree.setLayoutData((Object)formData);
        this.javaMethodTree.setHeaderVisible(false);
        this.javaMethodTree.setLinesVisible(false);
        this.javaMethodTree.addListener(42, paintListener);
        this.javaMethodTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeItem = (TreeItem)e.item;
                AnalysisResultPage.this.showJavaContent(treeItem);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Sash javaSash = new Sash(this.codeResultComposite, 512);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.javaMethodTree, 2, 131072);
        formData.top = new FormAttachment((Control)this.javaMethodTree, 0, 128);
        formData.bottom = new FormAttachment((Control)this.javaMethodTree, 0, 1024);
        javaSash.setLayoutData((Object)formData);
        javaSash.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.javaMethodTree.setSize(e.x, this.javaMethodTree.getBounds().height);
            javaSash.setBounds(e.x + 2, sash.getBounds().y, sash.getBounds().width, sash.getBounds().height);
            int detailTableX = sash.getBounds().x + sash.getBounds().width + 2;
            this.javaCodeText.getControl().setBounds(detailTableX, this.javaCodeText.getControl().getBounds().y, this.codeResultComposite.getBounds().width - detailTableX, this.javaCodeText.getControl().getBounds().height);
        }));
        ToolBar javaTitleToolBar = new ToolBar(this.codeResultComposite, 8519744);
        formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(2));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-18));
        javaTitleToolBar.setLayoutData((Object)formData);
        final ToolItem methodView = new ToolItem(javaTitleToolBar, 131076);
        methodView.setImage(Images.getIcon("layerUpgrade/showSource.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        methodView.setToolTipText("\u521d\u59cb\u65b9\u6cd5");
        this.menu = new Menu((Decorations)this.shell, 8);
        methodView.addListener(13, event -> {
            Rectangle rect = methodView.getBounds();
            Point pt = new Point(rect.x, rect.y + rect.height);
            pt = javaTitleToolBar.toDisplay(pt);
            this.menu.setLocation(pt.x, pt.y);
            this.menu.setVisible(true);
        });
        this.menu.setData((Object)"sourceMethod");
        final MenuItem showOriginMenu = new MenuItem(this.menu, 16);
        showOriginMenu.setImage(Images.getIcon("layerUpgrade/showOrigin.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        showOriginMenu.setText("\u521d\u59cb\u65b9\u6cd5");
        final MenuItem showSourceMenu = new MenuItem(this.menu, 16);
        showSourceMenu.setImage(Images.getIcon("layerUpgrade/showSource.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        showSourceMenu.setText("\u5f53\u524d\u65b9\u6cd5");
        showSourceMenu.setSelection(true);
        final MenuItem showTargetMenu = new MenuItem(this.menu, 16);
        showTargetMenu.setImage(Images.getIcon("layerUpgrade/showTarget.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        showTargetMenu.setText("\u5347\u7ea7\u65b9\u6cd5");
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem selected = (MenuItem)e.widget;
                Image image = null;
                if (selected == showOriginMenu) {
                    showSourceMenu.setSelection(false);
                    showTargetMenu.setSelection(false);
                    AnalysisResultPage.this.menu.setData((Object)"originMethod");
                    image = Images.getIcon("layerUpgrade/showOrigin.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
                } else if (selected == showSourceMenu) {
                    showOriginMenu.setSelection(false);
                    showTargetMenu.setSelection(false);
                    AnalysisResultPage.this.menu.setData((Object)"sourceMethod");
                    image = Images.getIcon("layerUpgrade/showSource.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
                } else if (selected == showTargetMenu) {
                    showOriginMenu.setSelection(false);
                    showSourceMenu.setSelection(false);
                    AnalysisResultPage.this.menu.setData((Object)"targetMethod");
                    image = Images.getIcon("layerUpgrade/showTarget.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
                }
                methodView.setImage(image);
                TreeItem[] selection = AnalysisResultPage.this.javaMethodTree.getSelection();
                if (selection.length < 1) {
                    return;
                }
                AnalysisResultPage.this.showJavaContent(selection[0]);
            }
        };
        showOriginMenu.addSelectionListener((SelectionListener)listener);
        showSourceMenu.addSelectionListener((SelectionListener)listener);
        showTargetMenu.addSelectionListener((SelectionListener)listener);
        this.javaCodeText = new SourceViewer(this.codeResultComposite, null, 2816);
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.jdt.ui");
        JavaTextTools textTools = new JavaTextTools((IPreferenceStore)preferenceStore);
        this.javaCodeText.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(textTools.getColorManager(), (IPreferenceStore)preferenceStore, null, null));
        formData = new FormData();
        formData.left = new FormAttachment((Control)javaSash, 2, 131072);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)this.javaMethodTree, 0, 128);
        formData.bottom = new FormAttachment((Control)this.javaMethodTree, 0, 1024);
        this.javaCodeText.getControl().setLayoutData((Object)formData);
        this.javaCodeText.setEditable(false);
        final ToolBar javaToolBar = new ToolBar(center, 8519744);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-2));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        javaToolBar.setLayoutData((Object)formData);
        this.showPromote = new ToolItem(javaToolBar, 131104);
        this.showPromote.setImage(Images.getIcon("layerUpgrade/Public_Override.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.showPromote.setToolTipText("\u4ec5\u663e\u793a\u63d0\u5347\u65b9\u6cd5");
        new ToolItem(javaToolBar, 2).setWidth(10);
        this.showPublic = new ToolItem(javaToolBar, 131104);
        this.showPublic.setImage(publicMethod);
        this.showPublic.setSelection(true);
        this.showPublic.setToolTipText("Public");
        this.showProtect = new ToolItem(javaToolBar, 131104);
        this.showProtect.setImage(protectMethod);
        this.showProtect.setSelection(true);
        this.showProtect.setToolTipText("Protected");
        this.showPrivate = new ToolItem(javaToolBar, 131104);
        this.showPrivate.setImage(privateMethod);
        this.showPrivate.setSelection(true);
        this.showPrivate.setToolTipText("Private");
        this.showDefault = new ToolItem(javaToolBar, 131104);
        this.showDefault.setImage(defaultMethod);
        this.showDefault.setSelection(true);
        this.showDefault.setToolTipText("Default");
        SelectionAdapter methodFilterListen = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalysisResultPage.this.buildJavaMethod();
            }
        };
        this.showPromote.addSelectionListener((SelectionListener)methodFilterListen);
        this.showPublic.addSelectionListener((SelectionListener)methodFilterListen);
        this.showProtect.addSelectionListener((SelectionListener)methodFilterListen);
        this.showPrivate.addSelectionListener((SelectionListener)methodFilterListen);
        this.showDefault.addSelectionListener((SelectionListener)methodFilterListen);
        this.methodTipInfo = new Label(center, 16384);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.left = new FormAttachment((Control)this.tabFolder, SWTUtils.zoom(5), 16384);
        formData.right = new FormAttachment((Control)javaToolBar, SWTUtils.zoom(-5), 16384);
        this.methodTipInfo.setForeground(Display.getCurrent().getSystemColor(9));
        this.methodTipInfo.setLayoutData((Object)formData);
        final TabItem modelTab = new TabItem(this.tabFolder, 0);
        modelTab.setText("\u6a21\u578b");
        modelTab.setControl((Control)this.modelResultComposite);
        final TabItem codeTab = new TabItem(this.tabFolder, 0);
        codeTab.setText("\u4ee3\u7801");
        codeTab.setControl((Control)this.codeResultComposite);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalysisResultPage.this.tabFolder.getSelection()[0] == modelTab) {
                    toolBar.setVisible(true);
                    javaToolBar.setVisible(false);
                    AnalysisResultPage.this.codeResultComposite.setVisible(false);
                    AnalysisResultPage.this.modelResultComposite.setVisible(true);
                    AnalysisResultPage.this.tipInfo.setVisible(true);
                    AnalysisResultPage.this.methodTipInfo.setVisible(false);
                } else if (AnalysisResultPage.this.tabFolder.getSelection()[0] == codeTab) {
                    toolBar.setVisible(false);
                    javaToolBar.setVisible(true);
                    AnalysisResultPage.this.codeResultComposite.setVisible(true);
                    AnalysisResultPage.this.modelResultComposite.setVisible(false);
                    AnalysisResultPage.this.tipInfo.setVisible(false);
                    AnalysisResultPage.this.methodTipInfo.setVisible(true);
                }
            }
        });
        this.button_Resource = new Button((Composite)this.shell, 8);
        this.button_Resource.setText("\u5347\u7ea7\u6587\u4ef6");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)center, 0, 128);
        formData.left = new FormAttachment((Control)center, SWTUtils.zoom(5), 131072);
        this.button_Resource.setLayoutData((Object)formData);
        this.button_analysis = new Button((Composite)this.shell, 8);
        this.button_analysis.setText("\u5185\u5bb9\u5206\u6790");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_Resource, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_Resource, 0, 16384);
        this.button_analysis.setLayoutData((Object)formData);
        this.button_ExportExcel = new Button((Composite)this.shell, 8);
        this.button_ExportExcel.setText("\u5bfc\u51fa\u7ed3\u679c");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_analysis, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_analysis, 0, 16384);
        this.button_ExportExcel.setLayoutData((Object)formData);
        this.button_Upgrade = new Button((Composite)this.shell, 8);
        this.button_Upgrade.setText("\u786e\u8ba4\u5347\u7ea7");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_ExportExcel, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_ExportExcel, 0, 16384);
        this.button_Upgrade.setLayoutData((Object)formData);
        this.button_Resource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainPage layerChainPage = new LayerChainPage(info -> {
                    AnalysisResultPage.this.analysis_Finish = false;
                    AnalysisResultPage.this.updateButtonStatus();
                    AnalysisResultPage.this.resourceInfo.setText(info);
                }, info -> AnalysisResultPage.this.resourceInfo.setText(info));
                layerChainPage.open();
            }
        });
        this.button_analysis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, 196);
                messagebox.setText("\u5185\u5bb9\u5206\u6790");
                messagebox.setMessage("\u786e\u5b9a\u5f00\u59cb\u8fdb\u884c\u5185\u5bb9\u5206\u6790");
                int message = messagebox.open();
                if (message == 64) {
                    try {
                        List<String> results = LayerChainPage.checkBeforeAnalysis();
                        if (results.isEmpty()) {
                            AnalysisResultPage.this.analysis();
                        } else {
                            MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)String.join((CharSequence)System.lineSeparator(), results));
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)ExceptionUtils.getRootCause((Throwable)e1).getMessage());
                    }
                }
            }
        });
        this.button_ExportExcel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog directory = new FileDialog(AnalysisResultPage.this.shell);
                directory.setFileName("\u5c42\u94fe\u5206\u6790\u7ed3\u679c.xls");
                directory.setFilterExtensions(new String[]{".xls"});
                String path = directory.open();
                if (StringUtils.isNotBlank((String)path)) {
                    if (!path.endsWith(".xls")) {
                        GOTMessageDialog.alert("\u8bf7\u5bfc\u51fa.xls\u6587\u4ef6");
                        return;
                    }
                    try {
                        AnalysisResultPage.this.exportResultAsExcel(path);
                        GOTMessageDialog.info("\u5b8c\u6210\u5bfc\u51fa");
                    }
                    catch (Exception e1) {
                        AnalysisResultPage.this.log.error((Object)e1);
                        GOTMessageDialog.alert("\u5bfc\u51fa\u5931\u8d25\uff1a" + e1.getMessage());
                    }
                }
            }
        });
        this.button_Upgrade.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalysisResultPage.this.upgrade()) {
                    AnalysisResultPage.this.analysis_Finish = false;
                    AnalysisResultPage.this.button_ExportExcel.setEnabled(false);
                    AnalysisResultPage.this.button_Upgrade.setEnabled(false);
                    AnalysisResultPage.this.analysisResult_Cache = new ArrayList();
                    upgradeService = new LayerUpgradeService();
                    AnalysisResultPage.this.gotTree.removeAll();
                    AnalysisResultPage.this.initGOTTree(AnalysisResultPage.this.newEmptyGOTElement(), null);
                    AnalysisResultPage.this.gotTree.getItem(0).setExpanded(true);
                    AnalysisResultPage.this.gotTree.getItem(0).getItem(0).setExpanded(true);
                    AnalysisResultPage.this.compareTree.removeAll();
                    AnalysisResultPage.this.propertyInfoTree.removeAll();
                    AnalysisResultPage.this.detailTable.removeAll();
                    AnalysisResultPage.this.tipInfo.setText("");
                    AnalysisResultPage.this.methodTipInfo.setText("");
                    LayerChainPage.clearCache();
                }
            }
        });
    }

    protected void showJavaContent(TreeItem treeItem) {
        String javaPackagePath = (String)treeItem.getData("javaPackagePath");
        this.methodTipInfo.setText(javaPackagePath != null ? javaPackagePath : "");
        Object method = null;
        String methodView = (String)this.menu.getData();
        method = treeItem.getData(methodView);
        if (method == null || !(method instanceof String)) {
            return;
        }
        this.javaCodeText.setDocument((IDocument)new Document(String.valueOf(System.lineSeparator()) + method.toString()));
    }

    private void showTreeItemContextMenu(MouseEvent e) {
        if (e.button != 3) {
            return;
        }
        TreeItem treeItem = this.gotTree.getItem(new Point(e.x, e.y));
        if (treeItem == null) {
            return;
        }
        String entityId = (String)treeItem.getData("entityId");
        if (StringUtils.isBlank((String)entityId)) {
            return;
        }
        Menu menu = new Menu((Control)this.gotTree);
        MenuItem enterEntity = new MenuItem(menu, 8);
        enterEntity.setText("\u8fdb\u5165\u5173\u8054");
        enterEntity.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            TreeUi mainTreeUI = FormDataSyn.treeUis.get(0);
            Element entityElement = GotXmlDto.getInstance().getEntity(entityId);
            if (entityElement != null) {
                TreeItem entityTreeItem = FormDataSyn.getTreeItrmByElement(entityElement, mainTreeUI);
                new TreeUiBean(entityTreeItem, false);
            } else {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)String.format("\u5f53\u524dGOT\u6811\u4e0d\u5b58\u5728\u5b9e\u4f53%s", entityId));
            }
        }));
        this.gotTree.setMenu(menu);
    }

    private void showCompareResult(TreeItem treeItem) {
        String modifyLyr;
        String targetName;
        this.detailTable.removeAll();
        this.compareTree.removeAll();
        this.tipInfo.setText("");
        this.methodTipInfo.setText("");
        this.javaMethodTree.removeAll();
        this.javaCodeText.setDocument((IDocument)new Document());
        this.propertyInfoTree.removeAll();
        String entityId = (String)treeItem.getData("entityId");
        if (StringUtils.isBlank((String)entityId)) {
            return;
        }
        Element result = (Element)treeItem.getData("result");
        Map<Object, Object> innerIds = new HashMap();
        if (result != null) {
            List itemElements = result.elements();
            for (Element itemElement : itemElements) {
                ModifyType modifyType = ModifyType.valueOf(itemElement.attributeValue("modifyType"));
                if (!this.IsInDisplayScope(modifyType)) continue;
                TableItem rowItem = new TableItem(this.detailTable, 0);
                rowItem.setText(0, modifyType.getLabel());
                rowItem.setText(1, itemElement.attributeValue("description"));
                String modifyLevel = itemElement.attributeValue("modifyLevel");
                if (ModifyLevel.valueOf(modifyLevel) != ModifyLevel.Cannot) continue;
                rowItem.setForeground(this.shell.getDisplay().getSystemColor(3));
            }
            innerIds = itemElements.stream().collect(Collectors.groupingBy(i -> {
                String innerId = i.attributeValue("innerId");
                if (StringUtils.isNotBlank((String)innerId)) {
                    return innerId;
                }
                return i.attributeValue("nodeType");
            }));
        }
        this.compareTree.setData((Object)result);
        String entityTypes = treeItem.getParentItem().getText();
        if (entityTypes.contains("(")) {
            entityTypes = entityTypes.substring(0, entityTypes.indexOf("("));
        }
        entityTypes = entityTypes.equals("Classes") ? entityTypes.substring(0, entityTypes.length() - 2) : entityTypes.substring(0, entityTypes.length() - 1);
        EntityType entityType = EntityType.valueOf((String)entityTypes);
        GOTEntity sourceEntity = upgradeService.getSourceEntity(entityType, entityId);
        GOTEntity targetEntity = upgradeService.getTargetEntity(entityType, entityId);
        if (sourceEntity == null && targetEntity == null) {
            return;
        }
        Element element = (Element)structureXML.selectSingleNode(entityType.getEntityTypeXPath());
        TreeItem entityItem = new TreeItem(this.compareTree, 0);
        String sourceName = sourceEntity != null ? sourceEntity.getAttributeValue("name") : "";
        String string = targetName = targetEntity != null ? targetEntity.getAttributeValue("name") : "";
        if (sourceName.contains(".")) {
            sourceName = sourceName.substring(sourceName.lastIndexOf(".") + 1, sourceName.length());
        }
        if (targetName.contains(".")) {
            targetName = targetName.substring(targetName.lastIndexOf(".") + 1, targetName.length());
        }
        if (StringUtils.isBlank((String)sourceName)) {
            entityItem.setText(targetName);
        } else if (StringUtils.isBlank((String)targetName)) {
            entityItem.setText(sourceName);
        } else if (!sourceName.equals(targetName)) {
            entityItem.setText(String.valueOf(sourceName) + " -> " + targetName);
        } else {
            entityItem.setText(sourceName);
        }
        String nodeType = sourceEntity != null ? sourceEntity.getNodeType() : targetEntity.getNodeType();
        List<Element> modifyInfos = new ArrayList();
        if (innerIds.containsKey(entityId)) {
            modifyInfos = (List)innerIds.get(entityId);
        }
        if (innerIds.containsKey(nodeType)) {
            modifyInfos.addAll((Collection)innerIds.get(nodeType));
        }
        if (modifyInfos.isEmpty()) {
            entityItem.setImage(Images.getIcon(String.format("%s.png", entityType.name())));
        } else {
            this.setTreeItemStyle(entityItem, modifyInfos);
        }
        entityItem.setData("id", (Object)entityId);
        entityItem.setData("nodeType", (Object)nodeType);
        entityItem.setData("SourceNode", (Object)sourceEntity);
        entityItem.setData("TargetNode", (Object)targetEntity);
        String createLyr = sourceEntity != null ? sourceEntity.getCreatedLayer() : targetEntity.getCreatedLayer();
        String string2 = modifyLyr = sourceEntity != null ? sourceEntity.getModifiedLayer() : targetEntity.getModifiedLayer();
        if (!createLyr.equals(modifyLyr)) {
            FontData fontData = this.compareTree.getFont().getFontData()[0];
            fontData.setStyle(1);
            entityItem.setFont(new Font((Device)Display.getCurrent(), fontData));
        }
        try {
            ArrayList<GOTProperty> propertys_s = sourceEntity != null ? sourceEntity.getPropertys() : new ArrayList<GOTProperty>();
            ArrayList<GOTProperty> propertys_t = targetEntity != null ? targetEntity.getPropertys() : new ArrayList<GOTProperty>();
            this.buildTreeInfoTable(propertys_s, propertys_t);
            List childNode = element.elements();
            for (Element nodeXML : childNode) {
                this.compareChild(nodeXML, sourceEntity, targetEntity, entityItem, innerIds, false);
            }
        }
        catch (Exception e1) {
            this.log.error((Object)"\u5355\u8282\u70b9\u5bf9\u6bd4\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
        }
        entityItem.setExpanded(true);
        this.compareTree.setSelection(entityItem);
        try {
            Map<String, String> attributes = sourceEntity != null ? sourceEntity.getAttributes() : targetEntity.getAttributes();
            this.setTipInfo(entityType.toString(), attributes);
        }
        catch (NavException navException) {}
        if (!(EntityType.Table.equals((Object)entityType) || EntityType.Form.equals((Object)entityType) || EntityType.Class.equals((Object)entityType))) {
            this.javaMethodTree.removeAll();
            return;
        }
        Object entityMethodsObject = treeItem.getData("entityMethods");
        if (entityMethodsObject == null || !(entityMethodsObject instanceof EntityMethods)) {
            EntityMethods entityMethods = new EntityMethods(sourceEntity, targetEntity, entityType);
            if (sourceEntity != null) {
                List<LayerJavaCode> sourceJavaCodes = upgradeService.getEntityJavaContent(sourceEntity, true);
                entityMethods.setSourceJavaCodes(sourceJavaCodes);
            }
            if (targetEntity != null) {
                List<LayerJavaCode> targetJavaCodes = upgradeService.getEntityJavaContent(targetEntity, false);
                entityMethods.setTargetJavaCodes(targetJavaCodes);
            }
            treeItem.setData("entityMethods", (Object)entityMethods);
        }
        this.buildJavaMethod();
    }

    private void setTreeItemStyle(TreeItem treeItem, List<Element> modifyInfos) {
        List modifyTypes = modifyInfos.stream().map(m -> ModifyType.valueOf(m.attributeValue("modifyType"))).collect(Collectors.toList());
        if (modifyTypes.contains((Object)ModifyType.InnerNode_Add) || modifyTypes.contains((Object)ModifyType.Entity_Add)) {
            treeItem.setImage(addImage);
        } else if (modifyTypes.contains((Object)ModifyType.InnerNode_Delete) || modifyTypes.contains((Object)ModifyType.Entity_Delete)) {
            treeItem.setImage(deleteImage);
        } else if (modifyTypes.contains((Object)ModifyType.InnerNode_Order)) {
            treeItem.setImage(orderImage);
        } else {
            treeItem.setImage(difImage);
        }
    }

    private void compareChild(Element nodeXML, GOTNode sourceNode, GOTNode targetNode, TreeItem parentItem, Map<String, List<Element>> innerIds, boolean showMust) throws VTDException {
        String id;
        List<Object> childNodes_t;
        String xpath = nodeXML.getName();
        ArrayList<String> ids = new ArrayList<String>();
        List<Object> childNodes_s = sourceNode != null ? sourceNode.selectNodes(xpath) : new ArrayList();
        List<Object> list = childNodes_t = targetNode != null ? targetNode.selectNodes(xpath) : new ArrayList();
        if (childNodes_s.isEmpty() && childNodes_t.isEmpty()) {
            return;
        }
        List childNodeXMLs = nodeXML.elements();
        for (GOTNode gOTNode : childNodes_s) {
            GOTNode childNode_t;
            Optional<GOTNode> findFirst;
            id = gOTNode.getId();
            if (StringUtils.isBlank((String)id)) {
                id = gOTNode.getNodeType();
                findFirst = childNodes_t.stream().filter(t -> t.getNodeType().equals(childNode_s.getNodeType())).findFirst();
            } else {
                findFirst = childNodes_t.stream().filter(t -> t.getId().equals(childNode_s.getId())).findFirst();
            }
            ids.add(id);
            GOTNode gOTNode2 = childNode_t = findFirst.isPresent() ? findFirst.get() : null;
            if (!showMust && !this.isInScope(nodeXML, gOTNode, childNode_t, innerIds, id)) continue;
            TreeItem nodeItem = new TreeItem(parentItem, 0);
            nodeItem.setImage(ComposeIMG.drawImgDef(gOTNode));
            if (innerIds.containsKey(id)) {
                List<Element> itemElements = innerIds.get(id);
                if (itemElements.stream().filter(i -> ModifyLevel.Cannot.name().equals(i.attributeValue("modifyLevel"))).findFirst().isPresent()) {
                    nodeItem.setForeground(Display.getCurrent().getSystemColor(3));
                }
                this.setTreeItemStyle(nodeItem, itemElements);
            }
            if (!gOTNode.getCreatedLayer().equals(gOTNode.getModifiedLayer())) {
                FontData fontData = this.compareTree.getFont().getFontData()[0];
                fontData.setStyle(1);
                nodeItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            String sourceName = "";
            String targetName = "";
            if (xpath.equals("FormItem")) {
                sourceName = String.valueOf(gOTNode.getAttributeValue("type")) + "::" + gOTNode.getName();
                if (childNode_t != null) {
                    targetName = String.valueOf(childNode_t.getAttributeValue("type")) + "::" + childNode_t.getName();
                }
            } else {
                sourceName = gOTNode.getName();
                String string = targetName = childNode_t != null ? childNode_t.getName() : "";
            }
            if (StringUtils.isBlank((String)sourceName)) {
                nodeItem.setText(targetName);
            } else if (StringUtils.isBlank((String)targetName)) {
                nodeItem.setText(sourceName);
            } else if (!sourceName.equals(targetName)) {
                nodeItem.setText(String.valueOf(sourceName) + " -> " + targetName);
            } else {
                nodeItem.setText(sourceName);
            }
            nodeItem.setData("id", (Object)id);
            nodeItem.setData("nodeType", (Object)gOTNode.getNodeType());
            nodeItem.setData("SourceNode", (Object)gOTNode);
            nodeItem.setData("TargetNode", (Object)childNode_t);
            if (xpath.equals("FormItem")) {
                this.compareChild(nodeXML, gOTNode, childNode_t, nodeItem, innerIds, false);
            } else {
                if (xpath.equals("MenuSub")) {
                    this.compareChild(nodeXML, gOTNode, childNode_t, nodeItem, innerIds, false);
                }
                if (xpath.equals("TableIndex")) {
                    for (Element childNodeXML : childNodeXMLs) {
                        this.compareChild(childNodeXML, gOTNode, childNode_t, nodeItem, innerIds, true);
                    }
                } else {
                    for (Element childNodeXML : childNodeXMLs) {
                        this.compareChild(childNodeXML, gOTNode, childNode_t, nodeItem, innerIds, false);
                    }
                }
            }
            nodeItem.setExpanded(true);
        }
        for (GOTNode gOTNode : childNodes_t) {
            id = gOTNode.getId();
            if (StringUtils.isBlank((String)id)) {
                id = gOTNode.getNodeType();
            }
            if (ids.contains(id) || !showMust && !this.isInScope(nodeXML, gOTNode, null, innerIds, id)) continue;
            TreeItem nodeItem = new TreeItem(parentItem, 0);
            String targetName = xpath.equals("FormItem") ? String.valueOf(gOTNode.getAttributeValue("type")) + "::" + gOTNode.getName() : gOTNode.getName();
            nodeItem.setText(targetName);
            nodeItem.setImage(ComposeIMG.drawImgDef(gOTNode));
            if (innerIds.containsKey(id)) {
                List<Element> itemElements = innerIds.get(id);
                if (itemElements.stream().filter(i -> ModifyLevel.Cannot.name().equals(i.attributeValue("modifyLevel"))).findFirst().isPresent()) {
                    nodeItem.setForeground(Display.getCurrent().getSystemColor(3));
                }
                this.setTreeItemStyle(nodeItem, itemElements);
            }
            if (!gOTNode.getCreatedLayer().equals(gOTNode.getModifiedLayer())) {
                FontData fontData = this.compareTree.getFont().getFontData()[0];
                fontData.setStyle(1);
                nodeItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            nodeItem.setData("id", (Object)id);
            nodeItem.setData("nodeType", (Object)gOTNode.getNodeType());
            nodeItem.setData("SourceNode", null);
            nodeItem.setData("TargetNode", (Object)gOTNode);
            if (xpath.equals("FormItem")) {
                this.compareChild(nodeXML, null, gOTNode, nodeItem, innerIds, false);
            } else {
                if (xpath.equals("MenuSub")) {
                    this.compareChild(nodeXML, null, gOTNode, nodeItem, innerIds, false);
                }
                if (xpath.equals("TableIndex")) {
                    for (Element childNodeXML : childNodeXMLs) {
                        this.compareChild(childNodeXML, null, gOTNode, nodeItem, innerIds, true);
                    }
                } else {
                    for (Element childNodeXML : childNodeXMLs) {
                        this.compareChild(childNodeXML, null, gOTNode, nodeItem, innerIds, false);
                    }
                }
            }
            nodeItem.setExpanded(true);
        }
    }

    private boolean isInScope(Element nodeXML, GOTNode childNode_s, GOTNode childNode_t, Map<String, List<Element>> innerIds, String id) throws VTDException {
        String xpath = nodeXML.getName();
        String type = nodeXML.attributeValue("type");
        if (StringUtils.isNotBlank((String)type) && "Default".equals(type)) {
            return true;
        }
        if (childNode_s.getChildNodeBFS(false).isEmpty()) {
            return this.IsInDisplayScope(innerIds, id);
        }
        if (this.IsInDisplayScope(innerIds, id)) {
            return true;
        }
        if (xpath.equals("FormItem")) {
            return this.hasEligibleChildNode(nodeXML, childNode_s, childNode_t, innerIds);
        }
        if (xpath.equals("MenuSub") && this.hasEligibleChildNode(nodeXML, childNode_s, childNode_t, innerIds)) {
            return true;
        }
        for (Element childNodeXML : nodeXML.elements()) {
            if (!this.hasEligibleChildNode(childNodeXML, childNode_s, childNode_t, innerIds)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEligibleChildNode(Element nodeXML, GOTNode sourceNode, GOTNode targetNode, Map<String, List<Element>> innerIds) throws VTDException {
        List childNodeXMLs;
        String id;
        List<Object> childNodes_t;
        String xpath = nodeXML.getName();
        List<Object> childNodes_s = sourceNode != null ? sourceNode.selectNodes(xpath) : new ArrayList();
        List<Object> list = childNodes_t = targetNode != null ? targetNode.selectNodes(xpath) : new ArrayList();
        if (childNodes_s.isEmpty() && childNodes_t.isEmpty()) {
            return false;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (GOTNode gOTNode : childNodes_s) {
            GOTNode childNode_t;
            Optional<GOTNode> findFirst;
            id = gOTNode.getId();
            if (gOTNode.getChildNodeBFS(false).isEmpty()) {
                if (!this.IsInDisplayScope(innerIds, id)) continue;
                return true;
            }
            if (this.IsInDisplayScope(innerIds, id)) {
                return true;
            }
            childNodeXMLs = nodeXML.elements();
            if (StringUtils.isBlank((String)id)) {
                ids.add(gOTNode.getNodeType());
                findFirst = childNodes_t.stream().filter(t -> t.getNodeType().equals(childNode_s.getNodeType())).findFirst();
            } else {
                ids.add(id);
                findFirst = childNodes_t.stream().filter(t -> t.getId().equals(id)).findFirst();
            }
            GOTNode gOTNode2 = childNode_t = findFirst.isPresent() ? findFirst.get() : null;
            if (xpath.equals("FormItem")) {
                if (!this.hasEligibleChildNode(nodeXML, gOTNode, childNode_t, innerIds)) continue;
                return true;
            }
            if (xpath.equals("MenuSub") && this.hasEligibleChildNode(nodeXML, gOTNode, childNode_t, innerIds)) {
                return true;
            }
            for (Element childNodeXML : childNodeXMLs) {
                if (!this.hasEligibleChildNode(childNodeXML, gOTNode, childNode_t, innerIds)) continue;
                return true;
            }
        }
        for (GOTNode gOTNode : childNodes_t) {
            id = gOTNode.getId();
            if (StringUtils.isBlank((String)id)) {
                id = gOTNode.getNodeType();
            }
            if (ids.contains(id)) continue;
            if (gOTNode.getChildNodeBFS(false).isEmpty()) {
                if (!this.IsInDisplayScope(innerIds, id)) continue;
                return true;
            }
            if (this.IsInDisplayScope(innerIds, id)) {
                return true;
            }
            childNodeXMLs = nodeXML.elements();
            if (xpath.equals("FormItem")) {
                if (!this.hasEligibleChildNode(nodeXML, null, gOTNode, innerIds)) continue;
                return true;
            }
            if (xpath.equals("MenuSub") && this.hasEligibleChildNode(nodeXML, null, gOTNode, innerIds)) {
                return true;
            }
            for (Element childNodeXML : childNodeXMLs) {
                if (!this.hasEligibleChildNode(childNodeXML, null, gOTNode, innerIds)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean IsInDisplayScope(Map<String, List<Element>> innerIds, String id) {
        if (innerIds.containsKey(id)) {
            List<Element> modifyInfos = innerIds.get(id);
            List modifyTypes = modifyInfos.stream().map(m -> ModifyType.valueOf(m.attributeValue("modifyType"))).collect(Collectors.toList());
            for (ModifyType modifyType : modifyTypes) {
                if (!this.IsInDisplayScope(modifyType)) continue;
                return true;
            }
            return false;
        }
        return displayScope.contains((Object)DisplayType.Same);
    }

    private boolean IsInDisplayScope(ModifyType modifyType) {
        switch (modifyType) {
            case Entity_Add: 
            case InnerNode_Add: {
                return displayScope.contains((Object)DisplayType.Add);
            }
            case Entity_Delete: 
            case InnerNode_Delete: {
                return displayScope.contains((Object)DisplayType.Delete);
            }
        }
        return displayScope.contains((Object)DisplayType.Dif);
    }

    private void setTipInfo(String entityType, Map<String, String> attributes) {
        List<String> ignore = Arrays.asList("name", "version", "nextInnerId");
        String tip = attributes.entrySet().stream().filter(entry -> !ignore.contains(entry.getKey())).map(entry -> String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue()).collect(Collectors.joining("; "));
        this.tipInfo.setText(String.valueOf(entityType) + " " + tip);
        this.tipInfo.setToolTipText(String.valueOf(entityType) + " " + tip);
    }

    private void buildJavaMethod() {
        this.javaMethodTree.removeAll();
        TreeItem[] selection = this.gotTree.getSelection();
        if (selection.length < 1) {
            return;
        }
        Object entityMethodsObject = selection[0].getData("entityMethods");
        if (entityMethodsObject == null || !(entityMethodsObject instanceof EntityMethods)) {
            return;
        }
        EntityMethods entityMethods = (EntityMethods)entityMethodsObject;
        Comparator<LayerJavaMethod> comparator = new Comparator<LayerJavaMethod>(){

            @Override
            public int compare(LayerJavaMethod o1, LayerJavaMethod o2) {
                return AnalysisResultPage.this.getLayerLevel(o1.getParent().getLayerName()) > AnalysisResultPage.this.getLayerLevel(o2.getParent().getLayerName()) ? -1 : 1;
            }
        };
        List<String> allCodes = entityMethods.getAllCodes();
        if (entityMethods.getEntityType().equals((Object)EntityType.Form)) {
            List simpleNames = allCodes.stream().filter(n -> !LayerJavaCode.JavaType.DataSource.equals((Object)entityMethods.getJavaType((String)n))).collect(Collectors.toList());
            for (String simpleName : simpleNames) {
                TreeItem classItem = new TreeItem(this.javaMethodTree, 0);
                this.doBuildJavaMethod(classItem, entityMethods, simpleName, comparator);
            }
            TreeItem formDataSourceItem = new TreeItem(this.javaMethodTree, 0);
            formDataSourceItem.setText("datasource");
            formDataSourceItem.setImage(Images.getIcon("layerUpgrade/Package.png"));
            simpleNames = allCodes.stream().filter(n -> LayerJavaCode.JavaType.DataSource.equals((Object)entityMethods.getJavaType((String)n))).collect(Collectors.toList());
            for (String simpleName : simpleNames) {
                TreeItem classItem = new TreeItem(formDataSourceItem, 0);
                this.doBuildJavaMethod(classItem, entityMethods, simpleName, comparator);
            }
            formDataSourceItem.setExpanded(true);
        } else {
            for (String simpleName : allCodes) {
                TreeItem classItem = new TreeItem(this.javaMethodTree, 0);
                this.doBuildJavaMethod(classItem, entityMethods, simpleName, comparator);
            }
        }
    }

    private void doBuildJavaMethod(TreeItem classItem, EntityMethods entityMethods, String simpleName, Comparator<LayerJavaMethod> comparator) {
        classItem.setText(simpleName);
        classItem.setImage(Images.getIcon("layerUpgrade/Java.png"));
        Map<String, List<LayerJavaMethod>> sourceMethods = entityMethods.getSourceMethods(simpleName);
        Map<String, List<LayerJavaMethod>> targetMethods = entityMethods.getTargetMethods(simpleName);
        HashSet<String> allSignatures = new HashSet<String>(sourceMethods.keySet());
        allSignatures.addAll(targetMethods.keySet());
        List signatures = allSignatures.stream().sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList());
        for (String signature : signatures) {
            LayerJavaMethod sourceMethod = null;
            LayerJavaMethod originMethod = null;
            LayerJavaMethod targetMethod = null;
            int modifiers = 0;
            Type returnType = null;
            boolean promote = false;
            List<LayerJavaMethod> sourceMethodList = sourceMethods.get(signature);
            if (sourceMethodList != null && !sourceMethodList.isEmpty()) {
                sourceMethodList.sort(comparator);
                sourceMethod = sourceMethodList.get(0);
                if (sourceMethod.getParent().getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
                    if (sourceMethodList.size() > 1) {
                        promote = true;
                        originMethod = sourceMethodList.get(1);
                        modifiers = originMethod.getMethodDeclaration().getModifiers();
                        returnType = originMethod.getMethodDeclaration().getReturnType2();
                    } else {
                        modifiers = sourceMethod.getMethodDeclaration().getModifiers();
                        returnType = sourceMethod.getMethodDeclaration().getReturnType2();
                    }
                } else {
                    sourceMethod = originMethod = sourceMethodList.get(0);
                    modifiers = sourceMethod.getMethodDeclaration().getModifiers();
                    returnType = sourceMethod.getMethodDeclaration().getReturnType2();
                }
            }
            if (targetMethods.containsKey(signature)) {
                List<LayerJavaMethod> targetMethodList = targetMethods.get(signature);
                targetMethodList.sort(comparator);
                if (!targetMethodList.isEmpty()) {
                    targetMethod = targetMethodList.get(0);
                    if (sourceMethodList == null || sourceMethodList.isEmpty()) {
                        modifiers = targetMethod.getMethodDeclaration().getModifiers();
                        returnType = targetMethod.getMethodDeclaration().getReturnType2();
                    }
                }
            }
            if (this.showPromote.getSelection() && !promote) continue;
            Image methodImg = null;
            if (Modifier.isPublic((int)modifiers)) {
                if (!this.showPublic.getSelection()) continue;
                methodImg = promote ? Images.getIcon("layerUpgrade/Public_Override.png") : publicMethod;
            } else if (Modifier.isProtected((int)modifiers)) {
                if (!this.showProtect.getSelection()) continue;
                methodImg = promote ? Images.getIcon("layerUpgrade/Protected_Override.png") : protectMethod;
            } else if (Modifier.isPrivate((int)modifiers)) {
                if (!this.showPrivate.getSelection()) continue;
                methodImg = privateMethod;
            } else if (Modifier.isDefault((int)modifiers)) {
                if (!this.showDefault.getSelection()) continue;
                methodImg = defaultMethod;
            }
            TreeItem methodItem = new TreeItem(classItem, 0);
            methodItem.setImage(methodImg);
            if (promote) {
                String o2;
                String o1 = originMethod != null ? originMethod.getContent() : "";
                String string = o2 = targetMethod != null ? targetMethod.getContent() : "";
                if (!o1.equals(o2)) {
                    FontData fontData = methodItem.getFont().getFontData()[0];
                    fontData.setStyle(1);
                    methodItem.setFont(new Font((Device)this.shell.getDisplay(), fontData));
                    methodItem.setForeground(this.shell.getDisplay().getSystemColor(9));
                }
            }
            methodItem.setText(String.valueOf(signature) + " : " + returnType);
            methodItem.setData("sourceMethod", (Object)(sourceMethod != null ? sourceMethod.getContent() : ""));
            methodItem.setData("originMethod", (Object)(originMethod != null ? originMethod.getContent() : ""));
            methodItem.setData("targetMethod", (Object)(targetMethod != null ? targetMethod.getContent() : ""));
            String javaPackagePath = targetMethod != null ? targetMethod.getParent().getJavaPackagePath() : (sourceMethod != null ? sourceMethod.getParent().getJavaPackagePath() : originMethod.getParent().getJavaPackagePath());
            methodItem.setData("javaPackagePath", (Object)(String.valueOf(javaPackagePath) + "." + signature));
        }
        classItem.setExpanded(true);
    }

    private int getLayerLevel(String layerName) {
        switch (layerName) {
            case "sys": {
                return 1;
            }
            case "obj": {
                return 2;
            }
            case "iny": {
                return 3;
            }
            case "ent": {
                return 4;
            }
            case "app": {
                return 5;
            }
            case "plg": {
                return 6;
            }
            case "ext": {
                return 7;
            }
        }
        return 0;
    }

    private void buildTreeInfoTable(List<GOTProperty> propertys_s, List<GOTProperty> propertys_t) throws VTDException {
        TreeItem treeItem;
        String name;
        Color red = this.shell.getDisplay().getSystemColor(3);
        FontData fontData = this.propertyInfoTree.getFont().getFontData()[0];
        fontData.setStyle(1);
        Font bold = new Font((Device)Display.getCurrent(), fontData);
        this.propertyInfoTree.removeAll();
        ArrayList<String> pNames = new ArrayList<String>();
        for (GOTProperty property_s : propertys_s) {
            String refInnerId_t;
            name = property_s.getName();
            if (ignoreAnalysisPropertys.contains(name)) continue;
            pNames.add(name);
            treeItem = new TreeItem(this.propertyInfoTree, 0);
            treeItem.setText(name);
            treeItem.setText(1, StringUtils.isBlank((String)property_s.getValue()) ? "" : property_s.getValue());
            Optional<GOTProperty> findFirst = propertys_t.stream().filter(p -> {
                try {
                    return p.getName().equals(name);
                }
                catch (NavException navException) {
                    return false;
                }
            }).findFirst();
            GOTProperty property_t = null;
            if (findFirst.isPresent()) {
                property_t = findFirst.get();
                treeItem.setText(2, StringUtils.isBlank((String)property_t.getValue()) ? "" : property_t.getValue());
            }
            if (!treeItem.getText(1).equals(treeItem.getText(2))) {
                treeItem.setForeground(red);
                treeItem.setFont(bold);
            }
            String innerId_s = property_s.getInnerId();
            String refEntityId_s = property_s.getRefEntityId();
            String refInnerId_s = property_s.getRefInnerId();
            String innerId_t = property_t != null ? property_t.getInnerId() : "";
            String refEntityId_t = property_t != null ? property_t.getRefEntityId() : "";
            String string = refInnerId_t = property_t != null ? property_t.getRefInnerId() : "";
            if (StringUtils.isNotBlank((String)innerId_s) || StringUtils.isNotBlank((String)innerId_t)) {
                TreeItem innerIdItem = new TreeItem(treeItem, 0);
                innerId_s = innerId_s == null ? "" : innerId_s;
                innerId_t = innerId_t == null ? "" : innerId_t;
                innerIdItem.setText("innerId");
                innerIdItem.setText(1, innerId_s);
                innerIdItem.setText(2, innerId_t);
                if (!innerId_s.equals(innerId_t)) {
                    innerIdItem.setForeground(red);
                    treeItem.setFont(bold);
                }
            }
            if (StringUtils.isNotBlank((String)refEntityId_s) || StringUtils.isNotBlank((String)refEntityId_t)) {
                TreeItem refEntityIdItem = new TreeItem(treeItem, 0);
                refEntityId_s = refEntityId_s == null ? "" : refEntityId_s;
                refEntityId_t = refEntityId_t == null ? "" : refEntityId_t;
                refEntityIdItem.setText("refEntityId");
                refEntityIdItem.setText(1, refEntityId_s);
                refEntityIdItem.setText(2, refEntityId_t);
                if (!refEntityId_s.equals(refEntityId_t)) {
                    refEntityIdItem.setForeground(red);
                    treeItem.setFont(bold);
                }
            }
            if (!StringUtils.isNotBlank((String)refInnerId_s) && !StringUtils.isNotBlank((String)refInnerId_t)) continue;
            TreeItem refInnerIdItem = new TreeItem(treeItem, 0);
            refInnerIdItem.setText("refInnerId");
            refInnerIdItem.setText(1, refInnerId_s);
            refInnerIdItem.setText(2, refInnerId_t);
            if (refInnerId_s.equals(refInnerId_t)) continue;
            refInnerIdItem.setForeground(red);
            treeItem.setFont(bold);
        }
        for (GOTProperty property_t : propertys_t) {
            String refInnerId_t;
            name = property_t.getName();
            if (ignoreAnalysisPropertys.contains(name) || pNames.contains(name)) continue;
            treeItem = new TreeItem(this.propertyInfoTree, 0);
            treeItem.setText(name);
            treeItem.setText(2, StringUtils.isBlank((String)property_t.getValue()) ? "" : property_t.getValue());
            String innerId_t = property_t != null ? property_t.getInnerId() : "";
            String refEntityId_t = property_t != null ? property_t.getRefEntityId() : "";
            String string = refInnerId_t = property_t != null ? property_t.getRefInnerId() : "";
            if (StringUtils.isNotBlank((String)innerId_t)) {
                TreeItem innerIdItem = new TreeItem(treeItem, 0);
                innerIdItem.setText("innerId");
                innerIdItem.setText(2, innerId_t);
            }
            if (StringUtils.isNotBlank((String)refEntityId_t)) {
                TreeItem refEntityIdItem = new TreeItem(treeItem, 0);
                refEntityIdItem.setText("refEntityId");
                refEntityIdItem.setText(2, refEntityId_t);
            }
            if (!StringUtils.isNotBlank((String)refInnerId_t)) continue;
            TreeItem refInnerIdItem = new TreeItem(treeItem, 0);
            refInnerIdItem.setText("refInnerId");
            refInnerIdItem.setText(2, refInnerId_t);
        }
    }

    private void initGOTTree(Element element, TreeItem parentTreeItem) {
        TreeItem treeitem;
        if (parentTreeItem == null) {
            this.gotTree.removeAll();
            treeitem = new TreeItem(this.gotTree, 0);
        } else {
            treeitem = new TreeItem(parentTreeItem, 0);
        }
        treeitem.setText(element.getName());
        treeitem.setData((Object)element);
        treeitem.setImage(Images.getIcon(String.format("%s.png", element.getName())));
        List elements = element.elements();
        for (Element childElement : elements) {
            this.initGOTTree(childElement, treeitem);
        }
    }

    private void analysis() {
        final Map<String, SolutionLayerInfo> solutionInfos = LayerChainPage.getSolutions();
        final Map<String, PedestalLayerInfo> pedestalInfos = LayerChainPage.getPedestals();
        try {
            this.analysisResult_Cache = new ArrayList<Element>();
            this.allEntitys = new HashMap<EntityType, Map<String, GOTEntity>>();
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.shell);
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                /*
                 * Unable to fully structure code
                 */
                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    solutionDownloads = solutionInfos.values().stream().filter((Predicate<SolutionLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Z)()).collect(Collectors.toList());
                    pluginDownloads = solutionInfos.values().stream().flatMap((Function<SolutionLayerInfo, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Ljava/util/stream/Stream;)()).filter((Predicate<SolutionPluginInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$2(gongqi.gdt.designer.utils.SolutionPluginInfo ), (Lgongqi/gdt/designer/utils/SolutionPluginInfo;)Z)()).collect(Collectors.toList());
                    monitor.beginTask("", solutionDownloads.size() + pluginDownloads.size() + 1);
                    monitor.setTaskName("\u30101/3\u3011\u6b63\u5728\u52a0\u8f7d\u5c42\u6587\u4ef6...");
                    monitor.subTask("\u6b63\u5728\u4e0b\u8f7d\u5e95\u5ea7");
                    baseUrl = MarketUtil.baseUrl;
                    cookie = MarketUtil.getCookie();
                    for (PedestalLayerInfo pedestalInfo : pedestalInfos.values()) {
                        targetUpdateFile = pedestalInfo.getUpdateFile(pedestalInfo.getCurrentVersion());
                        if (pedestalInfo.isOnline() != null && pedestalInfo.isOnline().booleanValue() && !targetUpdateFile.exists()) {
                            if (!targetUpdateFile.getParentFile().exists()) {
                                targetUpdateFile.getParentFile().mkdirs();
                            }
                            if (pedestalInfo.getCurrentVersion().equals(pedestalInfo.getTargetVersion())) {
                                try {
                                    basePath = ProjectConstants.getBasePath();
                                    if (pedestalInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                                        updateFile = new File(basePath, String.format("Project/Server/GongqiERP/WEB-INF/layers/layer_%s.lyr", new Object[]{pedestalInfo.getLayerId()}));
                                        FileUtils.copyFile((File)updateFile, (File)targetUpdateFile);
                                    }
                                    if (!pedestalInfo.isEmptyLayer()) {
                                        updateFile = new File(basePath, String.format("Project/Server/GongqiERP/WEB-INF/layers/%s", new Object[]{pedestalInfo.getLayerId()}));
                                        FileUtils.copyDirectory((File)updateFile, (File)targetUpdateFile);
                                    }
                                    if (targetUpdateFile.exists()) {
                                        FileUtils.deleteDirectory((File)targetUpdateFile);
                                    }
                                    targetUpdateFile.mkdirs();
                                }
                                catch (Exception e) {
                                    AnalysisResultPage.access$38(AnalysisResultPage.this).error((Object)"\u590d\u5236\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                                    throw new RuntimeException("\u590d\u5236\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                                }
                            } else {
                                downloadUrl = pedestalInfo.getDownloadUrl();
                                split = downloadUrl.split("/");
                                filename = split[split.length - 1];
                                if (!filename.endsWith(".lyr") && !filename.endsWith(".lyrs")) {
                                    return;
                                }
                                try {
                                    url = new URL(downloadUrl);
                                    connection = url.openConnection();
                                    connection.addRequestProperty("Cookie", cookie);
                                    tempDirectory = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                    tempDirectory.mkdirs();
                                    layerFile = new File(tempDirectory, filename);
                                    layerFile.createNewFile();
                                    var16_31 = null;
                                    var17_33 = null;
                                    try {
                                        inputStream = connection.getInputStream();
                                        try {
                                            outputStream = new FileOutputStream(layerFile);
                                            try {
                                                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                            }
                                            finally {
                                                if (outputStream != null) {
                                                    outputStream.close();
                                                }
                                            }
                                            ** if (inputStream == null) goto lbl-1000
                                        }
                                        catch (Throwable var17_34) {
                                            if (var16_31 == null) {
                                                var16_31 = var17_34;
                                            } else if (var16_31 != var17_34) {
                                                var16_31.addSuppressed(var17_34);
                                            }
                                            if (inputStream != null) {
                                                inputStream.close();
                                            }
                                            throw var16_31;
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            inputStream.close();
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                    }
                                    catch (Throwable var17_35) {
                                        if (var16_31 == null) {
                                            var16_31 = var17_35;
                                        } else if (var16_31 != var17_35) {
                                            var16_31.addSuppressed(var17_35);
                                        }
                                        throw var16_31;
                                    }
                                    objLyr = null;
                                    tempDir = null;
                                    if (layerFile.getName().endsWith(".lyrs")) {
                                        tempDir = FileUtils.mkTempDir();
                                        ZipUtil.unZipFiles((String)layerFile.getAbsolutePath(), (String)tempDir.getAbsolutePath());
                                        objLyr = tempDir.listFiles(new FileFilter(){

                                            @Override
                                            public boolean accept(File file) {
                                                return file.getName().contains("obj") && file.getName().endsWith(".lyr");
                                            }
                                        })[0];
                                    } else if (layerFile.getName().contains("obj") && layerFile.getName().endsWith(".lyr")) {
                                        objLyr = layerFile;
                                    } else {
                                        throw new RuntimeException("\u65e0\u6548\u7684\u5c42\u6587\u4ef6");
                                    }
                                    FileUtils.copyFile((File)objLyr, (File)targetUpdateFile);
                                }
                                catch (IOException e) {
                                    AnalysisResultPage.access$38(AnalysisResultPage.this).error((Object)"\u4e0b\u8f7d\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                                    throw new RuntimeException("\u4e0b\u8f7d\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                                }
                            }
                        }
                        monitor.worked(1);
                    }
                    for (SolutionLayerInfo solutionInfo : solutionDownloads) {
                        block121: {
                            monitor.setTaskName("\u30101/3\u3011\u6b63\u5728\u52a0\u8f7d\u5c42\u6587\u4ef6...");
                            monitor.subTask(String.format("\u6b63\u5728\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011...", new Object[]{solutionInfo.getSolutionName()}));
                            if (solutionInfo.getCurrentVersion().equals(solutionInfo.getTargetVersion())) {
                                layersRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
                                appFile = new File((File)layersRoot, String.format("app/%s%s", new Object[]{solutionInfo.getSolutionId(), ".app"}));
                                if (appFile.exists() && appFile.exists()) {
                                    try {
                                        FileUtils.copyFile((File)appFile, (File)solutionInfo.getUpdateFile(solutionInfo.getTargetVersion()));
                                    }
                                    catch (IOException e) {
                                        AnalysisResultPage.access$38(AnalysisResultPage.this).error((Object)"\u590d\u5236\u5e94\u7528\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                                        throw new RuntimeException("\u590d\u5236\u5e94\u7528\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                                    }
                                }
                                throw new RuntimeException("\u672a\u627e\u5230\u5e94\u7528\u6587\u4ef6" + appFile.getAbsolutePath());
                            }
                            try {
                                layersRoot = null;
                                appFile = null;
                                try {
                                    httpClient = HttpClients.createDefault();
                                    try {
                                        httpPost = new HttpPost(String.format("%s/appuser/download/source?appUserId=%s&versionId=%s", new Object[]{baseUrl, solutionInfo.getAppUserId(), solutionInfo.getTargetVersion()}));
                                        httpPost.addHeader("Cookie", cookie);
                                        var12_22 = null;
                                        var13_26 = null;
                                        try {
                                            response = httpClient.execute((HttpUriRequest)httpPost);
                                            try {
                                                if (response.getStatusLine().getStatusCode() != 200) break block121;
                                                entity = response.getEntity();
                                                responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                                                if (responseResult.getInteger("errcode") != 0) {
                                                    throw new RuntimeException(responseResult.getString("errmsg"));
                                                }
                                                url = new URL(responseResult.getString("content"));
                                                connection = url.openConnection();
                                                connection.addRequestProperty("Cookie", cookie);
                                                appFile = solutionInfo.getUpdateFile(solutionInfo.getTargetVersion());
                                                appFile.createNewFile();
                                                var20_38 = null;
                                                var21_41 = null;
                                                try {
                                                    inputStream = connection.getInputStream();
                                                    try {
                                                        outputStream = new FileOutputStream(appFile);
                                                        try {
                                                            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                                        }
                                                        finally {
                                                            if (outputStream != null) {
                                                                outputStream.close();
                                                            }
                                                        }
                                                        ** if (inputStream == null) goto lbl-1000
                                                    }
                                                    catch (Throwable var21_42) {
                                                        if (var20_38 == null) {
                                                            var20_38 = var21_42;
                                                        } else if (var20_38 != var21_42) {
                                                            var20_38.addSuppressed(var21_42);
                                                        }
                                                        if (inputStream != null) {
                                                            inputStream.close();
                                                        }
                                                        throw var20_38;
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        inputStream.close();
                                                    }
lbl-1000:
                                                    // 2 sources

                                                    {
                                                    }
                                                }
                                                catch (Throwable var21_43) {
                                                    if (var20_38 == null) {
                                                        var20_38 = var21_43;
                                                    } else if (var20_38 != var21_43) {
                                                        var20_38.addSuppressed(var21_43);
                                                    }
                                                    throw var20_38;
                                                }
                                            }
                                            finally {
                                                if (response != null) {
                                                    response.close();
                                                }
                                            }
                                        }
                                        catch (Throwable var13_27) {
                                            if (var12_22 == null) {
                                                var12_22 = var13_27;
                                            } else if (var12_22 != var13_27) {
                                                var12_22.addSuppressed(var13_27);
                                            }
                                            throw var12_22;
                                        }
                                    }
                                    finally {
                                        if (httpClient != null) {
                                            httpClient.close();
                                        }
                                    }
                                }
                                catch (Throwable appFile) {
                                    if (layersRoot == null) {
                                        layersRoot = appFile;
                                    } else if (layersRoot != appFile) {
                                        layersRoot.addSuppressed(appFile);
                                    }
                                    throw layersRoot;
                                }
                            }
                            catch (IOException e) {
                                AnalysisResultPage.access$38(AnalysisResultPage.this).error((Object)String.format("\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{solutionInfo.getSolutionId()}), (Throwable)e);
                                throw new RuntimeException(String.format("\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{solutionInfo.getSolutionId()}), e);
                            }
                        }
                        monitor.worked(1);
                    }
                    for (SolutionPluginInfo pluginInfo : pluginDownloads) {
                        block123: {
                            monitor.setTaskName("\u30101/3\u3011\u6b63\u5728\u52a0\u8f7d\u5c42\u6587\u4ef6...");
                            monitor.subTask(String.format("\u6b63\u5728\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011...", new Object[]{pluginInfo.getPluginId()}));
                            if (pluginInfo.getCurrentVersion().equals(pluginInfo.getTargetVersion())) {
                                layersRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
                                plgFile = new File((File)layersRoot, String.format("plg/%s/%s%s", new Object[]{pluginInfo.getSolutionLayerInfo().getSolutionId(), pluginInfo.getPluginId(), ".plugin"}));
                                if (plgFile.exists() && plgFile.exists()) {
                                    tempDirectory = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                    tempDirectory.mkdirs();
                                    try {
                                        FileUtils.copyFile((File)plgFile, (File)pluginInfo.getUpdateFile(pluginInfo.getTargetVersion()));
                                    }
                                    catch (IOException e) {
                                        AnalysisResultPage.access$38(AnalysisResultPage.this).error((Object)"\u590d\u5236\u63d2\u4ef6\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                                        throw new RuntimeException("\u590d\u5236\u63d2\u4ef6\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                                    }
                                }
                                throw new RuntimeException("\u672a\u627e\u5230\u5e94\u7528\u6587\u4ef6" + plgFile.getAbsolutePath());
                            }
                            try {
                                layersRoot = null;
                                plgFile = null;
                                try {
                                    httpClient = HttpClients.createDefault();
                                    try {
                                        httpPost = new HttpPost(String.format("%s/plugin/download/version?pluginId=%s&versionId=%s", new Object[]{baseUrl, pluginInfo.getDownloadPluginId(), pluginInfo.getTargetVersion()}));
                                        httpPost.addHeader("Cookie", cookie);
                                        var12_22 = null;
                                        var13_26 = null;
                                        try {
                                            response = httpClient.execute((HttpUriRequest)httpPost);
                                            try {
                                                if (response.getStatusLine().getStatusCode() != 200) break block123;
                                                entity = response.getEntity();
                                                responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                                                if (responseResult.getInteger("errcode") != 0) {
                                                    throw new RuntimeException(responseResult.getString("errmsg"));
                                                }
                                                url = new URL(responseResult.getString("content"));
                                                connection = url.openConnection();
                                                connection.addRequestProperty("Cookie", cookie);
                                                pluginFile = pluginInfo.getUpdateFile(pluginInfo.getTargetVersion());
                                                pluginFile.createNewFile();
                                                var20_38 = null;
                                                var21_41 = null;
                                                try {
                                                    inputStream = connection.getInputStream();
                                                    try {
                                                        outputStream = new FileOutputStream(pluginFile);
                                                        try {
                                                            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                                        }
                                                        finally {
                                                            if (outputStream != null) {
                                                                outputStream.close();
                                                            }
                                                        }
                                                        ** if (inputStream == null) goto lbl-1000
                                                    }
                                                    catch (Throwable var21_44) {
                                                        if (var20_38 == null) {
                                                            var20_38 = var21_44;
                                                        } else if (var20_38 != var21_44) {
                                                            var20_38.addSuppressed(var21_44);
                                                        }
                                                        if (inputStream != null) {
                                                            inputStream.close();
                                                        }
                                                        throw var20_38;
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        inputStream.close();
                                                    }
lbl-1000:
                                                    // 2 sources

                                                    {
                                                    }
                                                }
                                                catch (Throwable var21_45) {
                                                    if (var20_38 == null) {
                                                        var20_38 = var21_45;
                                                    } else if (var20_38 != var21_45) {
                                                        var20_38.addSuppressed(var21_45);
                                                    }
                                                    throw var20_38;
                                                }
                                            }
                                            finally {
                                                if (response != null) {
                                                    response.close();
                                                }
                                            }
                                        }
                                        catch (Throwable var13_28) {
                                            if (var12_22 == null) {
                                                var12_22 = var13_28;
                                            } else if (var12_22 != var13_28) {
                                                var12_22.addSuppressed(var13_28);
                                            }
                                            throw var12_22;
                                        }
                                    }
                                    finally {
                                        if (httpClient != null) {
                                            httpClient.close();
                                        }
                                    }
                                }
                                catch (Throwable plgFile) {
                                    if (layersRoot == null) {
                                        layersRoot = plgFile;
                                    } else if (layersRoot != plgFile) {
                                        layersRoot.addSuppressed(plgFile);
                                    }
                                    throw layersRoot;
                                }
                            }
                            catch (IOException e) {
                                AnalysisResultPage.access$38(AnalysisResultPage.this).error((Object)String.format("\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{pluginInfo.getPluginId()}), (Throwable)e);
                                throw new RuntimeException(String.format("\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{pluginInfo.getPluginId()}), e);
                            }
                        }
                        monitor.worked(1);
                    }
                    solutionPluginFiles = solutionInfos.values().stream().flatMap((Function<SolutionLayerInfo, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Ljava/util/stream/Stream;)()).filter((Predicate<SolutionPluginInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$4(gongqi.gdt.designer.utils.SolutionPluginInfo ), (Lgongqi/gdt/designer/utils/SolutionPluginInfo;)Z)()).map((Function<SolutionPluginInfo, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$5(gongqi.gdt.designer.utils.SolutionPluginInfo ), (Lgongqi/gdt/designer/utils/SolutionPluginInfo;)Ljava/io/File;)()).collect(Collectors.toList());
                    solutionFiles = solutionInfos.values().stream().filter((Predicate<SolutionLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$6(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Z)()).filter((Predicate<SolutionLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$7(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Z)()).map((Function<SolutionLayerInfo, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$8(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Ljava/io/File;)()).collect(Collectors.toList());
                    layersFile = pedestalInfos.values().stream().filter((Predicate<PedestalLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$9(gongqi.gdt.designer.utils.PedestalLayerInfo ), (Lgongqi/gdt/designer/utils/PedestalLayerInfo;)Z)()).map((Function<PedestalLayerInfo, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$10(gongqi.gdt.designer.utils.PedestalLayerInfo ), (Lgongqi/gdt/designer/utils/PedestalLayerInfo;)Ljava/io/File;)()).collect(Collectors.toList());
                    monitor.done();
                    try {
                        monitor.beginTask("", 3);
                        monitor.setTaskName("\u30102/3\u3011\u6b63\u5728\u521d\u59cb\u5316\u5c42\u6a21\u578b...");
                        AnalysisResultPage.access$49().initGOTModel(layersFile, solutionFiles, solutionPluginFiles, new ArrayList<File>(), monitor);
                        monitor.done();
                        AnalysisResultPage.access$49().analysis(new ProgressMonitor(){

                            @Override
                            public void worked(int work, String message) {
                                monitor.subTask(message);
                                monitor.worked(1);
                            }

                            @Override
                            public void reportResult(final Element entityResult) {
                                AnalysisResultPage.this.shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        AnalysisResultPage.this.analysisResult_Cache.add(entityResult);
                                    }
                                });
                            }

                            @Override
                            public void done(final Throwable e) {
                                AnalysisResultPage.this.shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (e == null) {
                                            MessageDialog.openInformation((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)"\u5206\u6790\u5b8c\u6210");
                                            Element entityModifys = (Element)AnalysisResultPage.this.gotTree.getItem(0).getData();
                                            List cannotItems = entityModifys.selectNodes(String.format(".//Item[@modifyLevel='%s']", new Object[]{ModifyLevel.Cannot}));
                                            AnalysisResultPage.this.analysis_Finish = cannotItems.isEmpty();
                                            AnalysisResultPage.this.updateButtonStatus();
                                        } else {
                                            MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)String.format("\u5206\u6790\u9519\u8bef\uff1a%s", e.getLocalizedMessage()));
                                            AnalysisResultPage.this.log.error((Object)"\u5347\u7ea7\u5185\u5bb9\u5206\u6790\u9519\u8bef", e);
                                        }
                                    }
                                });
                            }

                            @Override
                            public void beginTask(int totalWork) {
                                monitor.beginTask("", totalWork);
                            }

                            @Override
                            public void setTaskName(String name) {
                                monitor.setTaskName(name);
                            }
                        });
                    }
                    catch (VTDException | IOException e) {
                        AnalysisResultPage.access$38(AnalysisResultPage.this).error((Object)"\u5347\u7ea7\u5185\u5bb9\u5206\u6790\u7a0b\u5e8f\u5f02\u5e38", e);
                    }
                }

                private static /* synthetic */ boolean lambda$0(SolutionLayerInfo solutionInfo) {
                    return solutionInfo.isOnline() != null && solutionInfo.isOnline() != false && !solutionInfo.getUpdateFile(solutionInfo.getTargetVersion()).exists();
                }

                private static /* synthetic */ Stream lambda$1(SolutionLayerInfo solutionInfo) {
                    return solutionInfo.getPluginInfos().stream();
                }

                private static /* synthetic */ boolean lambda$2(SolutionPluginInfo pluginInfo) {
                    return pluginInfo.isOnline() != null && pluginInfo.isOnline() != false && !pluginInfo.getUpdateFile(pluginInfo.getTargetVersion()).exists();
                }

                private static /* synthetic */ Stream lambda$3(SolutionLayerInfo solutionInfo) {
                    return solutionInfo.getPluginInfos().stream();
                }

                private static /* synthetic */ boolean lambda$4(SolutionPluginInfo p) {
                    return p.isOnline() != null;
                }

                private static /* synthetic */ File lambda$5(SolutionPluginInfo p) {
                    return p.getUpdateFile(p.getTargetVersion());
                }

                private static /* synthetic */ boolean lambda$6(SolutionLayerInfo a) {
                    return a.isOnline() != null;
                }

                private static /* synthetic */ boolean lambda$7(SolutionLayerInfo a) {
                    return a.getTargetVersion() != null;
                }

                private static /* synthetic */ File lambda$8(SolutionLayerInfo a) {
                    return a.getUpdateFile(a.getTargetVersion());
                }

                private static /* synthetic */ boolean lambda$9(PedestalLayerInfo a) {
                    return a.isOnline() != null;
                }

                private static /* synthetic */ File lambda$10(PedestalLayerInfo a) {
                    return a.getUpdateFile(a.getTargetVersion());
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.log.error((Object)"\u5347\u7ea7\u5185\u5bb9\u5206\u6790\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
            if (e instanceof InvocationTargetException) {
                MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)("\u5185\u5bb9\u5206\u6790\u9519\u8bef\uff1a" + e.getCause().getMessage()));
            }
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)("\u5185\u5bb9\u5206\u6790\u9519\u8bef\uff1a" + e.getMessage()));
        }
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType entityType = entityTypeArray[n2];
            this.allEntitys.put(entityType, upgradeService.getSourceEntitys(entityType));
            ++n2;
        }
        this.buildGOTTree();
    }

    private void buildGOTTree() {
        this.gotTree.removeAll();
        this.initGOTTree(this.newEmptyGOTElement(), null);
        this.gotTree.getItem(0).setExpanded(true);
        this.gotTree.getItem(0).getItem(0).setExpanded(true);
        List<String> pedestals = Arrays.asList("sys".toString(), "obj".toString(), "iny".toString(), "ent".toString());
        List<SolutionLayerInfo> solutions = this.layerChainConfig.getSolutions();
        List solutionIds = solutions.stream().map(s -> s.getSolutionId()).collect(Collectors.toList());
        List pluginIds = solutions.stream().flatMap(s -> s.getPluginInfos().stream()).map(p -> p.getPluginId()).collect(Collectors.toList());
        Map<EntityType, List<Element>> modifyInfos = this.analysisResult_Cache.stream().collect(Collectors.groupingBy(e -> EntityType.valueOf((String)e.getName())));
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType entityType = entityTypeArray[n2];
            List<Object> modifyInfo = new ArrayList();
            Collection<Object> sourceEntitys = new ArrayList();
            if (this.layerChainConfig.isShowSame() && !this.layerChainConfig.isShowConflict() && !this.layerChainConfig.isShowPromote() && this.allEntitys.containsKey(entityType)) {
                sourceEntitys = this.allEntitys.get(entityType).values();
            }
            List<Object> modifyInfoList = new ArrayList();
            if (modifyInfos.containsKey(entityType)) {
                modifyInfo = modifyInfos.get(entityType);
                List entityIds = modifyInfo.stream().map(e -> e.attributeValue("id")).collect(Collectors.toList());
                sourceEntitys = sourceEntitys.stream().filter(gotNode -> !entityIds.contains(gotNode.getId())).collect(Collectors.toList());
                modifyInfoList = modifyInfo.stream().filter(m -> {
                    List elements = m.elements();
                    if (this.layerChainConfig.isShowConflict() && !elements.stream().filter(e -> ModifyLevel.Cannot.name().equals(e.attributeValue("modifyLevel"))).findFirst().isPresent()) {
                        return false;
                    }
                    if (!this.layerChainConfig.isShowAdd() && elements.stream().filter(e -> ModifyType.Entity_Add.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                        return false;
                    }
                    if (!this.layerChainConfig.isShowDelete() && elements.stream().filter(e -> ModifyType.Entity_Delete.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                        return false;
                    }
                    return this.layerChainConfig.isShowDif() || elements.stream().filter(e -> ModifyType.Entity_Add.name().equals(e.attributeValue("modifyType")) || ModifyType.Entity_Delete.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent();
                }).map(m -> {
                    String entityId = m.attributeValue("id");
                    GOTEntity sourceEntity = upgradeService.getSourceEntity(entityType, entityId);
                    if (sourceEntity != null) {
                        return sourceEntity;
                    }
                    return upgradeService.getTargetEntity(entityType, entityId);
                }).filter(gotNode -> {
                    boolean promote;
                    boolean bl = promote = gotNode != null && !gotNode.getModifiedLayer().equals(gotNode.getCreatedLayer());
                    return !this.layerChainConfig.isShowPromote() || promote;
                }).collect(Collectors.toList());
            }
            List gotNodes = Stream.concat(sourceEntitys.stream(), modifyInfoList.stream()).collect(Collectors.toMap(GOTNode::getId, item -> item, (existing, replacement) -> existing)).values().stream().sorted(Comparator.comparing(GOTNode::getName)).collect(Collectors.toList());
            TreeItem entitysTreeItem = this.getEntitysTreeItem(entityType);
            HashMap<String, TreeItem> idTrees = new HashMap<String, TreeItem>();
            for (GOTEntity gOTEntity : gotNodes) {
                String entityId = gOTEntity.getId();
                if (LayerChainConfig.DisplayScope.Pedestal.equals((Object)this.layerChainConfig.getDisplayScope())) {
                    if (!pedestals.contains(gOTEntity.getModifiedLayer())) {
                        continue;
                    }
                } else if (LayerChainConfig.DisplayScope.Solution.equals((Object)this.layerChainConfig.getDisplayScope())) {
                    String id;
                    if (pedestals.contains(gOTEntity.getModifiedLayer()) || StringUtils.isBlank((String)(id = gOTEntity.getId()))) continue;
                    if (id.contains(".")) {
                        id = id.substring(0, id.lastIndexOf("."));
                    }
                    if (!solutionIds.contains(id) && !pluginIds.contains(id)) continue;
                }
                TreeItem entityTreeItem = new TreeItem(entitysTreeItem, 0);
                entityTreeItem.setText(gOTEntity.getName());
                entityTreeItem.setData("entityId", (Object)entityId);
                entityTreeItem.setImage(ComposeIMG.drawImgDef(gOTEntity));
                idTrees.put(entityId, entityTreeItem);
            }
            for (Element element : modifyInfo) {
                boolean promote;
                Object element22;
                Element result;
                Object data;
                TreeItem treeItem = (TreeItem)idTrees.get(element.attributeValue("id"));
                if (treeItem == null) continue;
                GOTEntity gotNode3 = upgradeService.getSourceEntity(entityType, element.attributeValue("id"));
                if (gotNode3 == null) {
                    gotNode3 = upgradeService.getTargetEntity(entityType, element.attributeValue("id"));
                }
                if ((data = treeItem.getData("result")) != null && data instanceof Element) {
                    result = (Element)data;
                    List elements = element.elements();
                    for (Object element22 : elements) {
                        result.add((Element)element22.clone());
                    }
                } else {
                    result = (Element)element.clone();
                    treeItem.setData("result", (Object)result);
                    ((Element)entitysTreeItem.getData()).add(result);
                }
                List elements = ((Element)treeItem.getData("result")).elements();
                element22 = elements.iterator();
                while (element22.hasNext()) {
                    Element element3 = (Element)element22.next();
                    String modifyLevel = element3.attributeValue("modifyLevel");
                    if (!ModifyLevel.Cannot.name().equals(modifyLevel)) continue;
                    treeItem.setForeground(this.shell.getDisplay().getSystemColor(3));
                    entitysTreeItem.setForeground(this.shell.getDisplay().getSystemColor(3));
                    break;
                }
                if (elements.stream().filter(e -> ModifyType.Entity_Add.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                    treeItem.setImage(addImage);
                } else if (elements.stream().filter(e -> ModifyType.Entity_Delete.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                    treeItem.setImage(deleteImage);
                } else {
                    treeItem.setImage(difImage);
                }
                boolean bl = promote = gotNode3 != null && !gotNode3.getModifiedLayer().equals(gotNode3.getCreatedLayer());
                if (!promote) continue;
                FontData fontData = treeItem.getFont().getFontData()[0];
                fontData.setStyle(1);
                treeItem.setFont(new Font((Device)Display.getCurrent(), fontData));
                treeItem.setData("promote", (Object)true);
            }
            ++n2;
        }
        Map<String, List<Element>> distinctByIdList = this.analysisResult_Cache.stream().collect(Collectors.groupingBy(item -> item.getName()));
        EntityType[] entityTypeArray2 = EntityType.values();
        int n3 = entityTypeArray2.length;
        n = 0;
        while (n < n3) {
            EntityType entityType = entityTypeArray2[n];
            TreeItem entitysTreeItem = this.getEntitysTreeItem(entityType);
            List<Object> difEnityIds = new ArrayList();
            if (distinctByIdList.containsKey(entityType.name())) {
                difEnityIds = distinctByIdList.get(entityType.name()).stream().map(e -> e.attributeValue("id")).collect(Collectors.toList());
            }
            if (this.allEntitys.containsKey(entityType)) {
                Set<String> sourceEnityIds = this.allEntitys.get(entityType).keySet();
                difEnityIds.addAll(sourceEnityIds);
            }
            long count = difEnityIds.stream().distinct().count();
            entitysTreeItem.setText(String.valueOf(entitysTreeItem.getText()) + String.format("(%d/%d)", entitysTreeItem.getItems().length, count));
            ++n;
        }
    }

    private void updateButtonStatus() {
        this.button_ExportExcel.setEnabled(!this.analysisResult_Cache.isEmpty());
        if (this.analysis_Finish) {
            this.button_Upgrade.setEnabled(true);
        } else {
            this.button_Upgrade.setEnabled(false);
        }
    }

    private boolean upgrade() {
        final Element entityModifys = (Element)this.gotTree.getItem(0).getData();
        this.upgrade_Succeed = false;
        File layersRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
        File bakupDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
        bakupDir.mkdirs();
        try {
            FileUtils.copyDirectoryToDirectory((File)layersRoot, (File)bakupDir);
        }
        catch (IOException e1) {
            throw new RuntimeException("\u5c42\u6587\u4ef6\u5907\u4efd\u5931\u8d25", e1);
        }
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.shell);
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        upgradeService.modifys(entityModifys, new ProgressMonitor(){

                            @Override
                            public void worked(int work, String message) {
                                monitor.setTaskName(message);
                            }

                            @Override
                            public void reportResult(Element entityResult) {
                            }

                            @Override
                            public void done(final Throwable e) {
                                AnalysisResultPage.this.shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (e == null) {
                                            AnalysisResultPage.this.upgrade_Succeed = true;
                                            MessageDialog.openInformation((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)"\u5347\u7ea7\u5b8c\u6210");
                                        } else {
                                            MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)String.format("\u5347\u7ea7\u9519\u8bef\uff1a%s", e.getLocalizedMessage()));
                                            AnalysisResultPage.this.log.error((Object)"\u5347\u7ea7\u9519\u8bef", e);
                                        }
                                    }
                                });
                            }

                            @Override
                            public void beginTask(int totalWork) {
                                monitor.beginTask("", totalWork);
                            }

                            @Override
                            public void setTaskName(String name) {
                                monitor.setTaskName(name);
                            }
                        });
                    }
                    catch (Exception e) {
                        AnalysisResultPage.this.log.error((Object)"\u5347\u7ea7\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.log.error((Object)"\u5347\u7ea7\u5185\u5bb9\u5206\u6790\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
        }
        if (!this.upgrade_Succeed && layersRoot.exists() && bakupDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)layersRoot);
                FileUtils.copyDirectory((File)bakupDir.listFiles()[0], (File)layersRoot);
                MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u5347\u7ea7\u5931\u8d25, \u5c42\u6587\u4ef6\u5df2\u81ea\u52a8\u8fd8\u539f");
            }
            catch (IOException e) {
                this.log.error((Object)"Layers\u5907\u4efd\u8fd8\u539f\u5f02\u5e38", (Throwable)e);
            }
        }
        return this.upgrade_Succeed;
    }

    private TreeItem getEntitysTreeItem(EntityType entityType) {
        TreeItem gotTreeItem = this.gotTree.getItem(0);
        if (entityType == EntityType.Enum) {
            return gotTreeItem.getItem(0).getItem(0);
        }
        if (entityType == EntityType.DataType) {
            return gotTreeItem.getItem(0).getItem(1);
        }
        if (entityType == EntityType.Table) {
            return gotTreeItem.getItem(0).getItem(2);
        }
        if (entityType == EntityType.Form) {
            return gotTreeItem.getItem(3);
        }
        if (entityType == EntityType.MenuItem) {
            return gotTreeItem.getItem(2);
        }
        if (entityType == EntityType.Menu) {
            return gotTreeItem.getItem(1);
        }
        if (entityType == EntityType.Class) {
            return gotTreeItem.getItem(5);
        }
        if (entityType == EntityType.Report) {
            return gotTreeItem.getItem(4);
        }
        throw new RuntimeException(String.format("%s\u7c7b\u578b\u8282\u70b9\u4e0d\u652f\u6301\u5347\u7ea7", entityType.name()));
    }

    private Element newEmptyGOTElement() {
        try {
            String emptyGOTText = "<GOT><DataDictionary><Enums/><DataTypes/><Tables/></DataDictionary><Menus/><MenuItems/><Forms/><Reports/><Classes/></GOT>";
            return DocumentHelper.parseText((String)emptyGOTText).getRootElement();
        }
        catch (DocumentException e) {
            throw new RuntimeException("\u6784\u9020Empty GOT\u6811\u8282\u70b9\u9519\u8bef", e);
        }
    }

    /*
     * Loose catch block
     */
    protected boolean checkTomcatOccupy() throws FileNotFoundException {
        Socket socket;
        block14: {
            File basePath = ProjectConstants.getBasePath();
            File envConf = new File(basePath, "Conf/environment.cfg");
            if (!envConf.exists()) {
                throw new FileNotFoundException(String.format("\u672a\u627e\u5230\u73af\u5883\u914d\u7f6e\u6587\u4ef6\u3010%s\u3011", envConf.getAbsolutePath()));
            }
            String port = "";
            try {
                port = String.valueOf(FileUtils.readFileToDocument((File)envConf).getRootElement().selectSingleNode("./Property[@name = 'PortPrefix']").getText()) + "2";
            }
            catch (Exception exception) {
                throw new ERPException(String.format("\u89e3\u6790\u73af\u5883\u914d\u7f6e\u6587\u4ef6\u3010%s\u3011\u5f02\u5e38", envConf.getAbsolutePath()));
            }
            int tomcatPort = Integer.parseInt(port);
            socket = null;
            socket = new Socket("127.0.0.1", tomcatPort);
            if (socket == null) break block14;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return true;
        catch (Exception exception) {
            block15: {
                try {
                    if (socket == null) break block15;
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            return false;
        }
    }

    private void exportResultAsExcel(String path) throws IOException {
        File file = new File(path);
        FileOutputStream outputStream = new FileOutputStream(file);
        HSSFWorkbook workbook = new HSSFWorkbook();
        try {
            HSSFFont font = workbook.getFontAt((short)0);
            font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            HSSFSheet sheet = workbook.createSheet("\u5185\u5bb9\u5206\u6790");
            sheet.setDefaultRowHeight((short)400);
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)1);
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBorderLeft((short)1);
            cellStyle.setBorderTop((short)1);
            cellStyle.setBorderRight((short)1);
            HSSFCellStyle cellLeft = workbook.createCellStyle();
            cellLeft.setAlignment((short)1);
            cellLeft.setVerticalAlignment((short)1);
            cellLeft.setBorderBottom((short)1);
            cellLeft.setBorderLeft((short)1);
            cellLeft.setBorderTop((short)1);
            cellLeft.setBorderRight((short)1);
            HSSFCellStyle cellHead = workbook.createCellStyle();
            cellHead.setAlignment((short)2);
            cellHead.setVerticalAlignment((short)1);
            cellHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellHead.setFillPattern((short)1);
            cellHead.setBorderBottom((short)1);
            cellHead.setBorderLeft((short)1);
            cellHead.setBorderTop((short)1);
            cellHead.setBorderRight((short)1);
            sheet.setColumnWidth(0, 3072);
            sheet.setColumnWidth(1, 7680);
            sheet.setColumnWidth(2, 3072);
            sheet.setColumnWidth(3, 38400);
            sheet.createFreezePane(0, 1, 0, 1);
            HSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue("\u8282\u70b9\u7c7b\u578b");
            row.createCell(1).setCellValue("\u8282\u70b9\u540d\u79f0");
            row.createCell(2).setCellValue("\u7c7b\u578b");
            row.createCell(3).setCellValue("\u5185\u5bb9\u63cf\u8ff0");
            row.getCell(0).setCellStyle(cellHead);
            row.getCell(1).setCellStyle(cellHead);
            row.getCell(2).setCellStyle(cellHead);
            row.getCell(3).setCellStyle(cellHead);
            int line = 1;
            line = this.buildExcelLine(EntityType.Enum, sheet, line, cellStyle, cellLeft);
            line = this.buildExcelLine(EntityType.DataType, sheet, line, cellStyle, cellLeft);
            line = this.buildExcelLine(EntityType.Table, sheet, line, cellStyle, cellLeft);
            line = this.buildExcelLine(EntityType.Enum, sheet, line, cellStyle, cellLeft);
            line = this.buildExcelLine(EntityType.Form, sheet, line, cellStyle, cellLeft);
            line = this.buildExcelLine(EntityType.MenuItem, sheet, line, cellStyle, cellLeft);
            line = this.buildExcelLine(EntityType.Menu, sheet, line, cellStyle, cellLeft);
            line = this.buildExcelLine(EntityType.Class, sheet, line, cellStyle, cellLeft);
            line = this.buildExcelLine(EntityType.Report, sheet, line, cellStyle, cellLeft);
            workbook.setActiveSheet(0);
            workbook.write((OutputStream)outputStream);
        }
        finally {
            workbook.close();
            ((OutputStream)outputStream).close();
        }
    }

    private int buildExcelLine(EntityType entityType, HSSFSheet sheet, int line, HSSFCellStyle cellStyle, HSSFCellStyle cellLeft) {
        TreeItem[] items;
        int start = line;
        TreeItem entitysTreeItem = this.getEntitysTreeItem(entityType);
        TreeItem[] treeItemArray = items = entitysTreeItem.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            String entityId = (String)treeItem.getData("entityId");
            if (!StringUtils.isBlank((String)entityId)) {
                Element result = (Element)treeItem.getData("result");
                List itemElements = result.elements();
                for (Element itemElement : itemElements) {
                    HSSFRow row = sheet.createRow(line++);
                    row.createCell(0).setCellStyle(cellStyle);
                    row.createCell(1).setCellStyle(cellStyle);
                    row.createCell(2).setCellStyle(cellStyle);
                    row.createCell(3).setCellStyle(cellLeft);
                    row.getCell(0).setCellValue(entityType.name());
                    row.getCell(1).setCellValue(treeItem.getText());
                    String modifyType = ModifyType.valueOf(itemElement.attributeValue("modifyType")).getLabel();
                    String description = itemElement.attributeValue("description");
                    row.getCell(2).setCellValue(modifyType);
                    row.getCell(3).setCellValue(description);
                }
                if (itemElements.size() > 1) {
                    CellRangeAddress address = new CellRangeAddress(line - itemElements.size(), line - 1, 1, 1);
                    sheet.addMergedRegion(address);
                }
            }
            ++n2;
        }
        if (line - start > 1) {
            CellRangeAddress address = new CellRangeAddress(start, line - 1, 0, 0);
            sheet.addMergedRegion(address);
        }
        return line;
    }

    private void resetView() {
        this.compareTree.removeAll();
        this.tipInfo.setText("");
        this.methodTipInfo.setText("");
        this.propertyInfoTree.removeAll();
        this.javaMethodTree.removeAll();
        this.javaCodeText.setDocument((IDocument)new Document());
    }

    private static enum DisplayType {
        Add,
        Dif,
        Delete,
        Same;

    }
}

