/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node.form;

import gongqi.gdt.designer.core.got.node.Branch;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.got.node.form.FormItemDragController;
import gongqi.gdt.designer.core.got.node.form.IFormItemDragController;
import info.gongqi.got.tool.GOTHelp;
import java.util.List;
import org.dom4j.Element;
import org.eclipse.swt.events.MouseEvent;

public class FormDesign
extends Branch {
    private IFormItemDragController dragCtrl = FormItemDragController.getInstance();

    @Override
    public NodeGOT getAccpDragNewNode(Element src) {
        if (src.getName().equals("Enum")) {
            NodeGOT node = super.doAccpDragNew("FormItem", "EnumEditor");
            this.dragCtrl.doAccpDragNewAfter(src, node);
            return node;
        }
        if (src.getName().equals("DataType")) {
            String type = this.getFormItemType(src.attributeValue("type"));
            NodeGOT node = super.doAccpDragNew("FormItem", type);
            this.dragCtrl.doAccpDragNewAfter(src, node);
            return node;
        }
        if (src.getName().equals("FormDataSourceField")) {
            NodeGOT node = super.doAccpDragNew("FormItem", this.getFormItemType(src.attributeValue("type")));
            this.dragCtrl.doAccpDragNewAfter(src, node);
            return node;
        }
        if (src.getName().equals("FormDataSourceFieldGroup")) {
            NodeGOT node = super.doAccpDragNew("FormItem", "FieldGroup");
            this.dragCtrl.doAccpDragNewAfterForFormDataSourceFieldGroup(src, node);
            return node;
        }
        if (src.getName().equals("MenuItem")) {
            NodeGOT node = super.doAccpDragNew("FormItem", "MenuItemButton");
            this.dragCtrl.doAccpDragNewAfter(src, node);
            return node;
        }
        return null;
    }

    private String getFormItemType(String origType) {
        if (origType.equals("Component")) {
            return "FieldGroup";
        }
        return String.valueOf(origType) + "Editor";
    }

    private void setNotNullAndVisible(Element xml) {
        List<Element> pro = GOTHelp.getDDDAttElementList(xml, "Name", "NotNull");
        if (pro.size() == 1) {
            pro.get(0).element("Value").setText("false");
        }
        if ((pro = GOTHelp.getDDDAttElementList(xml, "Name", "Visible")).size() == 1) {
            pro.get(0).element("Value").setText("true");
        }
    }

    private Boolean isNotAllowDragOut(Element fieldGroup) {
        List<Element> fieldGroupPro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "FieldGroup");
        List<Element> componentPro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "Component");
        List<Element> dataSourcePro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "DataSource");
        String dataSourceValue = dataSourcePro.get(0).elementText("Value");
        String componentValue = componentPro.get(0).elementText("Value");
        String fieldGroupValue = fieldGroupPro.get(0).elementText("Value");
        if (!dataSourceValue.equals("") && !componentValue.equals("") || !dataSourceValue.equals("") && !fieldGroupValue.equals("")) {
            return true;
        }
        return false;
    }

    @Override
    public String moveType(Element srcItem, MouseEvent event) {
        if (srcItem.getName().equals("FormItem")) {
            Element parent = srcItem.getParent();
            if (parent != null && "FieldGroup".equals(parent.attributeValue("type")) && this.isNotAllowDragOut(parent).booleanValue()) {
                return "false";
            }
            return "append";
        }
        return "false";
    }

    @Override
    public String getAccpDragNewInsertBase() {
        return "self";
    }

    @Override
    public Boolean isSibling(Element srcItem) {
        if (srcItem.getName().equals("FormItem")) {
            return true;
        }
        return false;
    }

    @Override
    public String validateAccpDragMove(Element srcItem, MouseEvent event) {
        Element parent = srcItem.getParent();
        if (this.isNotAllowDragOut(parent).booleanValue()) {
            return "do not place here";
        }
        return "down";
    }

    private void setAllowEditDefault(NodeGOT node) {
        List<Element> allowEditPro;
        if (node == null) {
            node = this;
        }
        if ((allowEditPro = GOTHelp.getPPAttElementList(node.xml, "Name", "AllowEdit")).size() != 1) {
            throw new Error("FormItem\u4e0a\u6ca1\u6709\u627e\u5230\u6b63\u786e\u6570\u91cf\u7684AllowEdit\u5c5e\u6027");
        }
        allowEditPro.get(0).element("Value").setText(node.rNode.getPropertyValue("AllowEdit", "Default"));
    }
}

