/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import java.util.Objects;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;

public class ImageButton
extends Label {
    private Image normalImage;
    private Image hoverImage;

    public ImageButton(Composite parent, Image normalImage, Image hoverImage) {
        super(parent, 8);
        Objects.requireNonNull(normalImage, "normalImage is null");
        this.normalImage = normalImage;
        this.hoverImage = hoverImage;
        this.initialization();
    }

    private void initialization() {
        this.setImage(this.normalImage);
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                ImageButton.this.setImage(ImageButton.this.normalImage);
            }

            public void mouseEnter(MouseEvent e) {
                ImageButton.this.setImage(ImageButton.this.hoverImage);
            }
        });
    }

    public void addSelectionListener(final SelectionListener listener) {
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Rectangle bounds = ImageButton.this.getBounds();
                if (e.x >= 0 && e.x <= bounds.width && e.y >= 0 && e.y <= bounds.height) {
                    Event event = new Event();
                    event.widget = e.widget;
                    event.item = e.widget;
                    event.x = e.x;
                    event.y = e.y;
                    event.data = e.data;
                    listener.widgetSelected(new SelectionEvent(event));
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    protected void checkSubclass() {
    }

    public void setText(String string) {
        throw new IllegalArgumentException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "\u4e0d\u652f\u6301\u6587\u672c");
    }

    public void setImage(Image normalImage, Image hoverImage) {
        this.normalImage = normalImage;
        this.hoverImage = hoverImage;
        if (this.getEnabled()) {
            this.setImage(normalImage);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.setBackground(null);
        }
        super.setEnabled(enabled);
    }
}

