/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.gdt.designer.utils.cache.GOTFinalValueHelper;
import info.gongqi.got.model.GotXmlDto;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class GOTHelp {
    public static String getPPAttValue(Element date, String att, String attValue) {
        String value = "";
        if (date.element("Properties") == null) {
            return "";
        }
        List elements = date.element("Properties").elements("Property");
        for (Element element : elements) {
            String elAtt = element.element(att).getText();
            if (!attValue.equals(elAtt)) continue;
            value = element.element("Value").getText();
            return value;
        }
        return value;
    }

    public static Element getPPAttElement(Element date, String att, String attValue) {
        List elements = date.element("Properties").elements("Property");
        for (Element element : elements) {
            String elAtt = element.element(att).getText();
            if (!attValue.equals(elAtt)) continue;
            return element;
        }
        return null;
    }

    public static List<Element> getPPAttElementList(Element date, String att, String attValue) {
        ArrayList<Element> returnList = new ArrayList<Element>();
        List elements = date.element("Properties").elements("Property");
        for (Element element : elements) {
            String elAtt = element.element(att).getText();
            if (!attValue.equals(elAtt)) continue;
            returnList.add(element);
        }
        return returnList;
    }

    public static List<Element> getDDDAttElementList(Element date, String att, String attValue) {
        ArrayList<Element> returnList = new ArrayList<Element>();
        List elements = date.element("DataDictionary").element("DataTypes").elements("DataType");
        for (Element element : elements) {
            String elAtt = element.element(att).getText();
            if (!attValue.equals(elAtt)) continue;
            returnList.add(element);
        }
        return returnList;
    }

    public static String getFormDataSourceLabel(Element dataSource) {
        if (dataSource != null) {
            Element tablePro = GOTHelp.getPPAttElement(dataSource, "Name", "Table");
            Element table = null;
            if (tablePro.attribute("refentityid") != null) {
                table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tablePro.attributeValue("refentityid"));
                if (table == null) {
                    System.out.println("---" + tablePro.attributeValue("refentityid"));
                    return "";
                }
                String label = GOTHelp.getPPAttValue(table, "Name", "Label");
                if (!label.equals("")) {
                    return label;
                }
            }
            return dataSource.attributeValue("name");
        }
        return "";
    }

    public static String getTableIndexItemLabel(Element tableIndexItem) {
        if (tableIndexItem != null) {
            Element fieldPro = GOTHelp.getProperty(tableIndexItem, "Field");
            if (fieldPro.attribute("innerid") != null) {
                Element table = GOTHelp.getEntity(tableIndexItem);
                Element fieldXML = null;
                if (table != null) {
                    List elements = table.element("TableFields").elements("TableField");
                    for (Element element : elements) {
                        if (!element.attributeValue("id").equals(fieldPro.attributeValue("innerid"))) continue;
                        fieldXML = element;
                        break;
                    }
                    if (fieldXML != null) {
                        return GOTFinalValueHelper.getFinalValue(fieldXML, "Label");
                    }
                }
            }
            return tableIndexItem.attributeValue("name");
        }
        return "";
    }

    public static Element getProperty(Element xml, String property) {
        List elements = xml.element("Properties").elements("Property");
        for (Element element : elements) {
            String elAtt = element.element("Name").getText();
            if (!property.equals(elAtt)) continue;
            return element;
        }
        return null;
    }

    public static Element getEntity(Element item) {
        while (item != null) {
            if (GOTHelp.isEntity(item).booleanValue()) {
                return item;
            }
            item = item.getParent();
        }
        return null;
    }

    public static Boolean isEntity(Element node) {
        if (node.attribute("version") != null) {
            return true;
        }
        return false;
    }

    public static List<Element> getListById(List<Element> list, String att, String value) {
        ArrayList<Element> returnList = new ArrayList<Element>();
        for (Element element : list) {
            if (element.attribute(att) == null || !element.attributeValue(att).equals(value)) continue;
            returnList.add(element);
        }
        return returnList;
    }

    public static Element prependChild(Element parent, Element tarParent) {
        parent.elements().add(0, tarParent);
        return parent;
    }

    public static Element insertChildBefore(Element parent, Element tarParentBefore, Element tarElement) {
        List elements = parent.content();
        int index = -1;
        index = elements.indexOf(tarParentBefore) == -1 ? GOTHelp.indexList(elements, tarParentBefore) : elements.indexOf(tarParentBefore);
        elements.add(index, tarElement);
        parent.setContent(elements);
        return parent;
    }

    private static int indexList(List<Element> elements, Element tarParentBefore) {
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i).asXML().equals(tarParentBefore.asXML())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Element insertChildAfter(Element parent, Element tarElementAfter, Element tarElement) {
        List elements = parent.content();
        elements.add(elements.indexOf(tarElementAfter) + 1, tarElement);
        parent.setContent(elements);
        return parent;
    }
}

