/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils.cache;

import gongqi.designer.got.GOTManager;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.exception.ERPExceptionType;
import gongqi.erp.gotmodel.core.GOTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class EnumSourceHelper {
    public static List<Object> getDataSourceByTableField(Element tableField) {
        Element sourcePro = GOTHelper.getProperty((Element)tableField, (String)"Source");
        Element extendsPro = GOTHelper.getProperty((Element)tableField, (String)"Extends");
        if (extendsPro.attribute("refentityid") == null) {
            return EnumSourceHelper.getDataSourceByRegular(tableField);
        }
        if ("Enum".equals(sourcePro.elementText("Value"))) {
            return EnumSourceHelper.getDataSourceByEnum(extendsPro);
        }
        return EnumSourceHelper.getDataSourceByDataType(extendsPro);
    }

    public static List<Object> getDataSourceByReportField(Element reportField) {
        Element sourcePro = GOTHelper.getProperty((Element)reportField, (String)"Source");
        Element extendsPro = GOTHelper.getProperty((Element)reportField, (String)"Extends");
        if (extendsPro.attribute("refentityid") == null) {
            return EnumSourceHelper.getDataSourceByRegular(reportField);
        }
        if ("Enum".equals(sourcePro.elementText("Value"))) {
            return EnumSourceHelper.getDataSourceByEnum(extendsPro);
        }
        return EnumSourceHelper.getDataSourceByDataType(extendsPro);
    }

    private static Element getArrayItemByName(Element dataType, String itemName) {
        Element list = (Element)dataType.selectSingleNode(String.format("DataTypeArray/DataTypeArrayItem[@name='%s']", itemName));
        return list;
    }

    public static List<Object> getDataSourceByDataSource(Element extendsPro) {
        if (extendsPro.attribute("refentityid") == null) {
            return new ArrayList<Object>();
        }
        String tableId = extendsPro.attributeValue("refentityid");
        String tableFieldId = extendsPro.attributeValue("refinnerid");
        Element table = EnumSourceHelper.getEntity("Table", tableId);
        Element tableField = (Element)table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", tableFieldId));
        if ("Component".equals(tableField.attributeValue("type"))) {
            String value;
            String arrayItemName;
            Element textendsPro = GOTHelper.getProperty((Element)tableField, (String)"Extends");
            if (textendsPro.attributeValue("refentityid") == null) {
                throw new ERPException(ERPExceptionType.WARN, "GOT\u9519\u8bef:Component\u7c7b\u578b\u7684TableField\u6ca1\u6709\u6b63\u786e\u5173\u8054\u5230\u4e00\u4e2a\u5bf9\u5e94\u7684DataType");
            }
            String cdataTypeId = textendsPro.attributeValue("refentityid");
            Element cdataType = EnumSourceHelper.getEntity("DataType", cdataTypeId);
            Element arrayItem = EnumSourceHelper.getArrayItemByName(cdataType, arrayItemName = (value = extendsPro.elementText("Value")).split("[.]")[1]);
            Element refDataTypePro = GOTHelper.getProperty((Element)arrayItem, (String)"RefDataType");
            if (refDataTypePro.attribute("refentityid") == null) {
                throw new ERPException(ERPExceptionType.WARN, "GOT\u9519\u8bef:" + cdataType.attributeValue("name") + "." + arrayItemName + "\u6ca1\u6709\u5173\u8054\u5230DataType");
            }
            return EnumSourceHelper.getDataSourceByDataType(refDataTypePro);
        }
        return EnumSourceHelper.getDataSourceByTableField(tableField);
    }

    public static List<Object> getDataSourceByEnum(Object extendsPro) {
        String enumId = null;
        if (extendsPro instanceof Element) {
            if (((Element)extendsPro).attribute("refentityid") == null) {
                return new ArrayList<Object>();
            }
            enumId = ((Element)extendsPro).attributeValue("refentityid");
        } else {
            enumId = (String)extendsPro;
        }
        Element entityEnum = EnumSourceHelper.getEntity("Enum", enumId);
        ArrayList<Object> result = new ArrayList<Object>();
        String label = null;
        String value = null;
        List items = entityEnum.elements("EnumItem");
        for (Element item : items) {
            label = GOTHelper.getPropertyValue((Element)item, (String)"Label");
            value = GOTHelper.getPropertyValue((Element)item, (String)"Value");
            HashMap<String, String> mitem = new HashMap<String, String>();
            mitem.put("label", label);
            mitem.put("value", value);
            result.add(mitem);
        }
        return result;
    }

    public static List<Object> getDataSourceByDataType(Object extendsPro) {
        String refentityid = null;
        if (extendsPro instanceof Element) {
            if (((Element)extendsPro).attribute("refentityid") == null) {
                return new ArrayList<Object>();
            }
            refentityid = ((Element)extendsPro).attributeValue("refentityid");
        } else {
            refentityid = (String)extendsPro;
        }
        Element dataType = EnumSourceHelper.getEntity("DataType", refentityid);
        Element extendsPro_dataType = GOTHelper.getProperty((Element)dataType, (String)"Extends");
        Element sourcePro = null;
        while (extendsPro_dataType.attribute("refentityid") != null) {
            sourcePro = GOTHelper.getProperty((Element)dataType, (String)"Source");
            if ("Enum".equals(sourcePro.elementText("Value"))) {
                return EnumSourceHelper.getDataSourceByEnum(extendsPro_dataType);
            }
            dataType = EnumSourceHelper.getEntity("refentityid", extendsPro_dataType.attributeValue("refentityid"));
            extendsPro_dataType = GOTHelper.getProperty((Element)dataType, (String)"Extends");
        }
        return EnumSourceHelper.getDataSourceByRegular(dataType);
    }

    public static List<Object> getDataSourceByRegular(Element node) {
        Element regularPro = GOTHelper.getProperty((Element)node, (String)"Regular");
        if (regularPro == null) {
            return null;
        }
        String regular = regularPro.elementText("Value");
        ArrayList<Object> result = new ArrayList<Object>();
        String value = null;
        String label = null;
        if (regular != "") {
            String[] array = regular.split("[|]");
            int i = 0;
            while (i < array.length) {
                String item = array[i];
                if (item.indexOf(":") > -1) {
                    String[] itemarray = item.split("[:]");
                    value = itemarray[0];
                    label = itemarray[1];
                } else {
                    value = item;
                    label = item;
                }
                HashMap<String, String> itemo = new HashMap<String, String>();
                itemo.put("label", label);
                itemo.put("value", value);
                result.add(itemo);
                ++i;
            }
        }
        return result;
    }

    public static Element getEntity(String entityType, String entityId) {
        return ((GOTManager)ObjectContainer.getInstance(GOTManager.class)).getEntity(entityId);
    }
}

