/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class VTDUtils {
    public static VTDNav parseXML(Path xmlPath) throws IOException, VTDException {
        if (xmlPath == null || Files.notExists(xmlPath, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("%s\u6587\u4ef6\u672a\u627e\u5230\uff01", xmlPath));
        }
        byte[] docBytes = Files.readAllBytes(xmlPath);
        return VTDUtils.parseXML(docBytes);
    }

    public static VTDNav parseXML(byte[] xml) throws IOException, VTDException {
        VTDGen gen = new VTDGen();
        gen.setDoc(xml);
        gen.parse(false);
        return gen.getNav();
    }

    public static String getName(VTDNav nav) throws NavException {
        return nav.toString(nav.getCurrentIndex());
    }

    public static boolean hasAttribute(VTDNav nav, String attributeName) throws NavException {
        return nav.hasAttr(attributeName);
    }

    public static String getAttributeValue(VTDNav nav, String attributeName) throws NavException {
        String value = null;
        int valueIndex = nav.getAttrVal(attributeName);
        if (valueIndex != -1) {
            value = nav.toString(valueIndex);
        }
        return value;
    }

    public static Map<String, String> getAttributes(VTDNav nav) throws PilotException, NavException {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        AutoPilot pilot = new AutoPilot(nav);
        pilot.selectAttr("*");
        int index = -1;
        while ((index = pilot.iterateAttr()) != -1) {
            String attrName = nav.toString(index);
            int valueIndex = nav.getAttrVal(attrName);
            if (valueIndex != -1) {
                attributes.put(attrName, nav.toString(valueIndex));
                continue;
            }
            attributes.put(attrName, null);
        }
        pilot.resetXPath();
        return attributes;
    }

    public static boolean toRootElement(VTDNav nav) throws NavException {
        return VTDUtils.toElement(nav, null, 0);
    }

    public static boolean toParent(VTDNav nav) throws NavException {
        if (nav.getRootIndex() != nav.getCurrentIndex()) {
            return VTDUtils.toElement(nav, null, 1);
        }
        return false;
    }

    public static boolean toFirstChildElement(VTDNav nav) throws NavException {
        return VTDUtils.toFirstChildElement(nav, null);
    }

    public static boolean toFirstChildElement(VTDNav nav, String elementName) throws NavException {
        return VTDUtils.toElement(nav, elementName, 2);
    }

    public static boolean toPrevSiblingElement(VTDNav nav) throws NavException {
        return VTDUtils.toPrevSiblingElement(nav, null);
    }

    public static boolean toPrevSiblingElement(VTDNav nav, String elementName) throws NavException {
        return VTDUtils.toElement(nav, elementName, 5);
    }

    public static boolean toNextSiblingElement(VTDNav nav) throws NavException {
        return VTDUtils.toNextSiblingElement(nav, null);
    }

    public static boolean toNextSiblingElement(VTDNav nav, String elementName) throws NavException {
        return VTDUtils.toElement(nav, elementName, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean toElement(VTDNav nav, String elementName, int direction) throws NavException {
        VTDNav vTDNav = nav;
        synchronized (vTDNav) {
            if (StringUtils.isBlank((String)elementName)) {
                return nav.toElement(direction);
            }
            return nav.toElement(direction, elementName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean toXPathElement(VTDNav nav, String xpath) throws XPathParseException, XPathEvalException, NavException {
        VTDNav vTDNav = nav;
        synchronized (vTDNav) {
            AutoPilot pilot = new AutoPilot(nav);
            pilot.selectXPath(xpath);
            int index = pilot.evalXPath();
            pilot.resetXPath();
            return index != -1;
        }
    }

    public static String asXML(VTDNav nav) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            nav.dumpXML((OutputStream)out);
            out.flush();
            return out.toString("UTF-8");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String dumpFragment(VTDNav nav) throws NavException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            nav.dumpFragment((OutputStream)bos);
            return bos.toString("utf-8");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String escapeChar(String content) {
        return content.replace("<", "&lt;").replace(">", "&gt;");
    }
}

