/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.analysis;

import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.analysis.BaseAnalysis;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class DataTypeAnalysis
extends BaseAnalysis {
    public DataTypeAnalysis(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalGOT) {
        super(sourceGOT, targetGOT, originalGOT);
    }

    @Override
    protected EntityType getSupportEntityType() {
        return EntityType.DataType;
    }

    @Override
    protected List<Element> analysisEntityInnerModify(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        GOTNode sourceDataTypeRelation;
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTNode targetDataTypeRelation = targetEntity.selectSingleNode("DataTypeRelation");
        if (targetDataTypeRelation != null) {
            modifyItems.addAll(this.analysisInnerNode(targetDataTypeRelation));
        }
        if ((sourceDataTypeRelation = sourceEntity.selectSingleNode("DataTypeRelation")) != null && targetDataTypeRelation != null) {
            for (GOTNode targetDataTypeRelationItem : targetDataTypeRelation.selectNodes("DataTypeRelationItem")) {
                modifyItems.addAll(this.analysisInnerNode(targetDataTypeRelationItem));
            }
        }
        for (GOTNode targetDataTypeArrayItem : targetEntity.selectNodes("DataTypeArray/DataTypeArrayItem")) {
            modifyItems.addAll(this.analysisInnerNode(targetDataTypeArrayItem));
        }
        return modifyItems;
    }

    @Override
    protected List<Element> analysisEntityInnerDelete(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> items = new ArrayList<Element>();
        GOTNode sourceDataTypeRelation = sourceEntity.selectSingleNode("DataTypeRelation");
        if (sourceDataTypeRelation != null) {
            items.addAll(this.analysisReverseInnerNode(sourceDataTypeRelation));
            GOTNode targetDataTypeRelation = targetEntity.selectSingleNode(sourceDataTypeRelation.getEntityXPath());
            if (targetDataTypeRelation != null) {
                for (GOTNode sourceDataTypeRelationItem : sourceDataTypeRelation.selectNodes("DataTypeRelationItem")) {
                    items.addAll(this.analysisReverseInnerNode(sourceDataTypeRelationItem));
                }
            }
        }
        for (GOTNode sourceDataTypeArrayItem : sourceEntity.selectNodes("DataTypeArray/DataTypeArrayItem")) {
            items.addAll(this.analysisReverseInnerNode(sourceDataTypeArrayItem));
        }
        return items;
    }
}

