/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerResolver;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.extension.SolutionExtensionResolver;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginResolver;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionEntityCombiner;
import gongqi.erp.framework.core.solution.SolutionResolver;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.utils.VTDUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.dom4j.Document;

public class GOTModel {
    private static Logger log = Logger.getLogger(GOTModel.class);
    private List<LayerDefination> layerDefinations = new ArrayList<LayerDefination>();
    private List<SolutionDefinition> solutionDefinitions = new ArrayList<SolutionDefinition>();
    private List<SolutionPluginDefinition> solutionPluginDefinitions = new ArrayList<SolutionPluginDefinition>();
    private List<SolutionExtensionDefinition> solutionExtensionDefinitions = new ArrayList<SolutionExtensionDefinition>();
    private Map<EntityType, Map<String, GOTEntity>> entityIdMaps = new ConcurrentHashMap<EntityType, Map<String, GOTEntity>>();
    private List<GOTEntity> removeEntitys = new ArrayList<GOTEntity>();
    private Map<String, List<GOTProperty>> catchRefInnerIdMap = new HashMap<String, List<GOTProperty>>();
    private boolean catchRefInnerId = false;

    public GOTModel(File layersRootDir) {
        try {
            List layerDefinations = ((LayerResolver)ObjectContainer.getInstance(LayerResolver.class)).resolveLayers(layersRootDir.getAbsolutePath());
            List solutionDefinitions = Collections.emptyList();
            File solutionsRootDir = new File(layersRootDir, "app");
            if (solutionsRootDir.exists()) {
                solutionDefinitions = ((SolutionResolver)ObjectContainer.getInstance(SolutionResolver.class)).resolveSolutions(solutionsRootDir.getAbsolutePath());
            }
            List solutionPluginDefinitions = Collections.emptyList();
            File solutionPluginsRootDir = new File(layersRootDir, "plg");
            if (solutionPluginsRootDir.exists()) {
                solutionPluginDefinitions = ((SolutionPluginResolver)ObjectContainer.getInstance(SolutionPluginResolver.class)).resolveSolutionPlugins(solutionPluginsRootDir.getAbsolutePath());
            }
            List solutionExtensionDefinitions = Collections.emptyList();
            File solutionExtensionsRootDir = new File(layersRootDir, "ext");
            if (solutionExtensionsRootDir.exists()) {
                solutionExtensionDefinitions = ((SolutionExtensionResolver)ObjectContainer.getInstance(SolutionExtensionResolver.class)).resolveSolutionExtensions(solutionExtensionsRootDir.getAbsolutePath());
            }
            if (layerDefinations == null || layerDefinations.isEmpty()) {
                throw new ERPException("\u65e0\u6548\u7684\u5c42\u5b9a\u4e49\u5217\u8868");
            }
            this.layerDefinations = layerDefinations;
            if (solutionDefinitions != null) {
                solutionDefinitions.forEach(definition -> definition.getLayerDependencies().forEach(dependency -> {
                    Optional<LayerDefination> optional = layerDefinations.stream().filter(layerDefination -> layerDefination.getLayerName().equals(dependency.getLayerName())).findFirst();
                    if (!optional.isPresent()) {
                        throw new RuntimeException(String.format("\u4f9d\u8d56%s\u5c42\u4e0d\u5b58\u5728", dependency.getLayerName()));
                    }
                }));
                this.solutionDefinitions = solutionDefinitions;
            }
            if (solutionPluginDefinitions != null) {
                solutionPluginDefinitions.forEach(definition -> {
                    Optional<SolutionDefinition> solutionOptional = this.solutionDefinitions.stream().filter(solution -> solution.getSolutionName().equals(definition.getSolutionName())).findFirst();
                    if (solutionOptional.isPresent()) {
                        SolutionDefinition solutionDefinition = solutionOptional.get();
                        try {
                            BigDecimal solutionVersion = new BigDecimal(solutionDefinition.getSolutionVersion());
                            BigDecimal dependencySolutionVersion = new BigDecimal(definition.getSolutionVersion());
                            if (solutionVersion.compareTo(dependencySolutionVersion) == -1) {
                                log.warn((Object)String.format("\u3010%s\u3011\u65b9\u6848\u3010%s\u3011\u63d2\u4ef6\u4f9d\u8d56\u65b9\u6848\u3010%s\u3011\u7248\u672c\uff0c\u65b9\u6848\u5b9e\u9645\u7248\u672c\u4e3a\u3010%s\u3011,\u4e0d\u7b26\u5408\u4f9d\u8d56\u8981\u6c42", definition.getSolutionName(), definition.getName(), definition.getSolutionVersion(), solutionDefinition.getSolutionVersion()));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                        definition.getSolutionPluginLayerDependencies().forEach(layerDependency -> {
                            LayerDefination dependencyLayerDefination = layerDefinations.stream().filter(layerDefination -> layerDefination.getLayerName().equals(layerDependency.getLayerName())).findFirst().get();
                            try {
                                BigDecimal solutionDependencyVersion = new BigDecimal(layerDependency.getLayerVersion());
                                BigDecimal layerVersion = new BigDecimal(dependencyLayerDefination.getLayerVersion());
                                if (solutionDependencyVersion.compareTo(layerVersion) == 1) {
                                    log.warn((Object)String.format("\u3010%s\u3011\u65b9\u6848\u3010%s\u3011\u63d2\u4ef6\u4f9d\u8d56\u3010%s\u3011\u5c42\u3010%s\u3011\u7248\u672c\uff0c\u3010%s\u3011\u5c42\u5b9e\u9645\u7248\u672c\u3010%s\u3011\uff0c\u4e0d\u7b26\u5408\u4f9d\u8d56\u8981\u6c42", definition.getSolutionName(), definition.getName(), layerDependency.getLayerName(), layerDependency.getLayerVersion(), dependencyLayerDefination.getLayerName(), dependencyLayerDefination.getLayerVersion()));
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        });
                    }
                });
                this.solutionPluginDefinitions = solutionPluginDefinitions;
            }
            if (solutionExtensionDefinitions != null) {
                this.solutionExtensionDefinitions = solutionExtensionDefinitions;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5c42\u6a21\u578b\u89e3\u6790\u9519\u8bef\uff1a" + layersRootDir.getAbsolutePath(), e);
        }
        this.initModelEntitys();
    }

    private void initModelEntitys() {
        HashMap entityDocs = new HashMap();
        EntityType.stream().forEach(entityType -> entityDocs.put(entityType, new TreeMap()));
        int i = this.layerDefinations.size();
        while (i > 0) {
            LayerDefination layerDefination = this.layerDefinations.get(i - 1);
            if ("app".equals(layerDefination.getLayerName())) {
                for (SolutionDefinition solutionDefinition : this.solutionDefinitions) {
                    EntityType.stream().forEach(entityType -> {
                        HashMap documents = new HashMap(solutionDefinition.getEntityDocumentMap(entityType));
                        this.solutionPluginDefinitions.stream().filter(definition -> definition.getSolutionName().equals(solutionDefinition.getSolutionName())).forEach(solutionPlugin -> solutionPlugin.getSolutionEntityDocuments(entityType).entrySet().stream().filter(entry -> documents.containsKey(entry.getKey())).forEach(entry -> {
                            Document solutionDoc = FileUtils.parseStringToDocument((String)((String)documents.get(entry.getKey())));
                            Document pluginDoc = FileUtils.parseStringToDocument((String)((String)entry.getValue()));
                            ((SolutionEntityCombiner)ObjectContainer.getInstance(SolutionEntityCombiner.class)).combineEntity(solutionDoc.getRootElement(), pluginDoc.getRootElement());
                            documents.put((String)entry.getKey(), solutionDoc.asXML());
                        }));
                        ((Map)entityDocs.get(entityType)).putAll(documents);
                    });
                }
            } else if ("plg".equals(layerDefination.getLayerName())) {
                for (SolutionPluginDefinition solutionPluginDefinition : this.solutionPluginDefinitions) {
                    EntityType.stream().forEach(entityType -> ((Map)entityDocs.get(entityType)).putAll(solutionPluginDefinition.getEntityDocumentMap(entityType)));
                }
            } else if ("ext".equals(layerDefination.getLayerName())) {
                for (SolutionExtensionDefinition solutionExtensionDefinition : this.solutionExtensionDefinitions) {
                    EntityType.stream().forEach(entityType -> ((Map)entityDocs.get(entityType)).putAll(solutionExtensionDefinition.getEntityDocumentMap(entityType)));
                }
            } else {
                EntityType.stream().forEach(entityType -> ((Map)entityDocs.get(entityType)).putAll(layerDefination.getEntityDocumentMap(entityType)));
            }
            --i;
        }
        for (Map.Entry entry : entityDocs.entrySet()) {
            Iterator entityFileIterator = ((Map)entry.getValue()).values().iterator();
            while (entityFileIterator.hasNext()) {
                try {
                    GOTEntity entity = new GOTEntity(VTDUtils.parseXML(((String)entityFileIterator.next()).getBytes(StandardCharsets.UTF_8)));
                    this.getEntityIdMap(entity.getEntityType()).put(entity.getId(), entity);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("\u89e3\u6790%s\u5b9e\u4f53\u9519\u8bef", ((EntityType)entry.getKey()).name()), e);
                }
            }
        }
    }

    public File getLayersRootDir() {
        LayerDefination systemLayerDefination = this.getLayerDefination("sys");
        File systemLayerDir = new File(systemLayerDefination.getLayerDir());
        return systemLayerDir.getParentFile();
    }

    public List<SolutionDefinition> getSolutionDefinitions() {
        return Collections.unmodifiableList(this.solutionDefinitions);
    }

    public SolutionDefinition getSolutionDefinition(String solutionName) {
        for (SolutionDefinition solutionDefinition : this.solutionDefinitions) {
            if (!solutionDefinition.getSolutionName().equals(solutionName)) continue;
            return solutionDefinition;
        }
        return null;
    }

    public List<SolutionPluginDefinition> getSolutionPluginDefinitions() {
        return Collections.unmodifiableList(this.solutionPluginDefinitions);
    }

    public SolutionPluginDefinition getSolutionPluginDefinition(String solutionPluginName) {
        for (SolutionPluginDefinition solutionPluginDefinition : this.solutionPluginDefinitions) {
            if (!solutionPluginDefinition.getName().equals(solutionPluginName)) continue;
            return solutionPluginDefinition;
        }
        return null;
    }

    public List<SolutionExtensionDefinition> getSolutionExtensionDefinitions() {
        return Collections.unmodifiableList(this.solutionExtensionDefinitions);
    }

    public SolutionExtensionDefinition getSolutionExtensionDefinition(String solutionName) {
        for (SolutionExtensionDefinition solutionExtensionDefinition : this.solutionExtensionDefinitions) {
            if (!solutionExtensionDefinition.getSolutionName().equals(solutionName)) continue;
            return solutionExtensionDefinition;
        }
        return null;
    }

    public LayerDefination getTopLayerDefination() {
        return this.layerDefinations.get(0);
    }

    public LayerDefination getLayerDefination(String layerName) {
        for (LayerDefination layerDefination : this.layerDefinations) {
            if (!layerDefination.getLayerName().equals(layerName)) continue;
            return layerDefination;
        }
        return null;
    }

    public int getLayerLevel(String layerName) {
        LayerDefination layerDefination = this.getLayerDefination(layerName);
        if (layerDefination == null) {
            throw new IllegalArgumentException(String.format("\u83b7\u53d6\u5c42\u7ea7\u4fe1\u606f\u9519\u8bef\uff0c%s\u5c42\u5728\u5c42\u94fe\u4e2d\u4e0d\u5b58\u5728", layerName));
        }
        return this.layerDefinations.size() - this.layerDefinations.indexOf(layerDefination);
    }

    public int getTopLayerLevel() {
        LayerDefination topLayerDefination = this.getTopLayerDefination();
        return this.getLayerLevel(topLayerDefination.getLayerName());
    }

    public List<LayerDefination> getLayerDefinations() {
        return Collections.unmodifiableList(this.layerDefinations);
    }

    private Map<String, GOTEntity> getEntityIdMap(EntityType entityType) {
        Map<String, GOTEntity> entityIdMap = this.entityIdMaps.get(entityType);
        if (entityIdMap == null) {
            entityIdMap = new LinkedHashMap<String, GOTEntity>();
            this.entityIdMaps.put(entityType, entityIdMap);
        }
        return entityIdMap;
    }

    public Map<String, GOTEntity> getEntitys(EntityType entityType) {
        Map<String, GOTEntity> entityMap = this.entityIdMaps.get(entityType);
        return entityMap != null ? Collections.unmodifiableMap(entityMap) : Collections.emptyMap();
    }

    public GOTEntity getEntityById(EntityType entityType, String entityId) {
        return this.getEntityIdMap(entityType).get(entityId);
    }

    public GOTEntity getEntityByName(EntityType entityType, String entityName) throws NavException {
        for (GOTEntity entity : this.getEntityIdMap(entityType).values()) {
            if (!entity.getName().equals(entityName)) continue;
            return entity;
        }
        return null;
    }

    public List<GOTProperty> getRefEntityPropertys(String entityId) throws VTDException {
        Objects.requireNonNull(entityId, "\u67e5\u627e\u8282\u70b9\u5f15\u7528\u5217\u8868entityId\u4e3anull");
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        String xpath = String.format(".//Property[@refentityid='%s']", entityId);
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                propertys.addAll(entity.selectPropertys(xpath));
            }
        }
        return propertys;
    }

    public List<GOTProperty> getRefInnerPropertys(String entityId, String innerId) throws VTDException {
        Objects.requireNonNull(entityId, "\u67e5\u627e\u8282\u70b9\u5f15\u7528\u5217\u8868entityId\u4e3anull");
        ArrayList<GOTProperty> propertys = new ArrayList<GOTProperty>();
        if (this.catchRefInnerId) {
            List<GOTProperty> list = this.catchRefInnerIdMap.get(String.valueOf(entityId) + "-" + innerId);
            if (list != null) {
                propertys.addAll(list);
            }
            return propertys;
        }
        String xpath = String.format(".//Property[@%s='%s' and @%s='%s']", "refentityid", entityId, "refinnerid", innerId);
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                propertys.addAll(entity.selectPropertys(xpath));
            }
        }
        return propertys;
    }

    public void removeEntity(GOTEntity entity) throws VTDException {
        this.getEntityIdMap(entity.getEntityType()).remove(entity.getId());
        this.removeEntitys.add(entity);
    }

    public List<GOTEntity> getRemoveEntitys() {
        return Collections.unmodifiableList(this.removeEntitys);
    }

    public boolean isSourceDeployment(String layerName, String entityId) {
        if ("app".equals(layerName)) {
            String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
            SolutionDefinition solutionDefinition = this.getSolutionDefinition(solutionName);
            return solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source;
        }
        if ("ext".equals(layerName)) {
            SolutionExtensionDefinition solutionExtensionDefinition;
            String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
            if (entityId.substring(entityId.lastIndexOf(".") + 3).startsWith("5")) {
                SolutionPluginDefinition solutionPluginDefinition = this.getSolutionPluginDefinition(solutionName);
                solutionName = solutionPluginDefinition.getSolutionName();
            }
            return (solutionExtensionDefinition = this.getSolutionExtensionDefinition(solutionName)).getDeploymentMode() == SolutionExtensionDeploymentMode.Source;
        }
        if ("plg".equals(layerName)) {
            if (entityId.substring(entityId.lastIndexOf(".") + 3).startsWith("4")) {
                String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
                SolutionExtensionDefinition solutionExtensionDefinition = this.getSolutionExtensionDefinition(solutionName);
                if (solutionExtensionDefinition != null) {
                    return solutionExtensionDefinition.getDeploymentMode() == SolutionExtensionDeploymentMode.Source;
                }
                SolutionDefinition solutionDefinition = this.getSolutionDefinition(solutionName);
                return solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source;
            }
            String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
            SolutionPluginDefinition solutionPluginDefinition = this.getSolutionPluginDefinition(solutionPluginName);
            return solutionPluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source;
        }
        LayerDefination layerDefination = this.getLayerDefination(layerName);
        return layerDefination.getDeploymentMode() == LayerDeploymentMode.Source;
    }

    public void catchRefInnerId() throws VTDException {
        this.clearCatchRefInnerId();
        String xpath = String.format(".//Property[@%s and @%s]", "refentityid", "refinnerid");
        for (Map<String, GOTEntity> entityMap : this.entityIdMaps.values()) {
            for (GOTEntity entity : entityMap.values()) {
                List<GOTProperty> propertys = entity.selectPropertys(xpath);
                for (GOTProperty property : propertys) {
                    List<GOTProperty> refList = this.catchRefInnerIdMap.get(String.format("%s-%s", property.getRefEntityId(), property.getRefInnerId()));
                    if (refList == null) {
                        refList = new ArrayList<GOTProperty>();
                        this.catchRefInnerIdMap.put(String.format("%s-%s", property.getRefEntityId(), property.getRefInnerId()), refList);
                    }
                    refList.add(property);
                }
            }
        }
        this.catchRefInnerId = true;
    }

    public void clearCatchRefInnerId() {
        this.catchRefInnerIdMap.clear();
        this.catchRefInnerId = false;
    }
}

